# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.check_can_delete_monitor_response import CheckCanDeleteMonitorResponse
from datadog_api_client.v1.model.deleted_monitor import DeletedMonitor
from datadog_api_client.v1.model.monitor import Monitor
from datadog_api_client.v1.model.monitor_group_search_response import MonitorGroupSearchResponse
from datadog_api_client.v1.model.monitor_search_response import MonitorSearchResponse
from datadog_api_client.v1.model.monitor_update_request import MonitorUpdateRequest


class MonitorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._check_can_delete_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (CheckCanDeleteMonitorResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/can_delete",
                "operation_id": "check_can_delete_monitor",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "monitor_ids",
                ],
                "required": [
                    "monitor_ids",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "monitor_ids": ([int],),
                },
                "attribute_map": {
                    "monitor_ids": "monitor_ids",
                },
                "location_map": {
                    "monitor_ids": "query",
                },
                "collection_format_map": {
                    "monitor_ids": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._create_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (Monitor,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor",
                "operation_id": "create_monitor",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (Monitor,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (DeletedMonitor,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/{monitor_id}",
                "operation_id": "delete_monitor",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "monitor_id",
                    "force",
                ],
                "required": [
                    "monitor_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "monitor_id": (int,),
                    "force": (str,),
                },
                "attribute_map": {
                    "monitor_id": "monitor_id",
                    "force": "force",
                },
                "location_map": {
                    "monitor_id": "path",
                    "force": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (Monitor,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/{monitor_id}",
                "operation_id": "get_monitor",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "monitor_id",
                    "group_states",
                ],
                "required": [
                    "monitor_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "monitor_id": (int,),
                    "group_states": (str,),
                },
                "attribute_map": {
                    "monitor_id": "monitor_id",
                    "group_states": "group_states",
                },
                "location_map": {
                    "monitor_id": "path",
                    "group_states": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_monitors_endpoint = _Endpoint(
            settings={
                "response_type": ([Monitor],),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor",
                "operation_id": "list_monitors",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "group_states",
                    "name",
                    "tags",
                    "monitor_tags",
                    "with_downtimes",
                    "id_offset",
                    "page",
                    "page_size",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [
                    "page_size",
                ],
            },
            root_map={
                "validations": {
                    ("page_size",): {
                        "inclusive_maximum": 1000,
                    },
                },
                "allowed_values": {},
                "openapi_types": {
                    "group_states": (str,),
                    "name": (str,),
                    "tags": (str,),
                    "monitor_tags": (str,),
                    "with_downtimes": (bool,),
                    "id_offset": (int,),
                    "page": (int,),
                    "page_size": (int,),
                },
                "attribute_map": {
                    "group_states": "group_states",
                    "name": "name",
                    "tags": "tags",
                    "monitor_tags": "monitor_tags",
                    "with_downtimes": "with_downtimes",
                    "id_offset": "id_offset",
                    "page": "page",
                    "page_size": "page_size",
                },
                "location_map": {
                    "group_states": "query",
                    "name": "query",
                    "tags": "query",
                    "monitor_tags": "query",
                    "with_downtimes": "query",
                    "id_offset": "query",
                    "page": "query",
                    "page_size": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._search_monitor_groups_endpoint = _Endpoint(
            settings={
                "response_type": (MonitorGroupSearchResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/groups/search",
                "operation_id": "search_monitor_groups",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "query",
                    "page",
                    "per_page",
                    "sort",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "query": (str,),
                    "page": (int,),
                    "per_page": (int,),
                    "sort": (str,),
                },
                "attribute_map": {
                    "query": "query",
                    "page": "page",
                    "per_page": "per_page",
                    "sort": "sort",
                },
                "location_map": {
                    "query": "query",
                    "page": "query",
                    "per_page": "query",
                    "sort": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._search_monitors_endpoint = _Endpoint(
            settings={
                "response_type": (MonitorSearchResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/search",
                "operation_id": "search_monitors",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "query",
                    "page",
                    "per_page",
                    "sort",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "query": (str,),
                    "page": (int,),
                    "per_page": (int,),
                    "sort": (str,),
                },
                "attribute_map": {
                    "query": "query",
                    "page": "page",
                    "per_page": "per_page",
                    "sort": "sort",
                },
                "location_map": {
                    "query": "query",
                    "page": "query",
                    "per_page": "query",
                    "sort": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (Monitor,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/{monitor_id}",
                "operation_id": "update_monitor",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "monitor_id",
                    "body",
                ],
                "required": [
                    "monitor_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "monitor_id": (int,),
                    "body": (MonitorUpdateRequest,),
                },
                "attribute_map": {
                    "monitor_id": "monitor_id",
                },
                "location_map": {
                    "monitor_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._validate_monitor_endpoint = _Endpoint(
            settings={
                "response_type": (dict,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monitor/validate",
                "operation_id": "validate_monitor",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (Monitor,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def check_can_delete_monitor(self, monitor_ids, **kwargs):
        """Check if a monitor can be deleted  # noqa: E501

        Check if the given monitors can be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.check_can_delete_monitor(monitor_ids, async_req=True)
        >>> result = thread.get()

        Args:
            monitor_ids ([int]): The IDs of the monitor to check.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CheckCanDeleteMonitorResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._check_can_delete_monitor_endpoint.default_arguments(kwargs)
        kwargs["monitor_ids"] = monitor_ids
        return self._check_can_delete_monitor_endpoint.call_with_http_info(**kwargs)

    def create_monitor(self, body, **kwargs):
        """Create a monitor  # noqa: E501

        Create a monitor using the specified options.  #### Monitor Types  The type of monitor chosen from:  - anomaly: `query alert` - APM: `query alert` or `trace-analytics alert` - composite: `composite` - custom: `service check` - event: `event alert` - forecast: `query alert` - host: `service check` - integration: `query alert` or `service check` - live process: `process alert` - logs: `log alert` - metric: `metric alert` - network: `service check` - outlier: `query alert` - process: `service check` - rum: `rum alert` - SLO: `slo alert` - watchdog: `event alert` - event-v2: `event-v2 alert` - audit: `audit alert`  #### Query Types  **Metric Alert Query**  Example: `time_aggr(time_window):space_aggr:metric{tags} [by {key}] operator #`  - `time_aggr`: avg, sum, max, min, change, or pct_change - `time_window`: `last_#m` (with `#` between 1 and 10080 depending on the monitor type) or `last_#h`(with `#` between 1 and 168 depending on the monitor type) or `last_1d`, or `last_1w` - `space_aggr`: avg, sum, min, or max - `tags`: one or more tags (comma-separated), or * - `key`: a 'key' in key:value tag syntax; defines a separate alert for each tag in the group (multi-alert) - `operator`: <, <=, >, >=, ==, or != - `#`: an integer or decimal number used to set the threshold  If you are using the `_change_` or `_pct_change_` time aggregator, instead use `change_aggr(time_aggr(time_window), timeshift):space_aggr:metric{tags} [by {key}] operator #` with:  - `change_aggr` change, pct_change - `time_aggr` avg, sum, max, min [Learn more](https://docs.datadoghq.com/monitors/monitor_types/#define-the-conditions) - `time_window` last\\_#m (between 1 and 2880 depending on the monitor type), last\\_#h (between 1 and 48 depending on the monitor type), or last_#d (1 or 2) - `timeshift` #m_ago (5, 10, 15, or 30), #h_ago (1, 2, or 4), or 1d_ago  Use this to create an outlier monitor using the following query: `avg(last_30m):outliers(avg:system.cpu.user{role:es-events-data} by {host}, 'dbscan', 7) > 0`  **Service Check Query**  Example: `\"check\".over(tags).last(count).by(group).count_by_status()`  - **`check`** name of the check, e.g. `datadog.agent.up` - **`tags`** one or more quoted tags (comma-separated), or \"*\". e.g.: `.over(\"env:prod\", \"role:db\")`; **`over`** cannot be blank. - **`count`** must be at greater than or equal to your max threshold (defined in the `options`). It is limited to 100. For example, if you've specified to notify on 1 critical, 3 ok, and 2 warn statuses, `count` should be at least 3. - **`group`** must be specified for check monitors. Per-check grouping is already explicitly known for some service checks. For example, Postgres integration monitors are tagged by `db`, `host`, and `port`, and Network monitors by `host`, `instance`, and `url`. See [Service Checks](https://docs.datadoghq.com/api/latest/service-checks/) documentation for more information.  **Event Alert Query**  Example: `events('sources:nagios status:error,warning priority:normal tags: \"string query\"').rollup(\"count\").last(\"1h\")\"`  - **`event`**, the event query string: - **`string_query`** free text query to match against event title and text. - **`sources`** event sources (comma-separated). - **`status`** event statuses (comma-separated). Valid options: error, warn, and info. - **`priority`** event priorities (comma-separated). Valid options: low, normal, all. - **`host`** event reporting host (comma-separated). - **`tags`** event tags (comma-separated). - **`excluded_tags`** excluded event tags (comma-separated). - **`rollup`** the stats roll-up method. `count` is the only supported method now. - **`last`** the timeframe to roll up the counts. Examples: 45m, 4h. Supported timeframes: m, h and d. This value should not exceed 48 hours.  **NOTE** Only available on US1 and EU.  **Event V2 Alert Query**  Example: `events(query).rollup(rollup_method[, measure]).last(time_window) operator #`  - **`query`** The search query - following the [Log search syntax](https://docs.datadoghq.com/logs/search_syntax/). - **`rollup_method`** The stats roll-up method - supports `count`, `avg` and `cardinality`. - **`measure`** For `avg` and cardinality `rollup_method` - specify the measure or the facet name you want to use. - **`time_window`** #m (between 1 and 2880), #h (between 1 and 48). - **`operator`** `<`, `<=`, `>`, `>=`, `==`, or `!=`. - **`#`** an integer or decimal number used to set the threshold.  **NOTE** Only available on US1-FED, US3, and in closed beta on EU and US1.  **Process Alert Query**  Example: `processes(search).over(tags).rollup('count').last(timeframe) operator #`  - **`search`** free text search string for querying processes. Matching processes match results on the [Live Processes](https://docs.datadoghq.com/infrastructure/process/?tab=linuxwindows) page. - **`tags`** one or more tags (comma-separated) - **`timeframe`** the timeframe to roll up the counts. Examples: 10m, 4h. Supported timeframes: s, m, h and d - **`operator`** <, <=, >, >=, ==, or != - **`#`** an integer or decimal number used to set the threshold  **Logs Alert Query**  Example: `logs(query).index(index_name).rollup(rollup_method[, measure]).last(time_window) operator #`  - **`query`** The search query - following the [Log search syntax](https://docs.datadoghq.com/logs/search_syntax/). - **`index_name`** For multi-index organizations, the log index in which the request is performed. - **`rollup_method`** The stats roll-up method - supports `count`, `avg` and `cardinality`. - **`measure`** For `avg` and cardinality `rollup_method` - specify the measure or the facet name you want to use. - **`time_window`** #m (between 1 and 2880), #h (between 1 and 48). - **`operator`** `<`, `<=`, `>`, `>=`, `==`, or `!=`. - **`#`** an integer or decimal number used to set the threshold.  **Composite Query**  Example: `12345 && 67890`, where `12345` and `67890` are the IDs of non-composite monitors  * **`name`** [*required*, *default* = **dynamic, based on query**]: The name of the alert. * **`message`** [*required*, *default* = **dynamic, based on query**]: A message to include with notifications for this monitor. Email notifications can be sent to specific users by using the same '@username' notation as events. * **`tags`** [*optional*, *default* = **empty list**]: A list of tags to associate with your monitor. When getting all monitor details via the API, use the `monitor_tags` argument to filter results by these tags. It is only available via the API and isn't visible or editable in the Datadog UI.  **SLO Alert Query**  Example: `error_budget(\"slo_id\").over(\"time_window\") operator #`  - **`slo_id`**: The alphanumeric SLO ID of the SLO you are configuring the alert for. - **`time_window`**: The time window of the SLO target you wish to alert on. Valid options: `7d`, `30d`, `90d`. - **`operator`**: `>=` or `>`  **Audit Alert Query**  Example: `audits(query).rollup(rollup_method[, measure]).last(time_window) operator #`  - **`query`** The search query - following the [Log search syntax](https://docs.datadoghq.com/logs/search_syntax/). - **`rollup_method`** The stats roll-up method - supports `count`, `avg` and `cardinality`. - **`measure`** For `avg` and cardinality `rollup_method` - specify the measure or the facet name you want to use. - **`time_window`** #m (between 1 and 2880), #h (between 1 and 48). - **`operator`** `<`, `<=`, `>`, `>=`, `==`, or `!=`. - **`#`** an integer or decimal number used to set the threshold.  **NOTE** Only available on US1-FED and in closed beta on EU, US3, and US1.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_monitor(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (Monitor): Create a monitor request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Monitor
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_monitor_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_monitor_endpoint.call_with_http_info(**kwargs)

    def delete_monitor(self, monitor_id, **kwargs):
        """Delete a monitor  # noqa: E501

        Delete the specified monitor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_monitor(monitor_id, async_req=True)
        >>> result = thread.get()

        Args:
            monitor_id (int): The ID of the monitor.

        Keyword Args:
            force (str): Delete the monitor even if it's referenced by other resources (e.g. SLO, composite monitor).. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeletedMonitor
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_monitor_endpoint.default_arguments(kwargs)
        kwargs["monitor_id"] = monitor_id
        return self._delete_monitor_endpoint.call_with_http_info(**kwargs)

    def get_monitor(self, monitor_id, **kwargs):
        """Get a monitor's details  # noqa: E501

        Get details about the specified monitor from your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_monitor(monitor_id, async_req=True)
        >>> result = thread.get()

        Args:
            monitor_id (int): The ID of the monitor

        Keyword Args:
            group_states (str): When specified, shows additional information about the group states. Choose one or more from `all`, `alert`, `warn`, and `no data`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Monitor
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_monitor_endpoint.default_arguments(kwargs)
        kwargs["monitor_id"] = monitor_id
        return self._get_monitor_endpoint.call_with_http_info(**kwargs)

    def list_monitors(self, **kwargs):
        """Get all monitor details  # noqa: E501

        Get details about the specified monitor from your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_monitors(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            group_states (str): When specified, shows additional information about the group states. Choose one or more from `all`, `alert`, `warn`, and `no data`.. [optional]
            name (str): A string to filter monitors by name.. [optional]
            tags (str): A comma separated list indicating what tags, if any, should be used to filter the list of monitors by scope. For example, `host:host0`.. [optional]
            monitor_tags (str): A comma separated list indicating what service and/or custom tags, if any, should be used to filter the list of monitors. Tags created in the Datadog UI automatically have the service key prepended. For example, `service:my-app`.. [optional]
            with_downtimes (bool): If this argument is set to true, then the returned data includes all current downtimes for each monitor.. [optional]
            id_offset (int): Monitor ID offset.. [optional]
            page (int): The page to start paginating from. If this argument is not specified, the request returns all monitors without pagination.. [optional]
            page_size (int): The number of monitors to return per page. If the page argument is not specified, the default behavior returns all monitors without a `page_size` limit. However, if page is specified and `page_size` is not, the argument defaults to 100.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Monitor]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_monitors_endpoint.default_arguments(kwargs)
        return self._list_monitors_endpoint.call_with_http_info(**kwargs)

    def search_monitor_groups(self, **kwargs):
        """Monitors group search  # noqa: E501

        Search and filter your monitor groups details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_monitor_groups(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            query (str): After entering a search query in your [Manage Monitor page][1] use the query parameter value in the URL of the page as value for this parameter. Consult the dedicated [manage monitor documentation][2] page to learn more.  The query can contain any number of space-separated monitor attributes, for instance `query=\"type:metric status:alert\"`.  [1]: https://app.datadoghq.com/monitors/manage [2]: /monitors/manage_monitor/#find-the-monitors. [optional]
            page (int): Page to start paginating from.. [optional] if omitted the server will use the default value of 0
            per_page (int): Number of monitors to return per page.. [optional] if omitted the server will use the default value of 30
            sort (str): String for sort order, composed of field and sort order separate by a comma, e.g. `name,asc`. Supported sort directions: `asc`, `desc`. Supported fields:  * `name` * `status` * `tags`. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MonitorGroupSearchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._search_monitor_groups_endpoint.default_arguments(kwargs)
        return self._search_monitor_groups_endpoint.call_with_http_info(**kwargs)

    def search_monitors(self, **kwargs):
        """Monitors search  # noqa: E501

        Search and filter your monitors details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_monitors(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            query (str): After entering a search query in your [Manage Monitor page][1] use the query parameter value in the URL of the page as value for this parameter. Consult the dedicated [manage monitor documentation][2] page to learn more.  The query can contain any number of space-separated monitor attributes, for instance `query=\"type:metric status:alert\"`.  [1]: https://app.datadoghq.com/monitors/manage [2]: /monitors/manage_monitor/#find-the-monitors. [optional]
            page (int): Page to start paginating from.. [optional] if omitted the server will use the default value of 0
            per_page (int): Number of monitors to return per page.. [optional] if omitted the server will use the default value of 30
            sort (str): String for sort order, composed of field and sort order separate by a comma, e.g. `name,asc`. Supported sort directions: `asc`, `desc`. Supported fields:  * `name` * `status` * `tags`. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MonitorSearchResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._search_monitors_endpoint.default_arguments(kwargs)
        return self._search_monitors_endpoint.call_with_http_info(**kwargs)

    def update_monitor(self, monitor_id, body, **kwargs):
        """Edit a monitor  # noqa: E501

        Edit the specified monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_monitor(monitor_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            monitor_id (int): The ID of the monitor.
            body (MonitorUpdateRequest): Edit a monitor request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Monitor
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_monitor_endpoint.default_arguments(kwargs)
        kwargs["monitor_id"] = monitor_id
        kwargs["body"] = body
        return self._update_monitor_endpoint.call_with_http_info(**kwargs)

    def validate_monitor(self, body, **kwargs):
        """Validate a monitor  # noqa: E501

        Validate the monitor provided in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_monitor(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (Monitor): Monitor request object

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            dict
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._validate_monitor_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._validate_monitor_endpoint.call_with_http_info(**kwargs)
