# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.notebook_create_request import NotebookCreateRequest
from datadog_api_client.v1.model.notebook_response import NotebookResponse
from datadog_api_client.v1.model.notebook_update_request import NotebookUpdateRequest
from datadog_api_client.v1.model.notebooks_response import NotebooksResponse


class NotebooksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_notebook_endpoint = _Endpoint(
            settings={
                "response_type": (NotebookResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/notebooks",
                "operation_id": "create_notebook",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (NotebookCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_notebook_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/notebooks/{notebook_id}",
                "operation_id": "delete_notebook",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "notebook_id",
                ],
                "required": [
                    "notebook_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "notebook_id": (int,),
                },
                "attribute_map": {
                    "notebook_id": "notebook_id",
                },
                "location_map": {
                    "notebook_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_notebook_endpoint = _Endpoint(
            settings={
                "response_type": (NotebookResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/notebooks/{notebook_id}",
                "operation_id": "get_notebook",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "notebook_id",
                ],
                "required": [
                    "notebook_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "notebook_id": (int,),
                },
                "attribute_map": {
                    "notebook_id": "notebook_id",
                },
                "location_map": {
                    "notebook_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_notebooks_endpoint = _Endpoint(
            settings={
                "response_type": (NotebooksResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/notebooks",
                "operation_id": "list_notebooks",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "author_handle",
                    "exclude_author_handle",
                    "start",
                    "count",
                    "sort_field",
                    "sort_dir",
                    "query",
                    "include_cells",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "author_handle": (str,),
                    "exclude_author_handle": (str,),
                    "start": (int,),
                    "count": (int,),
                    "sort_field": (str,),
                    "sort_dir": (str,),
                    "query": (str,),
                    "include_cells": (bool,),
                },
                "attribute_map": {
                    "author_handle": "author_handle",
                    "exclude_author_handle": "exclude_author_handle",
                    "start": "start",
                    "count": "count",
                    "sort_field": "sort_field",
                    "sort_dir": "sort_dir",
                    "query": "query",
                    "include_cells": "include_cells",
                },
                "location_map": {
                    "author_handle": "query",
                    "exclude_author_handle": "query",
                    "start": "query",
                    "count": "query",
                    "sort_field": "query",
                    "sort_dir": "query",
                    "query": "query",
                    "include_cells": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_notebook_endpoint = _Endpoint(
            settings={
                "response_type": (NotebookResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/notebooks/{notebook_id}",
                "operation_id": "update_notebook",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "notebook_id",
                    "body",
                ],
                "required": [
                    "notebook_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "notebook_id": (int,),
                    "body": (NotebookUpdateRequest,),
                },
                "attribute_map": {
                    "notebook_id": "notebook_id",
                },
                "location_map": {
                    "notebook_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_notebook(self, body, **kwargs):
        """Create a notebook  # noqa: E501

        Create a notebook using the specified options.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_notebook(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (NotebookCreateRequest): The JSON description of the notebook you want to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NotebookResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_notebook_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_notebook_endpoint.call_with_http_info(**kwargs)

    def delete_notebook(self, notebook_id, **kwargs):
        """Delete a notebook  # noqa: E501

        Delete a notebook using the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_notebook(notebook_id, async_req=True)
        >>> result = thread.get()

        Args:
            notebook_id (int): Unique ID, assigned when you create the notebook.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_notebook_endpoint.default_arguments(kwargs)
        kwargs["notebook_id"] = notebook_id
        return self._delete_notebook_endpoint.call_with_http_info(**kwargs)

    def get_notebook(self, notebook_id, **kwargs):
        """Get a notebook  # noqa: E501

        Get a notebook using the specified notebook ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notebook(notebook_id, async_req=True)
        >>> result = thread.get()

        Args:
            notebook_id (int): Unique ID, assigned when you create the notebook.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NotebookResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_notebook_endpoint.default_arguments(kwargs)
        kwargs["notebook_id"] = notebook_id
        return self._get_notebook_endpoint.call_with_http_info(**kwargs)

    def list_notebooks(self, **kwargs):
        """Get all notebooks  # noqa: E501

        Get all notebooks. This can also be used to search for notebooks with a particular `query` in the notebook `name` or author `handle`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_notebooks(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            author_handle (str): Return notebooks created by the given `author_handle`.. [optional]
            exclude_author_handle (str): Return notebooks not created by the given `author_handle`.. [optional]
            start (int): The index of the first notebook you want returned.. [optional]
            count (int): The number of notebooks to be returned.. [optional]
            sort_field (str): Sort by field `modified` or `name`.. [optional] if omitted the server will use the default value of "modified"
            sort_dir (str): Sort by direction `asc` or `desc`.. [optional] if omitted the server will use the default value of "desc"
            query (str): Return only notebooks with `query` string in notebook name or author handle.. [optional]
            include_cells (bool): Value of `false` excludes the `cells` and global `time` for each notebook.. [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NotebooksResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_notebooks_endpoint.default_arguments(kwargs)
        return self._list_notebooks_endpoint.call_with_http_info(**kwargs)

    def update_notebook(self, notebook_id, body, **kwargs):
        """Update a notebook  # noqa: E501

        Update a notebook using the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_notebook(notebook_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            notebook_id (int): Unique ID, assigned when you create the notebook.
            body (NotebookUpdateRequest): Update notebook request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NotebookResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_notebook_endpoint.default_arguments(kwargs)
        kwargs["notebook_id"] = notebook_id
        kwargs["body"] = body
        return self._update_notebook_endpoint.call_with_http_info(**kwargs)
