# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.slo_correction_create_request import SLOCorrectionCreateRequest
from datadog_api_client.v1.model.slo_correction_list_response import SLOCorrectionListResponse
from datadog_api_client.v1.model.slo_correction_response import SLOCorrectionResponse
from datadog_api_client.v1.model.slo_correction_update_request import SLOCorrectionUpdateRequest


class ServiceLevelObjectiveCorrectionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_slo_correction_endpoint = _Endpoint(
            settings={
                "response_type": (SLOCorrectionResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/correction",
                "operation_id": "create_slo_correction",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SLOCorrectionCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_slo_correction_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/correction/{slo_correction_id}",
                "operation_id": "delete_slo_correction",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_correction_id",
                ],
                "required": [
                    "slo_correction_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_correction_id": (str,),
                },
                "attribute_map": {
                    "slo_correction_id": "slo_correction_id",
                },
                "location_map": {
                    "slo_correction_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_slo_correction_endpoint = _Endpoint(
            settings={
                "response_type": (SLOCorrectionResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/correction/{slo_correction_id}",
                "operation_id": "get_slo_correction",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_correction_id",
                ],
                "required": [
                    "slo_correction_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_correction_id": (str,),
                },
                "attribute_map": {
                    "slo_correction_id": "slo_correction_id",
                },
                "location_map": {
                    "slo_correction_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_slo_correction_endpoint = _Endpoint(
            settings={
                "response_type": (SLOCorrectionListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/correction",
                "operation_id": "list_slo_correction",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_slo_correction_endpoint = _Endpoint(
            settings={
                "response_type": (SLOCorrectionResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/correction/{slo_correction_id}",
                "operation_id": "update_slo_correction",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_correction_id",
                    "body",
                ],
                "required": [
                    "slo_correction_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_correction_id": (str,),
                    "body": (SLOCorrectionUpdateRequest,),
                },
                "attribute_map": {
                    "slo_correction_id": "slo_correction_id",
                },
                "location_map": {
                    "slo_correction_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_slo_correction(self, body, **kwargs):
        """Create an SLO correction  # noqa: E501

        Create an SLO Correction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_slo_correction(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SLOCorrectionCreateRequest): Create an SLO Correction

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOCorrectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_slo_correction_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_slo_correction_endpoint.call_with_http_info(**kwargs)

    def delete_slo_correction(self, slo_correction_id, **kwargs):
        """Delete an SLO correction  # noqa: E501

        Permanently delete the specified SLO correction object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_slo_correction(slo_correction_id, async_req=True)
        >>> result = thread.get()

        Args:
            slo_correction_id (str): The ID of the SLO correction object

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_slo_correction_endpoint.default_arguments(kwargs)
        kwargs["slo_correction_id"] = slo_correction_id
        return self._delete_slo_correction_endpoint.call_with_http_info(**kwargs)

    def get_slo_correction(self, slo_correction_id, **kwargs):
        """Get an SLO correction for an SLO  # noqa: E501

        Get an SLO correction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_slo_correction(slo_correction_id, async_req=True)
        >>> result = thread.get()

        Args:
            slo_correction_id (str): The ID of the SLO correction object

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOCorrectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_slo_correction_endpoint.default_arguments(kwargs)
        kwargs["slo_correction_id"] = slo_correction_id
        return self._get_slo_correction_endpoint.call_with_http_info(**kwargs)

    def list_slo_correction(self, **kwargs):
        """Get all SLO corrections  # noqa: E501

        Get all Service Level Objective corrections  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_slo_correction(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOCorrectionListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_slo_correction_endpoint.default_arguments(kwargs)
        return self._list_slo_correction_endpoint.call_with_http_info(**kwargs)

    def update_slo_correction(self, slo_correction_id, body, **kwargs):
        """Update an SLO correction  # noqa: E501

        Update the specified SLO correction object object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_slo_correction(slo_correction_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            slo_correction_id (str): The ID of the SLO correction object
            body (SLOCorrectionUpdateRequest): The edited SLO correction object.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOCorrectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_slo_correction_endpoint.default_arguments(kwargs)
        kwargs["slo_correction_id"] = slo_correction_id
        kwargs["body"] = body
        return self._update_slo_correction_endpoint.call_with_http_info(**kwargs)
