# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.check_can_delete_slo_response import CheckCanDeleteSLOResponse
from datadog_api_client.v1.model.slo_bulk_delete import SLOBulkDelete
from datadog_api_client.v1.model.slo_bulk_delete_response import SLOBulkDeleteResponse
from datadog_api_client.v1.model.slo_delete_response import SLODeleteResponse
from datadog_api_client.v1.model.slo_history_response import SLOHistoryResponse
from datadog_api_client.v1.model.slo_list_response import SLOListResponse
from datadog_api_client.v1.model.slo_response import SLOResponse
from datadog_api_client.v1.model.service_level_objective import ServiceLevelObjective
from datadog_api_client.v1.model.service_level_objective_request import ServiceLevelObjectiveRequest


class ServiceLevelObjectivesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._check_can_delete_slo_endpoint = _Endpoint(
            settings={
                "response_type": (CheckCanDeleteSLOResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/can_delete",
                "operation_id": "check_can_delete_slo",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "ids",
                ],
                "required": [
                    "ids",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "ids": (str,),
                },
                "attribute_map": {
                    "ids": "ids",
                },
                "location_map": {
                    "ids": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._create_slo_endpoint = _Endpoint(
            settings={
                "response_type": (SLOListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo",
                "operation_id": "create_slo",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (ServiceLevelObjectiveRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_slo_endpoint = _Endpoint(
            settings={
                "response_type": (SLODeleteResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/{slo_id}",
                "operation_id": "delete_slo",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_id",
                    "force",
                ],
                "required": [
                    "slo_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_id": (str,),
                    "force": (str,),
                },
                "attribute_map": {
                    "slo_id": "slo_id",
                    "force": "force",
                },
                "location_map": {
                    "slo_id": "path",
                    "force": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_slo_timeframe_in_bulk_endpoint = _Endpoint(
            settings={
                "response_type": (SLOBulkDeleteResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/bulk_delete",
                "operation_id": "delete_slo_timeframe_in_bulk",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SLOBulkDelete,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._get_slo_endpoint = _Endpoint(
            settings={
                "response_type": (SLOResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/{slo_id}",
                "operation_id": "get_slo",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_id",
                    "with_configured_alert_ids",
                ],
                "required": [
                    "slo_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_id": (str,),
                    "with_configured_alert_ids": (bool,),
                },
                "attribute_map": {
                    "slo_id": "slo_id",
                    "with_configured_alert_ids": "with_configured_alert_ids",
                },
                "location_map": {
                    "slo_id": "path",
                    "with_configured_alert_ids": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_slo_history_endpoint = _Endpoint(
            settings={
                "response_type": (SLOHistoryResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/{slo_id}/history",
                "operation_id": "get_slo_history",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_id",
                    "from_ts",
                    "to_ts",
                    "target",
                ],
                "required": [
                    "slo_id",
                    "from_ts",
                    "to_ts",
                ],
                "nullable": [],
                "enum": [],
                "validation": [
                    "target",
                ],
            },
            root_map={
                "validations": {
                    ("target",): {
                        "exclusive_maximum": 100,
                        "exclusive_minimum": 0,
                    },
                },
                "allowed_values": {},
                "openapi_types": {
                    "slo_id": (str,),
                    "from_ts": (int,),
                    "to_ts": (int,),
                    "target": (float,),
                },
                "attribute_map": {
                    "slo_id": "slo_id",
                    "from_ts": "from_ts",
                    "to_ts": "to_ts",
                    "target": "target",
                },
                "location_map": {
                    "slo_id": "path",
                    "from_ts": "query",
                    "to_ts": "query",
                    "target": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_slos_endpoint = _Endpoint(
            settings={
                "response_type": (SLOListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo",
                "operation_id": "list_slos",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "ids",
                    "query",
                    "tags_query",
                    "metrics_query",
                    "limit",
                    "offset",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "ids": (str,),
                    "query": (str,),
                    "tags_query": (str,),
                    "metrics_query": (str,),
                    "limit": (int,),
                    "offset": (int,),
                },
                "attribute_map": {
                    "ids": "ids",
                    "query": "query",
                    "tags_query": "tags_query",
                    "metrics_query": "metrics_query",
                    "limit": "limit",
                    "offset": "offset",
                },
                "location_map": {
                    "ids": "query",
                    "query": "query",
                    "tags_query": "query",
                    "metrics_query": "query",
                    "limit": "query",
                    "offset": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_slo_endpoint = _Endpoint(
            settings={
                "response_type": (SLOListResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/slo/{slo_id}",
                "operation_id": "update_slo",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "slo_id",
                    "body",
                ],
                "required": [
                    "slo_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "slo_id": (str,),
                    "body": (ServiceLevelObjective,),
                },
                "attribute_map": {
                    "slo_id": "slo_id",
                },
                "location_map": {
                    "slo_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def check_can_delete_slo(self, ids, **kwargs):
        """Check if SLOs can be safely deleted  # noqa: E501

        Check if an SLO can be safely deleted. For example, assure an SLO can be deleted without disrupting a dashboard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.check_can_delete_slo(ids, async_req=True)
        >>> result = thread.get()

        Args:
            ids (str): A comma separated list of the IDs of the service level objectives objects.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CheckCanDeleteSLOResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._check_can_delete_slo_endpoint.default_arguments(kwargs)
        kwargs["ids"] = ids
        return self._check_can_delete_slo_endpoint.call_with_http_info(**kwargs)

    def create_slo(self, body, **kwargs):
        """Create an SLO object  # noqa: E501

        Create a service level objective object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_slo(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (ServiceLevelObjectiveRequest): Service level objective request object.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_slo_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_slo_endpoint.call_with_http_info(**kwargs)

    def delete_slo(self, slo_id, **kwargs):
        """Delete an SLO  # noqa: E501

        Permanently delete the specified service level objective object.  If an SLO is used in a dashboard, the `DELETE /v1/slo/` endpoint returns a 409 conflict error because the SLO is referenced in a dashboard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_slo(slo_id, async_req=True)
        >>> result = thread.get()

        Args:
            slo_id (str): The ID of the service level objective.

        Keyword Args:
            force (str): Delete the monitor even if it's referenced by other resources (e.g. SLO, composite monitor).. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLODeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_slo_endpoint.default_arguments(kwargs)
        kwargs["slo_id"] = slo_id
        return self._delete_slo_endpoint.call_with_http_info(**kwargs)

    def delete_slo_timeframe_in_bulk(self, body, **kwargs):
        """Bulk Delete SLO Timeframes  # noqa: E501

        Delete (or partially delete) multiple service level objective objects.  This endpoint facilitates deletion of one or more thresholds for one or more service level objective objects. If all thresholds are deleted, the service level objective object is deleted as well.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_slo_timeframe_in_bulk(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SLOBulkDelete): Delete multiple service level objective objects request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOBulkDeleteResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_slo_timeframe_in_bulk_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._delete_slo_timeframe_in_bulk_endpoint.call_with_http_info(**kwargs)

    def get_slo(self, slo_id, **kwargs):
        """Get an SLO's details  # noqa: E501

        Get a service level objective object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_slo(slo_id, async_req=True)
        >>> result = thread.get()

        Args:
            slo_id (str): The ID of the service level objective object.

        Keyword Args:
            with_configured_alert_ids (bool): Get the IDs of SLO monitors that reference this SLO.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_slo_endpoint.default_arguments(kwargs)
        kwargs["slo_id"] = slo_id
        return self._get_slo_endpoint.call_with_http_info(**kwargs)

    def get_slo_history(self, slo_id, from_ts, to_ts, **kwargs):
        """Get an SLO's history  # noqa: E501

        Get a specific SLO’s history, regardless of its SLO type.  The detailed history data is structured according to the source data type. For example, metric data is included for event SLOs that use the metric source, and monitor SLO types include the monitor transition history.  **Note:** There are different response formats for event based and time based SLOs. Examples of both are shown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_slo_history(slo_id, from_ts, to_ts, async_req=True)
        >>> result = thread.get()

        Args:
            slo_id (str): The ID of the service level objective object.
            from_ts (int): The `from` timestamp for the query window in epoch seconds.
            to_ts (int): The `to` timestamp for the query window in epoch seconds.

        Keyword Args:
            target (float): The SLO target. If `target` is passed in, the response will include the remaining error budget and a timeframe value of `custom`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOHistoryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_slo_history_endpoint.default_arguments(kwargs)
        kwargs["slo_id"] = slo_id
        kwargs["from_ts"] = from_ts
        kwargs["to_ts"] = to_ts
        return self._get_slo_history_endpoint.call_with_http_info(**kwargs)

    def list_slos(self, **kwargs):
        """Get all SLOs  # noqa: E501

        Get a list of service level objective objects for your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_slos(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            ids (str): A comma separated list of the IDs of the service level objectives objects.. [optional]
            query (str): The query string to filter results based on SLO names.. [optional]
            tags_query (str): The query string to filter results based on a single SLO tag.. [optional]
            metrics_query (str): The query string to filter results based on SLO numerator and denominator.. [optional]
            limit (int): The number of SLOs to return in the response.. [optional]
            offset (int): The specific offset to use as the beginning of the returned response.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_slos_endpoint.default_arguments(kwargs)
        return self._list_slos_endpoint.call_with_http_info(**kwargs)

    def update_slo(self, slo_id, body, **kwargs):
        """Update an SLO  # noqa: E501

        Update the specified service level objective object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_slo(slo_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            slo_id (str): The ID of the service level objective object.
            body (ServiceLevelObjective): The edited service level objective request object.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SLOListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_slo_endpoint.default_arguments(kwargs)
        kwargs["slo_id"] = slo_id
        kwargs["body"] = body
        return self._update_slo_endpoint.call_with_http_info(**kwargs)
