# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.slack_integration_channel import SlackIntegrationChannel
from datadog_api_client.v1.model.slack_integration_channels import SlackIntegrationChannels


class SlackIntegrationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_slack_integration_channel_endpoint = _Endpoint(
            settings={
                "response_type": (SlackIntegrationChannel,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/slack/configuration/accounts/{account_name}/channels",
                "operation_id": "create_slack_integration_channel",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "account_name",
                    "body",
                ],
                "required": [
                    "account_name",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "account_name": (str,),
                    "body": (SlackIntegrationChannel,),
                },
                "attribute_map": {
                    "account_name": "account_name",
                },
                "location_map": {
                    "account_name": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._get_slack_integration_channel_endpoint = _Endpoint(
            settings={
                "response_type": (SlackIntegrationChannel,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}",
                "operation_id": "get_slack_integration_channel",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "account_name",
                    "channel_name",
                ],
                "required": [
                    "account_name",
                    "channel_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "account_name": (str,),
                    "channel_name": (str,),
                },
                "attribute_map": {
                    "account_name": "account_name",
                    "channel_name": "channel_name",
                },
                "location_map": {
                    "account_name": "path",
                    "channel_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_slack_integration_channels_endpoint = _Endpoint(
            settings={
                "response_type": (SlackIntegrationChannels,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/slack/configuration/accounts/{account_name}/channels",
                "operation_id": "get_slack_integration_channels",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "account_name",
                ],
                "required": [
                    "account_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "account_name": (str,),
                },
                "attribute_map": {
                    "account_name": "account_name",
                },
                "location_map": {
                    "account_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._remove_slack_integration_channel_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}",
                "operation_id": "remove_slack_integration_channel",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "account_name",
                    "channel_name",
                ],
                "required": [
                    "account_name",
                    "channel_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "account_name": (str,),
                    "channel_name": (str,),
                },
                "attribute_map": {
                    "account_name": "account_name",
                    "channel_name": "channel_name",
                },
                "location_map": {
                    "account_name": "path",
                    "channel_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_slack_integration_channel_endpoint = _Endpoint(
            settings={
                "response_type": (SlackIntegrationChannel,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/slack/configuration/accounts/{account_name}/channels/{channel_name}",
                "operation_id": "update_slack_integration_channel",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "account_name",
                    "channel_name",
                    "body",
                ],
                "required": [
                    "account_name",
                    "channel_name",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "account_name": (str,),
                    "channel_name": (str,),
                    "body": (SlackIntegrationChannel,),
                },
                "attribute_map": {
                    "account_name": "account_name",
                    "channel_name": "channel_name",
                },
                "location_map": {
                    "account_name": "path",
                    "channel_name": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_slack_integration_channel(self, account_name, body, **kwargs):
        """Create a Slack integration channel  # noqa: E501

        Add a channel to your Datadog-Slack integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_slack_integration_channel(account_name, body, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Your Slack account name.
            body (SlackIntegrationChannel): Payload describing Slack channel to be created

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SlackIntegrationChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_slack_integration_channel_endpoint.default_arguments(kwargs)
        kwargs["account_name"] = account_name
        kwargs["body"] = body
        return self._create_slack_integration_channel_endpoint.call_with_http_info(**kwargs)

    def get_slack_integration_channel(self, account_name, channel_name, **kwargs):
        """Get a Slack integration channel  # noqa: E501

        Get a channel configured for your Datadog-Slack integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_slack_integration_channel(account_name, channel_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Your Slack account name.
            channel_name (str): The name of the Slack channel being operated on.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SlackIntegrationChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_slack_integration_channel_endpoint.default_arguments(kwargs)
        kwargs["account_name"] = account_name
        kwargs["channel_name"] = channel_name
        return self._get_slack_integration_channel_endpoint.call_with_http_info(**kwargs)

    def get_slack_integration_channels(self, account_name, **kwargs):
        """Get all channels in a Slack integration  # noqa: E501

        Get a list of all channels configured for your Datadog-Slack integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_slack_integration_channels(account_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Your Slack account name.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SlackIntegrationChannels
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_slack_integration_channels_endpoint.default_arguments(kwargs)
        kwargs["account_name"] = account_name
        return self._get_slack_integration_channels_endpoint.call_with_http_info(**kwargs)

    def remove_slack_integration_channel(self, account_name, channel_name, **kwargs):
        """Remove a Slack integration channel  # noqa: E501

        Remove a channel from your Datadog-Slack integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_slack_integration_channel(account_name, channel_name, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Your Slack account name.
            channel_name (str): The name of the Slack channel being operated on.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._remove_slack_integration_channel_endpoint.default_arguments(kwargs)
        kwargs["account_name"] = account_name
        kwargs["channel_name"] = channel_name
        return self._remove_slack_integration_channel_endpoint.call_with_http_info(**kwargs)

    def update_slack_integration_channel(self, account_name, channel_name, body, **kwargs):
        """Update a Slack integration channel  # noqa: E501

        Update a channel used in your Datadog-Slack integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_slack_integration_channel(account_name, channel_name, body, async_req=True)
        >>> result = thread.get()

        Args:
            account_name (str): Your Slack account name.
            channel_name (str): The name of the Slack channel being operated on.
            body (SlackIntegrationChannel): Payload describing fields and values to be updated.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SlackIntegrationChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_slack_integration_channel_endpoint.default_arguments(kwargs)
        kwargs["account_name"] = account_name
        kwargs["channel_name"] = channel_name
        kwargs["body"] = body
        return self._update_slack_integration_channel_endpoint.call_with_http_info(**kwargs)
