# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.synthetics_api_test import SyntheticsAPITest
from datadog_api_client.v1.model.synthetics_api_test_result_full import SyntheticsAPITestResultFull
from datadog_api_client.v1.model.synthetics_browser_test import SyntheticsBrowserTest
from datadog_api_client.v1.model.synthetics_browser_test_result_full import SyntheticsBrowserTestResultFull
from datadog_api_client.v1.model.synthetics_ci_test_body import SyntheticsCITestBody
from datadog_api_client.v1.model.synthetics_delete_tests_payload import SyntheticsDeleteTestsPayload
from datadog_api_client.v1.model.synthetics_delete_tests_response import SyntheticsDeleteTestsResponse
from datadog_api_client.v1.model.synthetics_get_api_test_latest_results_response import (
    SyntheticsGetAPITestLatestResultsResponse,
)
from datadog_api_client.v1.model.synthetics_get_browser_test_latest_results_response import (
    SyntheticsGetBrowserTestLatestResultsResponse,
)
from datadog_api_client.v1.model.synthetics_global_variable import SyntheticsGlobalVariable
from datadog_api_client.v1.model.synthetics_list_global_variables_response import SyntheticsListGlobalVariablesResponse
from datadog_api_client.v1.model.synthetics_list_tests_response import SyntheticsListTestsResponse
from datadog_api_client.v1.model.synthetics_locations import SyntheticsLocations
from datadog_api_client.v1.model.synthetics_private_location import SyntheticsPrivateLocation
from datadog_api_client.v1.model.synthetics_private_location_creation_response import (
    SyntheticsPrivateLocationCreationResponse,
)
from datadog_api_client.v1.model.synthetics_test_details import SyntheticsTestDetails
from datadog_api_client.v1.model.synthetics_trigger_ci_tests_response import SyntheticsTriggerCITestsResponse
from datadog_api_client.v1.model.synthetics_update_test_pause_status_payload import (
    SyntheticsUpdateTestPauseStatusPayload,
)


class SyntheticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_global_variable_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsGlobalVariable,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/variables",
                "operation_id": "create_global_variable",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsGlobalVariable,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_private_location_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsPrivateLocationCreationResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/private-locations",
                "operation_id": "create_private_location",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsPrivateLocation,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_synthetics_api_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsAPITest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/api",
                "operation_id": "create_synthetics_api_test",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsAPITest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_synthetics_browser_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsBrowserTest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/browser",
                "operation_id": "create_synthetics_browser_test",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsBrowserTest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_global_variable_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/variables/{variable_id}",
                "operation_id": "delete_global_variable",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "variable_id",
                ],
                "required": [
                    "variable_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "variable_id": (str,),
                },
                "attribute_map": {
                    "variable_id": "variable_id",
                },
                "location_map": {
                    "variable_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_private_location_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/private-locations/{location_id}",
                "operation_id": "delete_private_location",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "location_id",
                ],
                "required": [
                    "location_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "location_id": (str,),
                },
                "attribute_map": {
                    "location_id": "location_id",
                },
                "location_map": {
                    "location_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_tests_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsDeleteTestsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/delete",
                "operation_id": "delete_tests",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsDeleteTestsPayload,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._edit_global_variable_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsGlobalVariable,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/variables/{variable_id}",
                "operation_id": "edit_global_variable",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "variable_id",
                    "body",
                ],
                "required": [
                    "variable_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "variable_id": (str,),
                    "body": (SyntheticsGlobalVariable,),
                },
                "attribute_map": {
                    "variable_id": "variable_id",
                },
                "location_map": {
                    "variable_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._get_api_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsAPITest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/api/{public_id}",
                "operation_id": "get_api_test",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                ],
                "required": [
                    "public_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_api_test_latest_results_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsGetAPITestLatestResultsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/{public_id}/results",
                "operation_id": "get_api_test_latest_results",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "from_ts",
                    "to_ts",
                    "probe_dc",
                ],
                "required": [
                    "public_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "from_ts": (int,),
                    "to_ts": (int,),
                    "probe_dc": ([str],),
                },
                "attribute_map": {
                    "public_id": "public_id",
                    "from_ts": "from_ts",
                    "to_ts": "to_ts",
                    "probe_dc": "probe_dc",
                },
                "location_map": {
                    "public_id": "path",
                    "from_ts": "query",
                    "to_ts": "query",
                    "probe_dc": "query",
                },
                "collection_format_map": {
                    "probe_dc": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_api_test_result_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsAPITestResultFull,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/{public_id}/results/{result_id}",
                "operation_id": "get_api_test_result",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "result_id",
                ],
                "required": [
                    "public_id",
                    "result_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "result_id": (str,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                    "result_id": "result_id",
                },
                "location_map": {
                    "public_id": "path",
                    "result_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_browser_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsBrowserTest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/browser/{public_id}",
                "operation_id": "get_browser_test",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                ],
                "required": [
                    "public_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_browser_test_latest_results_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsGetBrowserTestLatestResultsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/browser/{public_id}/results",
                "operation_id": "get_browser_test_latest_results",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "from_ts",
                    "to_ts",
                    "probe_dc",
                ],
                "required": [
                    "public_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "from_ts": (int,),
                    "to_ts": (int,),
                    "probe_dc": ([str],),
                },
                "attribute_map": {
                    "public_id": "public_id",
                    "from_ts": "from_ts",
                    "to_ts": "to_ts",
                    "probe_dc": "probe_dc",
                },
                "location_map": {
                    "public_id": "path",
                    "from_ts": "query",
                    "to_ts": "query",
                    "probe_dc": "query",
                },
                "collection_format_map": {
                    "probe_dc": "multi",
                },
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_browser_test_result_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsBrowserTestResultFull,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}",
                "operation_id": "get_browser_test_result",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "result_id",
                ],
                "required": [
                    "public_id",
                    "result_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "result_id": (str,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                    "result_id": "result_id",
                },
                "location_map": {
                    "public_id": "path",
                    "result_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_global_variable_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsGlobalVariable,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/variables/{variable_id}",
                "operation_id": "get_global_variable",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "variable_id",
                ],
                "required": [
                    "variable_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "variable_id": (str,),
                },
                "attribute_map": {
                    "variable_id": "variable_id",
                },
                "location_map": {
                    "variable_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_private_location_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsPrivateLocation,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/private-locations/{location_id}",
                "operation_id": "get_private_location",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "location_id",
                ],
                "required": [
                    "location_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "location_id": (str,),
                },
                "attribute_map": {
                    "location_id": "location_id",
                },
                "location_map": {
                    "location_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsTestDetails,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/{public_id}",
                "operation_id": "get_test",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                ],
                "required": [
                    "public_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_global_variables_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsListGlobalVariablesResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/variables",
                "operation_id": "list_global_variables",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_locations_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsLocations,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/locations",
                "operation_id": "list_locations",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_tests_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsListTestsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests",
                "operation_id": "list_tests",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._trigger_ci_tests_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsTriggerCITestsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/trigger/ci",
                "operation_id": "trigger_ci_tests",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (SyntheticsCITestBody,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_api_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsAPITest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/api/{public_id}",
                "operation_id": "update_api_test",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "body",
                ],
                "required": [
                    "public_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "body": (SyntheticsAPITest,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_browser_test_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsBrowserTest,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/browser/{public_id}",
                "operation_id": "update_browser_test",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "body",
                ],
                "required": [
                    "public_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "body": (SyntheticsBrowserTest,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_private_location_endpoint = _Endpoint(
            settings={
                "response_type": (SyntheticsPrivateLocation,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/private-locations/{location_id}",
                "operation_id": "update_private_location",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "location_id",
                    "body",
                ],
                "required": [
                    "location_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "location_id": (str,),
                    "body": (SyntheticsPrivateLocation,),
                },
                "attribute_map": {
                    "location_id": "location_id",
                },
                "location_map": {
                    "location_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_test_pause_status_endpoint = _Endpoint(
            settings={
                "response_type": (bool,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/synthetics/tests/{public_id}/status",
                "operation_id": "update_test_pause_status",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "public_id",
                    "body",
                ],
                "required": [
                    "public_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "public_id": (str,),
                    "body": (SyntheticsUpdateTestPauseStatusPayload,),
                },
                "attribute_map": {
                    "public_id": "public_id",
                },
                "location_map": {
                    "public_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_global_variable(self, body, **kwargs):
        """Create a global variable  # noqa: E501

        Create a Synthetics global variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_global_variable(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsGlobalVariable): Details of the global variable to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsGlobalVariable
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_global_variable_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_global_variable_endpoint.call_with_http_info(**kwargs)

    def create_private_location(self, body, **kwargs):
        """Create a private location  # noqa: E501

        Create a new Synthetics private location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_private_location(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsPrivateLocation): Details of the private location to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsPrivateLocationCreationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_private_location_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_private_location_endpoint.call_with_http_info(**kwargs)

    def create_synthetics_api_test(self, body, **kwargs):
        """Create an API test  # noqa: E501

        Create a Synthetic API test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_synthetics_api_test(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsAPITest): Details of the test to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsAPITest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_synthetics_api_test_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_synthetics_api_test_endpoint.call_with_http_info(**kwargs)

    def create_synthetics_browser_test(self, body, **kwargs):
        """Create a browser test  # noqa: E501

        Create a Synthetic browser test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_synthetics_browser_test(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsBrowserTest): Details of the test to create.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsBrowserTest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_synthetics_browser_test_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_synthetics_browser_test_endpoint.call_with_http_info(**kwargs)

    def delete_global_variable(self, variable_id, **kwargs):
        """Delete a global variable  # noqa: E501

        Delete a Synthetics global variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_global_variable(variable_id, async_req=True)
        >>> result = thread.get()

        Args:
            variable_id (str): The ID of the global variable.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_global_variable_endpoint.default_arguments(kwargs)
        kwargs["variable_id"] = variable_id
        return self._delete_global_variable_endpoint.call_with_http_info(**kwargs)

    def delete_private_location(self, location_id, **kwargs):
        """Delete a private location  # noqa: E501

        Delete a Synthetics private location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_private_location(location_id, async_req=True)
        >>> result = thread.get()

        Args:
            location_id (str): The ID of the private location.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_private_location_endpoint.default_arguments(kwargs)
        kwargs["location_id"] = location_id
        return self._delete_private_location_endpoint.call_with_http_info(**kwargs)

    def delete_tests(self, body, **kwargs):
        """Delete tests  # noqa: E501

        Delete multiple Synthetic tests by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tests(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsDeleteTestsPayload): Public ID list of the Synthetic tests to be deleted.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsDeleteTestsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_tests_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._delete_tests_endpoint.call_with_http_info(**kwargs)

    def edit_global_variable(self, variable_id, body, **kwargs):
        """Edit a global variable  # noqa: E501

        Edit a Synthetics global variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_global_variable(variable_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            variable_id (str): The ID of the global variable.
            body (SyntheticsGlobalVariable): Details of the global variable to update.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsGlobalVariable
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._edit_global_variable_endpoint.default_arguments(kwargs)
        kwargs["variable_id"] = variable_id
        kwargs["body"] = body
        return self._edit_global_variable_endpoint.call_with_http_info(**kwargs)

    def get_api_test(self, public_id, **kwargs):
        """Get an API test  # noqa: E501

        Get the detailed configuration associated with a Synthetic API test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_test(public_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test to get details from.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsAPITest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_api_test_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        return self._get_api_test_endpoint.call_with_http_info(**kwargs)

    def get_api_test_latest_results(self, public_id, **kwargs):
        """Get an API test's latest results summaries  # noqa: E501

        Get the last 50 test results summaries for a given Synthetics API test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_test_latest_results(public_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test for which to search results for.

        Keyword Args:
            from_ts (int): Timestamp in milliseconds from which to start querying results.. [optional]
            to_ts (int): Timestamp in milliseconds up to which to query results.. [optional]
            probe_dc ([str]): Locations for which to query results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsGetAPITestLatestResultsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_api_test_latest_results_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        return self._get_api_test_latest_results_endpoint.call_with_http_info(**kwargs)

    def get_api_test_result(self, public_id, result_id, **kwargs):
        """Get an API test result  # noqa: E501

        Get a specific full result from a given (API) Synthetic test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_test_result(public_id, result_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the API test to which the target result belongs.
            result_id (str): The ID of the result to get.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsAPITestResultFull
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_api_test_result_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        kwargs["result_id"] = result_id
        return self._get_api_test_result_endpoint.call_with_http_info(**kwargs)

    def get_browser_test(self, public_id, **kwargs):
        """Get a browser test  # noqa: E501

        Get the detailed configuration (including steps) associated with a Synthetic browser test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_browser_test(public_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test to get details from.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsBrowserTest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_browser_test_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        return self._get_browser_test_endpoint.call_with_http_info(**kwargs)

    def get_browser_test_latest_results(self, public_id, **kwargs):
        """Get a browser test's latest results summaries  # noqa: E501

        Get the last 50 test results summaries for a given Synthetics Browser test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_browser_test_latest_results(public_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the browser test for which to search results for.

        Keyword Args:
            from_ts (int): Timestamp in milliseconds from which to start querying results.. [optional]
            to_ts (int): Timestamp in milliseconds up to which to query results.. [optional]
            probe_dc ([str]): Locations for which to query results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsGetBrowserTestLatestResultsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_browser_test_latest_results_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        return self._get_browser_test_latest_results_endpoint.call_with_http_info(**kwargs)

    def get_browser_test_result(self, public_id, result_id, **kwargs):
        """Get a browser test result  # noqa: E501

        Get a specific full result from a given (browser) Synthetic test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_browser_test_result(public_id, result_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the browser test to which the target result belongs.
            result_id (str): The ID of the result to get.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsBrowserTestResultFull
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_browser_test_result_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        kwargs["result_id"] = result_id
        return self._get_browser_test_result_endpoint.call_with_http_info(**kwargs)

    def get_global_variable(self, variable_id, **kwargs):
        """Get a global variable  # noqa: E501

        Get the detailed configuration of a global variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_global_variable(variable_id, async_req=True)
        >>> result = thread.get()

        Args:
            variable_id (str): The ID of the global variable.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsGlobalVariable
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_global_variable_endpoint.default_arguments(kwargs)
        kwargs["variable_id"] = variable_id
        return self._get_global_variable_endpoint.call_with_http_info(**kwargs)

    def get_private_location(self, location_id, **kwargs):
        """Get a private location  # noqa: E501

        Get a Synthetics private location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_private_location(location_id, async_req=True)
        >>> result = thread.get()

        Args:
            location_id (str): The ID of the private location.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsPrivateLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_private_location_endpoint.default_arguments(kwargs)
        kwargs["location_id"] = location_id
        return self._get_private_location_endpoint.call_with_http_info(**kwargs)

    def get_test(self, public_id, **kwargs):
        """Get a test configuration  # noqa: E501

        Get the detailed configuration associated with a Synthetics test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_test(public_id, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test to get details from.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsTestDetails
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_test_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        return self._get_test_endpoint.call_with_http_info(**kwargs)

    def list_global_variables(self, **kwargs):
        """Get all global variables  # noqa: E501

        Get the list of all Synthetics global variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_global_variables(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsListGlobalVariablesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_global_variables_endpoint.default_arguments(kwargs)
        return self._list_global_variables_endpoint.call_with_http_info(**kwargs)

    def list_locations(self, **kwargs):
        """Get all locations (public and private)  # noqa: E501

        Get the list of public and private locations available for Synthetic tests. No arguments required.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_locations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsLocations
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_locations_endpoint.default_arguments(kwargs)
        return self._list_locations_endpoint.call_with_http_info(**kwargs)

    def list_tests(self, **kwargs):
        """Get the list of all tests  # noqa: E501

        Get the list of all Synthetic tests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_tests(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsListTestsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_tests_endpoint.default_arguments(kwargs)
        return self._list_tests_endpoint.call_with_http_info(**kwargs)

    def trigger_ci_tests(self, body, **kwargs):
        """Trigger tests from CI/CD pipelines  # noqa: E501

        Trigger a set of Synthetics tests for continuous integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trigger_ci_tests(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (SyntheticsCITestBody): Details of the test to trigger.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsTriggerCITestsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._trigger_ci_tests_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._trigger_ci_tests_endpoint.call_with_http_info(**kwargs)

    def update_api_test(self, public_id, body, **kwargs):
        """Edit an API test  # noqa: E501

        Edit the configuration of a Synthetic API test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_api_test(public_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test to get details from.
            body (SyntheticsAPITest): New test details to be saved.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsAPITest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_api_test_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        kwargs["body"] = body
        return self._update_api_test_endpoint.call_with_http_info(**kwargs)

    def update_browser_test(self, public_id, body, **kwargs):
        """Edit a browser test  # noqa: E501

        Edit the configuration of a Synthetic browser test.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_browser_test(public_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the test to get details from.
            body (SyntheticsBrowserTest): New test details to be saved.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsBrowserTest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_browser_test_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        kwargs["body"] = body
        return self._update_browser_test_endpoint.call_with_http_info(**kwargs)

    def update_private_location(self, location_id, body, **kwargs):
        """Edit a private location  # noqa: E501

        Edit a Synthetics private location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_private_location(location_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            location_id (str): The ID of the private location.
            body (SyntheticsPrivateLocation): Details of the private location to be updated.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SyntheticsPrivateLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_private_location_endpoint.default_arguments(kwargs)
        kwargs["location_id"] = location_id
        kwargs["body"] = body
        return self._update_private_location_endpoint.call_with_http_info(**kwargs)

    def update_test_pause_status(self, public_id, body, **kwargs):
        """Pause or start a test  # noqa: E501

        Pause or start a Synthetics test by changing the status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_test_pause_status(public_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            public_id (str): The public ID of the Synthetic test to update.
            body (SyntheticsUpdateTestPauseStatusPayload): Status to set the given Synthetic test to.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_test_pause_status_endpoint.default_arguments(kwargs)
        kwargs["public_id"] = public_id
        kwargs["body"] = body
        return self._update_test_pause_status_endpoint.call_with_http_info(**kwargs)
