# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.usage_analyzed_logs_response import UsageAnalyzedLogsResponse
from datadog_api_client.v1.model.usage_attribution_response import UsageAttributionResponse
from datadog_api_client.v1.model.usage_attribution_sort import UsageAttributionSort
from datadog_api_client.v1.model.usage_attribution_supported_metrics import UsageAttributionSupportedMetrics
from datadog_api_client.v1.model.usage_audit_logs_response import UsageAuditLogsResponse
from datadog_api_client.v1.model.usage_billable_summary_response import UsageBillableSummaryResponse
from datadog_api_client.v1.model.usage_cws_response import UsageCWSResponse
from datadog_api_client.v1.model.usage_cloud_security_posture_management_response import (
    UsageCloudSecurityPostureManagementResponse,
)
from datadog_api_client.v1.model.usage_custom_reports_response import UsageCustomReportsResponse
from datadog_api_client.v1.model.usage_dbm_response import UsageDBMResponse
from datadog_api_client.v1.model.usage_fargate_response import UsageFargateResponse
from datadog_api_client.v1.model.usage_hosts_response import UsageHostsResponse
from datadog_api_client.v1.model.usage_incident_management_response import UsageIncidentManagementResponse
from datadog_api_client.v1.model.usage_indexed_spans_response import UsageIndexedSpansResponse
from datadog_api_client.v1.model.usage_ingested_spans_response import UsageIngestedSpansResponse
from datadog_api_client.v1.model.usage_io_t_response import UsageIoTResponse
from datadog_api_client.v1.model.usage_lambda_response import UsageLambdaResponse
from datadog_api_client.v1.model.usage_logs_by_index_response import UsageLogsByIndexResponse
from datadog_api_client.v1.model.usage_logs_by_retention_response import UsageLogsByRetentionResponse
from datadog_api_client.v1.model.usage_logs_response import UsageLogsResponse
from datadog_api_client.v1.model.usage_network_flows_response import UsageNetworkFlowsResponse
from datadog_api_client.v1.model.usage_network_hosts_response import UsageNetworkHostsResponse
from datadog_api_client.v1.model.usage_profiling_response import UsageProfilingResponse
from datadog_api_client.v1.model.usage_rum_sessions_response import UsageRumSessionsResponse
from datadog_api_client.v1.model.usage_snmp_response import UsageSNMPResponse
from datadog_api_client.v1.model.usage_sort import UsageSort
from datadog_api_client.v1.model.usage_sort_direction import UsageSortDirection
from datadog_api_client.v1.model.usage_specified_custom_reports_response import UsageSpecifiedCustomReportsResponse
from datadog_api_client.v1.model.usage_summary_response import UsageSummaryResponse
from datadog_api_client.v1.model.usage_synthetics_api_response import UsageSyntheticsAPIResponse
from datadog_api_client.v1.model.usage_synthetics_browser_response import UsageSyntheticsBrowserResponse
from datadog_api_client.v1.model.usage_synthetics_response import UsageSyntheticsResponse
from datadog_api_client.v1.model.usage_timeseries_response import UsageTimeseriesResponse
from datadog_api_client.v1.model.usage_top_avg_metrics_response import UsageTopAvgMetricsResponse


class UsageMeteringApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._get_daily_custom_reports_endpoint = _Endpoint(
            settings={
                "response_type": (UsageCustomReportsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/daily_custom_reports",
                "operation_id": "get_daily_custom_reports",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort_dir",
                    "sort",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort_dir": (UsageSortDirection,),
                    "sort": (UsageSort,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort_dir": "sort_dir",
                    "sort": "sort",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort_dir": "query",
                    "sort": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_incident_management_endpoint = _Endpoint(
            settings={
                "response_type": (UsageIncidentManagementResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/incident-management",
                "operation_id": "get_incident_management",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_ingested_spans_endpoint = _Endpoint(
            settings={
                "response_type": (UsageIngestedSpansResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/ingested-spans",
                "operation_id": "get_ingested_spans",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_monthly_custom_reports_endpoint = _Endpoint(
            settings={
                "response_type": (UsageCustomReportsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monthly_custom_reports",
                "operation_id": "get_monthly_custom_reports",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort_dir",
                    "sort",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort_dir": (UsageSortDirection,),
                    "sort": (UsageSort,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort_dir": "sort_dir",
                    "sort": "sort",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort_dir": "query",
                    "sort": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_specified_daily_custom_reports_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSpecifiedCustomReportsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/daily_custom_reports/{report_id}",
                "operation_id": "get_specified_daily_custom_reports",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "report_id",
                ],
                "required": [
                    "report_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "report_id": (str,),
                },
                "attribute_map": {
                    "report_id": "report_id",
                },
                "location_map": {
                    "report_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_specified_monthly_custom_reports_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSpecifiedCustomReportsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/monthly_custom_reports/{report_id}",
                "operation_id": "get_specified_monthly_custom_reports",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "report_id",
                ],
                "required": [
                    "report_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "report_id": (str,),
                },
                "attribute_map": {
                    "report_id": "report_id",
                },
                "location_map": {
                    "report_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_analyzed_logs_endpoint = _Endpoint(
            settings={
                "response_type": (UsageAnalyzedLogsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/analyzed_logs",
                "operation_id": "get_usage_analyzed_logs",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_attribution_endpoint = _Endpoint(
            settings={
                "response_type": (UsageAttributionResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/attribution",
                "operation_id": "get_usage_attribution",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_month",
                    "fields",
                    "end_month",
                    "sort_direction",
                    "sort_name",
                    "include_descendants",
                ],
                "required": [
                    "start_month",
                    "fields",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_month": (datetime,),
                    "fields": (UsageAttributionSupportedMetrics,),
                    "end_month": (datetime,),
                    "sort_direction": (UsageSortDirection,),
                    "sort_name": (UsageAttributionSort,),
                    "include_descendants": (bool,),
                },
                "attribute_map": {
                    "start_month": "start_month",
                    "fields": "fields",
                    "end_month": "end_month",
                    "sort_direction": "sort_direction",
                    "sort_name": "sort_name",
                    "include_descendants": "include_descendants",
                },
                "location_map": {
                    "start_month": "query",
                    "fields": "query",
                    "end_month": "query",
                    "sort_direction": "query",
                    "sort_name": "query",
                    "include_descendants": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_audit_logs_endpoint = _Endpoint(
            settings={
                "response_type": (UsageAuditLogsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/audit_logs",
                "operation_id": "get_usage_audit_logs",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_billable_summary_endpoint = _Endpoint(
            settings={
                "response_type": (UsageBillableSummaryResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/billable-summary",
                "operation_id": "get_usage_billable_summary",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "month",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "month": (datetime,),
                },
                "attribute_map": {
                    "month": "month",
                },
                "location_map": {
                    "month": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_cloud_security_posture_management_endpoint = _Endpoint(
            settings={
                "response_type": (UsageCloudSecurityPostureManagementResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/cspm",
                "operation_id": "get_usage_cloud_security_posture_management",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_cws_endpoint = _Endpoint(
            settings={
                "response_type": (UsageCWSResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/cws",
                "operation_id": "get_usage_cws",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_dbm_endpoint = _Endpoint(
            settings={
                "response_type": (UsageDBMResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/dbm",
                "operation_id": "get_usage_dbm",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_fargate_endpoint = _Endpoint(
            settings={
                "response_type": (UsageFargateResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/fargate",
                "operation_id": "get_usage_fargate",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_hosts_endpoint = _Endpoint(
            settings={
                "response_type": (UsageHostsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/hosts",
                "operation_id": "get_usage_hosts",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_indexed_spans_endpoint = _Endpoint(
            settings={
                "response_type": (UsageIndexedSpansResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/indexed-spans",
                "operation_id": "get_usage_indexed_spans",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_internet_of_things_endpoint = _Endpoint(
            settings={
                "response_type": (UsageIoTResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/iot",
                "operation_id": "get_usage_internet_of_things",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_lambda_endpoint = _Endpoint(
            settings={
                "response_type": (UsageLambdaResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/aws_lambda",
                "operation_id": "get_usage_lambda",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_logs_endpoint = _Endpoint(
            settings={
                "response_type": (UsageLogsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/logs",
                "operation_id": "get_usage_logs",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_logs_by_index_endpoint = _Endpoint(
            settings={
                "response_type": (UsageLogsByIndexResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/logs_by_index",
                "operation_id": "get_usage_logs_by_index",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                    "index_name",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                    "index_name": ([str],),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                    "index_name": "index_name",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                    "index_name": "query",
                },
                "collection_format_map": {
                    "index_name": "multi",
                },
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_logs_by_retention_endpoint = _Endpoint(
            settings={
                "response_type": (UsageLogsByRetentionResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/logs-by-retention",
                "operation_id": "get_usage_logs_by_retention",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_network_flows_endpoint = _Endpoint(
            settings={
                "response_type": (UsageNetworkFlowsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/network_flows",
                "operation_id": "get_usage_network_flows",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_network_hosts_endpoint = _Endpoint(
            settings={
                "response_type": (UsageNetworkHostsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/network_hosts",
                "operation_id": "get_usage_network_hosts",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_profiling_endpoint = _Endpoint(
            settings={
                "response_type": (UsageProfilingResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/profiling",
                "operation_id": "get_usage_profiling",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_rum_sessions_endpoint = _Endpoint(
            settings={
                "response_type": (UsageRumSessionsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/rum_sessions",
                "operation_id": "get_usage_rum_sessions",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                    "type",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                    "type": (str,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                    "type": "type",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                    "type": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_snmp_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSNMPResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/snmp",
                "operation_id": "get_usage_snmp",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_summary_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSummaryResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/summary",
                "operation_id": "get_usage_summary",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_month",
                    "end_month",
                    "include_org_details",
                ],
                "required": [
                    "start_month",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_month": (datetime,),
                    "end_month": (datetime,),
                    "include_org_details": (bool,),
                },
                "attribute_map": {
                    "start_month": "start_month",
                    "end_month": "end_month",
                    "include_org_details": "include_org_details",
                },
                "location_map": {
                    "start_month": "query",
                    "end_month": "query",
                    "include_org_details": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_synthetics_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSyntheticsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/synthetics",
                "operation_id": "get_usage_synthetics",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_synthetics_api_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSyntheticsAPIResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/synthetics_api",
                "operation_id": "get_usage_synthetics_api",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_synthetics_browser_endpoint = _Endpoint(
            settings={
                "response_type": (UsageSyntheticsBrowserResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/synthetics_browser",
                "operation_id": "get_usage_synthetics_browser",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_timeseries_endpoint = _Endpoint(
            settings={
                "response_type": (UsageTimeseriesResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/timeseries",
                "operation_id": "get_usage_timeseries",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "start_hr",
                    "end_hr",
                ],
                "required": [
                    "start_hr",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "start_hr": (datetime,),
                    "end_hr": (datetime,),
                },
                "attribute_map": {
                    "start_hr": "start_hr",
                    "end_hr": "end_hr",
                },
                "location_map": {
                    "start_hr": "query",
                    "end_hr": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_usage_top_avg_metrics_endpoint = _Endpoint(
            settings={
                "response_type": (UsageTopAvgMetricsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/usage/top_avg_metrics",
                "operation_id": "get_usage_top_avg_metrics",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "month",
                    "day",
                    "names",
                    "limit",
                    "next_record_id",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [
                    "limit",
                ],
            },
            root_map={
                "validations": {
                    ("limit",): {
                        "inclusive_maximum": 5000,
                        "inclusive_minimum": 1,
                    },
                },
                "allowed_values": {},
                "openapi_types": {
                    "month": (datetime,),
                    "day": (datetime,),
                    "names": ([str],),
                    "limit": (int,),
                    "next_record_id": (str,),
                },
                "attribute_map": {
                    "month": "month",
                    "day": "day",
                    "names": "names",
                    "limit": "limit",
                    "next_record_id": "next_record_id",
                },
                "location_map": {
                    "month": "query",
                    "day": "query",
                    "names": "query",
                    "limit": "query",
                    "next_record_id": "query",
                },
                "collection_format_map": {
                    "names": "multi",
                },
            },
            headers_map={
                "accept": ["application/json;datetime-format=rfc3339"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def get_daily_custom_reports(self, **kwargs):
        """Get the list of available daily custom reports  # noqa: E501

        Get daily custom reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_daily_custom_reports(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): The number of files to return in the response. `[default=60]`.. [optional]
            page_number (int): The identifier of the first page to return. This parameter is used for the pagination feature `[default=0]`.. [optional]
            sort_dir (UsageSortDirection): The direction to sort by: `[desc, asc]`.. [optional]
            sort (UsageSort): The field to sort by: `[computed_on, size, start_date, end_date]`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageCustomReportsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_daily_custom_reports_endpoint.default_arguments(kwargs)
        return self._get_daily_custom_reports_endpoint.call_with_http_info(**kwargs)

    def get_incident_management(self, start_hr, **kwargs):
        """Get hourly usage for incident management  # noqa: E501

        Get hourly usage for incident management.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_incident_management(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageIncidentManagementResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_incident_management_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_incident_management_endpoint.call_with_http_info(**kwargs)

    def get_ingested_spans(self, start_hr, **kwargs):
        """Get hourly usage for ingested spans  # noqa: E501

        Get hourly usage for ingested spans.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ingested_spans(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageIngestedSpansResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_ingested_spans_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_ingested_spans_endpoint.call_with_http_info(**kwargs)

    def get_monthly_custom_reports(self, **kwargs):
        """Get the list of available monthly custom reports  # noqa: E501

        Get monthly custom reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_monthly_custom_reports(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): The number of files to return in the response `[default=60].`. [optional]
            page_number (int): The identifier of the first page to return. This parameter is used for the pagination feature `[default=0]`.. [optional]
            sort_dir (UsageSortDirection): The direction to sort by: `[desc, asc]`.. [optional]
            sort (UsageSort): The field to sort by: `[computed_on, size, start_date, end_date]`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageCustomReportsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_monthly_custom_reports_endpoint.default_arguments(kwargs)
        return self._get_monthly_custom_reports_endpoint.call_with_http_info(**kwargs)

    def get_specified_daily_custom_reports(self, report_id, **kwargs):
        """Get specified daily custom reports  # noqa: E501

        Get specified daily custom reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specified_daily_custom_reports(report_id, async_req=True)
        >>> result = thread.get()

        Args:
            report_id (str): Date of the report in the format `YYYY-MM-DD`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSpecifiedCustomReportsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_specified_daily_custom_reports_endpoint.default_arguments(kwargs)
        kwargs["report_id"] = report_id
        return self._get_specified_daily_custom_reports_endpoint.call_with_http_info(**kwargs)

    def get_specified_monthly_custom_reports(self, report_id, **kwargs):
        """Get specified monthly custom reports  # noqa: E501

        Get specified monthly custom reports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_specified_monthly_custom_reports(report_id, async_req=True)
        >>> result = thread.get()

        Args:
            report_id (str): Date of the report in the format `YYYY-MM-DD`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSpecifiedCustomReportsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_specified_monthly_custom_reports_endpoint.default_arguments(kwargs)
        kwargs["report_id"] = report_id
        return self._get_specified_monthly_custom_reports_endpoint.call_with_http_info(**kwargs)

    def get_usage_analyzed_logs(self, start_hr, **kwargs):
        """Get hourly usage for analyzed logs  # noqa: E501

        Get hourly usage for analyzed logs (Security Monitoring).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_analyzed_logs(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageAnalyzedLogsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_analyzed_logs_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_analyzed_logs_endpoint.call_with_http_info(**kwargs)

    def get_usage_attribution(self, start_month, fields, **kwargs):
        """Get Usage Attribution  # noqa: E501

        Get Usage Attribution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_attribution(start_month, fields, async_req=True)
        >>> result = thread.get()

        Args:
            start_month (datetime): Datetime in ISO-8601 format, UTC, precise to month: `[YYYY-MM]` for usage beginning in this month. Maximum of 15 months ago.
            fields (UsageAttributionSupportedMetrics): Comma-separated list of usage types to return, or `*` for all usage types.

        Keyword Args:
            end_month (datetime): Datetime in ISO-8601 format, UTC, precise to month: `[YYYY-MM]` for usage ending this month.. [optional]
            sort_direction (UsageSortDirection): The direction to sort by: `[desc, asc]`.. [optional]
            sort_name (UsageAttributionSort): The field to sort by.. [optional]
            include_descendants (bool): Include child org usage in the response. Defaults to false.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageAttributionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_attribution_endpoint.default_arguments(kwargs)
        kwargs["start_month"] = start_month
        kwargs["fields"] = fields
        return self._get_usage_attribution_endpoint.call_with_http_info(**kwargs)

    def get_usage_audit_logs(self, start_hr, **kwargs):
        """Get hourly usage for audit logs  # noqa: E501

        Get hourly usage for audit logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_audit_logs(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageAuditLogsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_audit_logs_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_audit_logs_endpoint.call_with_http_info(**kwargs)

    def get_usage_billable_summary(self, **kwargs):
        """Get billable usage across your account  # noqa: E501

        Get billable usage across your account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_billable_summary(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            month (datetime): Datetime in ISO-8601 format, UTC, precise to month: `[YYYY-MM]` for usage starting this month.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageBillableSummaryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_billable_summary_endpoint.default_arguments(kwargs)
        return self._get_usage_billable_summary_endpoint.call_with_http_info(**kwargs)

    def get_usage_cloud_security_posture_management(self, start_hr, **kwargs):
        """Get hourly usage for CSPM  # noqa: E501

        Get hourly usage for Cloud Security Posture Management (CSPM).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_cloud_security_posture_management(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageCloudSecurityPostureManagementResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_cloud_security_posture_management_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_cloud_security_posture_management_endpoint.call_with_http_info(**kwargs)

    def get_usage_cws(self, start_hr, **kwargs):
        """Get hourly usage for Cloud Workload Security  # noqa: E501

        Get hourly usage for Cloud Workload Security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_cws(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageCWSResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_cws_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_cws_endpoint.call_with_http_info(**kwargs)

    def get_usage_dbm(self, start_hr, **kwargs):
        """Get hourly usage for Database Monitoring  # noqa: E501

        Get hourly usage for Database Monitoring  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_dbm(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageDBMResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_dbm_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_dbm_endpoint.call_with_http_info(**kwargs)

    def get_usage_fargate(self, start_hr, **kwargs):
        """Get hourly usage for Fargate  # noqa: E501

        Get hourly usage for [Fargate](https://docs.datadoghq.com/integrations/ecs_fargate/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_fargate(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageFargateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_fargate_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_fargate_endpoint.call_with_http_info(**kwargs)

    def get_usage_hosts(self, start_hr, **kwargs):
        """Get hourly usage for hosts and containers  # noqa: E501

        Get hourly usage for hosts and containers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_hosts(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageHostsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_hosts_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_hosts_endpoint.call_with_http_info(**kwargs)

    def get_usage_indexed_spans(self, start_hr, **kwargs):
        """Get hourly usage for indexed spans  # noqa: E501

        Get hourly usage for indexed spans.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_indexed_spans(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageIndexedSpansResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_indexed_spans_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_indexed_spans_endpoint.call_with_http_info(**kwargs)

    def get_usage_internet_of_things(self, start_hr, **kwargs):
        """Get hourly usage for IoT  # noqa: E501

        Get hourly usage for IoT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_internet_of_things(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageIoTResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_internet_of_things_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_internet_of_things_endpoint.call_with_http_info(**kwargs)

    def get_usage_lambda(self, start_hr, **kwargs):
        """Get hourly usage for Lambda  # noqa: E501

        Get hourly usage for lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_lambda(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageLambdaResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_lambda_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_lambda_endpoint.call_with_http_info(**kwargs)

    def get_usage_logs(self, start_hr, **kwargs):
        """Get hourly usage for Logs  # noqa: E501

        Get hourly usage for logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_logs(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageLogsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_logs_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_logs_endpoint.call_with_http_info(**kwargs)

    def get_usage_logs_by_index(self, start_hr, **kwargs):
        """Get hourly usage for Logs by Index  # noqa: E501

        Get hourly usage for logs by index.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_logs_by_index(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            index_name ([str]): Comma-separated list of log index names.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageLogsByIndexResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_logs_by_index_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_logs_by_index_endpoint.call_with_http_info(**kwargs)

    def get_usage_logs_by_retention(self, start_hr, **kwargs):
        """Get hourly logs usage by retention  # noqa: E501

        Get hourly usage for indexed logs by retention period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_logs_by_retention(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageLogsByRetentionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_logs_by_retention_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_logs_by_retention_endpoint.call_with_http_info(**kwargs)

    def get_usage_network_flows(self, start_hr, **kwargs):
        """Get hourly usage for Network Flows  # noqa: E501

        Get hourly usage for network flows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_network_flows(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageNetworkFlowsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_network_flows_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_network_flows_endpoint.call_with_http_info(**kwargs)

    def get_usage_network_hosts(self, start_hr, **kwargs):
        """Get hourly usage for Network Hosts  # noqa: E501

        Get hourly usage for network hosts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_network_hosts(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageNetworkHostsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_network_hosts_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_network_hosts_endpoint.call_with_http_info(**kwargs)

    def get_usage_profiling(self, start_hr, **kwargs):
        """Get hourly usage for profiled hosts  # noqa: E501

        Get hourly usage for profiled hosts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_profiling(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageProfilingResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_profiling_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_profiling_endpoint.call_with_http_info(**kwargs)

    def get_usage_rum_sessions(self, start_hr, **kwargs):
        """Get hourly usage for RUM Sessions  # noqa: E501

        Get hourly usage for [RUM](https://docs.datadoghq.com/real_user_monitoring/) Sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_rum_sessions(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            type (str): RUM type: `[browser, mobile]`. Defaults to `browser`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageRumSessionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_rum_sessions_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_rum_sessions_endpoint.call_with_http_info(**kwargs)

    def get_usage_snmp(self, start_hr, **kwargs):
        """Get hourly usage for SNMP devices  # noqa: E501

        Get hourly usage for SNMP devices.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_snmp(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: `[YYYY-MM-DDThh]` for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSNMPResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_snmp_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_snmp_endpoint.call_with_http_info(**kwargs)

    def get_usage_summary(self, start_month, **kwargs):
        """Get usage across your multi-org account  # noqa: E501

        Get usage across your multi-org account. You must have the multi-org feature enabled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_summary(start_month, async_req=True)
        >>> result = thread.get()

        Args:
            start_month (datetime): Datetime in ISO-8601 format, UTC, precise to month: `[YYYY-MM]` for usage beginning in this month. Maximum of 15 months ago.

        Keyword Args:
            end_month (datetime): Datetime in ISO-8601 format, UTC, precise to month: `[YYYY-MM]` for usage ending this month.. [optional]
            include_org_details (bool): Include usage summaries for each sub-org.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSummaryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_summary_endpoint.default_arguments(kwargs)
        kwargs["start_month"] = start_month
        return self._get_usage_summary_endpoint.call_with_http_info(**kwargs)

    def get_usage_synthetics(self, start_hr, **kwargs):
        """Get hourly usage for Synthetics Checks  # noqa: E501

        Get hourly usage for [Synthetics checks](https://docs.datadoghq.com/synthetics/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_synthetics(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSyntheticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_synthetics_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_synthetics_endpoint.call_with_http_info(**kwargs)

    def get_usage_synthetics_api(self, start_hr, **kwargs):
        """Get hourly usage for Synthetics API Checks  # noqa: E501

        Get hourly usage for [synthetics API checks](https://docs.datadoghq.com/synthetics/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_synthetics_api(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSyntheticsAPIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_synthetics_api_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_synthetics_api_endpoint.call_with_http_info(**kwargs)

    def get_usage_synthetics_browser(self, start_hr, **kwargs):
        """Get hourly usage for Synthetics Browser Checks  # noqa: E501

        Get hourly usage for synthetics browser checks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_synthetics_browser(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageSyntheticsBrowserResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_synthetics_browser_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_synthetics_browser_endpoint.call_with_http_info(**kwargs)

    def get_usage_timeseries(self, start_hr, **kwargs):
        """Get hourly usage for custom metrics  # noqa: E501

        Get hourly usage for [custom metrics](https://docs.datadoghq.com/developers/metrics/custom_metrics/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_timeseries(start_hr, async_req=True)
        >>> result = thread.get()

        Args:
            start_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage beginning at this hour.

        Keyword Args:
            end_hr (datetime): Datetime in ISO-8601 format, UTC, precise to hour: [YYYY-MM-DDThh] for usage ending **before** this hour.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageTimeseriesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_timeseries_endpoint.default_arguments(kwargs)
        kwargs["start_hr"] = start_hr
        return self._get_usage_timeseries_endpoint.call_with_http_info(**kwargs)

    def get_usage_top_avg_metrics(self, **kwargs):
        """Get all custom metrics by hourly average  # noqa: E501

        Get all [custom metrics](https://docs.datadoghq.com/developers/metrics/custom_metrics/) by hourly average. Use the month parameter to get a month-to-date data resolution or use the day parameter to get a daily resolution. One of the two is required, and only one of the two is allowed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage_top_avg_metrics(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            month (datetime): Datetime in ISO-8601 format, UTC, precise to month: [YYYY-MM] for usage beginning at this hour. (Either month or day should be specified, but not both). [optional]
            day (datetime): Datetime in ISO-8601 format, UTC, precise to day: [YYYY-MM-DD] for usage beginning at this hour. (Either month or day should be specified, but not both). [optional]
            names ([str]): Comma-separated list of metric names.. [optional]
            limit (int): Maximum number of results to return (between 1 and 5000) - defaults to 500 results if limit not specified.. [optional] if omitted the server will use the default value of 500
            next_record_id (str): List following results with a next_record_id provided in the previous query.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsageTopAvgMetricsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_usage_top_avg_metrics_endpoint.default_arguments(kwargs)
        return self._get_usage_top_avg_metrics_endpoint.call_with_http_info(**kwargs)
