# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v1.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v1.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v1.model.api_error_response import APIErrorResponse
from datadog_api_client.v1.model.webhooks_integration import WebhooksIntegration
from datadog_api_client.v1.model.webhooks_integration_custom_variable import WebhooksIntegrationCustomVariable
from datadog_api_client.v1.model.webhooks_integration_custom_variable_response import (
    WebhooksIntegrationCustomVariableResponse,
)
from datadog_api_client.v1.model.webhooks_integration_custom_variable_update_request import (
    WebhooksIntegrationCustomVariableUpdateRequest,
)
from datadog_api_client.v1.model.webhooks_integration_update_request import WebhooksIntegrationUpdateRequest


class WebhooksIntegrationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_webhooks_integration_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegration,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/webhooks",
                "operation_id": "create_webhooks_integration",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (WebhooksIntegration,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_webhooks_integration_custom_variable_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegrationCustomVariableResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/custom-variables",
                "operation_id": "create_webhooks_integration_custom_variable",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (WebhooksIntegrationCustomVariable,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_webhooks_integration_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}",
                "operation_id": "delete_webhooks_integration",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "webhook_name",
                ],
                "required": [
                    "webhook_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "webhook_name": (str,),
                },
                "attribute_map": {
                    "webhook_name": "webhook_name",
                },
                "location_map": {
                    "webhook_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_webhooks_integration_custom_variable_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}",
                "operation_id": "delete_webhooks_integration_custom_variable",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "custom_variable_name",
                ],
                "required": [
                    "custom_variable_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "custom_variable_name": (str,),
                },
                "attribute_map": {
                    "custom_variable_name": "custom_variable_name",
                },
                "location_map": {
                    "custom_variable_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_webhooks_integration_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegration,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}",
                "operation_id": "get_webhooks_integration",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "webhook_name",
                ],
                "required": [
                    "webhook_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "webhook_name": (str,),
                },
                "attribute_map": {
                    "webhook_name": "webhook_name",
                },
                "location_map": {
                    "webhook_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_webhooks_integration_custom_variable_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegrationCustomVariableResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}",
                "operation_id": "get_webhooks_integration_custom_variable",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "custom_variable_name",
                ],
                "required": [
                    "custom_variable_name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "custom_variable_name": (str,),
                },
                "attribute_map": {
                    "custom_variable_name": "custom_variable_name",
                },
                "location_map": {
                    "custom_variable_name": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_webhooks_integration_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegration,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}",
                "operation_id": "update_webhooks_integration",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "webhook_name",
                    "body",
                ],
                "required": [
                    "webhook_name",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "webhook_name": (str,),
                    "body": (WebhooksIntegrationUpdateRequest,),
                },
                "attribute_map": {
                    "webhook_name": "webhook_name",
                },
                "location_map": {
                    "webhook_name": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_webhooks_integration_custom_variable_endpoint = _Endpoint(
            settings={
                "response_type": (WebhooksIntegrationCustomVariableResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}",
                "operation_id": "update_webhooks_integration_custom_variable",
                "http_method": "PUT",
                "servers": None,
            },
            params_map={
                "all": [
                    "custom_variable_name",
                    "body",
                ],
                "required": [
                    "custom_variable_name",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "custom_variable_name": (str,),
                    "body": (WebhooksIntegrationCustomVariableUpdateRequest,),
                },
                "attribute_map": {
                    "custom_variable_name": "custom_variable_name",
                },
                "location_map": {
                    "custom_variable_name": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_webhooks_integration(self, body, **kwargs):
        """Create a webhooks integration  # noqa: E501

        Creates an endpoint with the name `<WEBHOOK_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_webhooks_integration(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (WebhooksIntegration): Create a webhooks integration request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegration
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_webhooks_integration_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_webhooks_integration_endpoint.call_with_http_info(**kwargs)

    def create_webhooks_integration_custom_variable(self, body, **kwargs):
        """Create a custom variable  # noqa: E501

        Creates an endpoint with the name `<CUSTOM_VARIABLE_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_webhooks_integration_custom_variable(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (WebhooksIntegrationCustomVariable): Define a custom variable request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegrationCustomVariableResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_webhooks_integration_custom_variable_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_webhooks_integration_custom_variable_endpoint.call_with_http_info(**kwargs)

    def delete_webhooks_integration(self, webhook_name, **kwargs):
        """Delete a webhook  # noqa: E501

        Deletes the endpoint with the name `<WEBHOOK NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_webhooks_integration(webhook_name, async_req=True)
        >>> result = thread.get()

        Args:
            webhook_name (str): The name of the webhook.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_webhooks_integration_endpoint.default_arguments(kwargs)
        kwargs["webhook_name"] = webhook_name
        return self._delete_webhooks_integration_endpoint.call_with_http_info(**kwargs)

    def delete_webhooks_integration_custom_variable(self, custom_variable_name, **kwargs):
        """Delete a custom variable  # noqa: E501

        Deletes the endpoint with the name `<CUSTOM_VARIABLE_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_webhooks_integration_custom_variable(custom_variable_name, async_req=True)
        >>> result = thread.get()

        Args:
            custom_variable_name (str): The name of the custom variable.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_webhooks_integration_custom_variable_endpoint.default_arguments(kwargs)
        kwargs["custom_variable_name"] = custom_variable_name
        return self._delete_webhooks_integration_custom_variable_endpoint.call_with_http_info(**kwargs)

    def get_webhooks_integration(self, webhook_name, **kwargs):
        """Get a webhook integration  # noqa: E501

        Gets the content of the webhook with the name `<WEBHOOK_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhooks_integration(webhook_name, async_req=True)
        >>> result = thread.get()

        Args:
            webhook_name (str): The name of the webhook.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegration
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_webhooks_integration_endpoint.default_arguments(kwargs)
        kwargs["webhook_name"] = webhook_name
        return self._get_webhooks_integration_endpoint.call_with_http_info(**kwargs)

    def get_webhooks_integration_custom_variable(self, custom_variable_name, **kwargs):
        """Get a custom variable  # noqa: E501

        Shows the content of the custom variable with the name `<CUSTOM_VARIABLE_NAME>`.  If the custom variable is secret, the value does not return in the response payload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhooks_integration_custom_variable(custom_variable_name, async_req=True)
        >>> result = thread.get()

        Args:
            custom_variable_name (str): The name of the custom variable.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegrationCustomVariableResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_webhooks_integration_custom_variable_endpoint.default_arguments(kwargs)
        kwargs["custom_variable_name"] = custom_variable_name
        return self._get_webhooks_integration_custom_variable_endpoint.call_with_http_info(**kwargs)

    def update_webhooks_integration(self, webhook_name, body, **kwargs):
        """Update a webhook  # noqa: E501

        Updates the endpoint with the name `<WEBHOOK_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_webhooks_integration(webhook_name, body, async_req=True)
        >>> result = thread.get()

        Args:
            webhook_name (str): The name of the webhook.
            body (WebhooksIntegrationUpdateRequest): Update an existing Datadog-Webhooks integration.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegration
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_webhooks_integration_endpoint.default_arguments(kwargs)
        kwargs["webhook_name"] = webhook_name
        kwargs["body"] = body
        return self._update_webhooks_integration_endpoint.call_with_http_info(**kwargs)

    def update_webhooks_integration_custom_variable(self, custom_variable_name, body, **kwargs):
        """Update a custom variable  # noqa: E501

        Updates the endpoint with the name `<CUSTOM_VARIABLE_NAME>`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_webhooks_integration_custom_variable(custom_variable_name, body, async_req=True)
        >>> result = thread.get()

        Args:
            custom_variable_name (str): The name of the custom variable.
            body (WebhooksIntegrationCustomVariableUpdateRequest): Update an existing custom variable request body.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WebhooksIntegrationCustomVariableResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_webhooks_integration_custom_variable_endpoint.default_arguments(kwargs)
        kwargs["custom_variable_name"] = custom_variable_name
        kwargs["body"] = body
        return self._update_webhooks_integration_custom_variable_endpoint.call_with_http_info(**kwargs)
