# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v1.model.dashboard_layout_type import DashboardLayoutType

    globals()["DashboardLayoutType"] = DashboardLayoutType


class DashboardSummaryDefinition(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {}

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "author_handle": (str,),  # noqa: E501
            "created_at": (datetime,),  # noqa: E501
            "description": (str,),  # noqa: E501
            "id": (str,),  # noqa: E501
            "is_read_only": (bool,),  # noqa: E501
            "layout_type": (DashboardLayoutType,),  # noqa: E501
            "modified_at": (datetime,),  # noqa: E501
            "title": (str,),  # noqa: E501
            "url": (str,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "author_handle": "author_handle",  # noqa: E501
        "created_at": "created_at",  # noqa: E501
        "description": "description",  # noqa: E501
        "id": "id",  # noqa: E501
        "is_read_only": "is_read_only",  # noqa: E501
        "layout_type": "layout_type",  # noqa: E501
        "modified_at": "modified_at",  # noqa: E501
        "title": "title",  # noqa: E501
        "url": "url",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """DashboardSummaryDefinition - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            author_handle (str): Identifier of the dashboard author.. [optional]  # noqa: E501
            created_at (datetime): Creation date of the dashboard.. [optional]  # noqa: E501
            description (str): Description of the dashboard.. [optional]  # noqa: E501
            id (str): Dashboard identifier.. [optional]  # noqa: E501
            is_read_only (bool): Whether this dashboard is read-only. If True, only the author and admins can make changes to it.. [optional]  # noqa: E501
            layout_type (DashboardLayoutType): [optional]  # noqa: E501
            modified_at (datetime): Modification date of the dashboard.. [optional]  # noqa: E501
            title (str): Title of the dashboard.. [optional]  # noqa: E501
            url (str): URL of the dashboard.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(DashboardSummaryDefinition, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
