# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


class GCPAccount(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {}

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            "auth_provider_x509_cert_url": (str,),  # noqa: E501
            "auth_uri": (str,),  # noqa: E501
            "automute": (bool,),  # noqa: E501
            "client_email": (str,),  # noqa: E501
            "client_id": (str,),  # noqa: E501
            "client_x509_cert_url": (str,),  # noqa: E501
            "errors": ([str],),  # noqa: E501
            "host_filters": (str,),  # noqa: E501
            "private_key": (str,),  # noqa: E501
            "private_key_id": (str,),  # noqa: E501
            "project_id": (str,),  # noqa: E501
            "token_uri": (str,),  # noqa: E501
            "type": (str,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "auth_provider_x509_cert_url": "auth_provider_x509_cert_url",  # noqa: E501
        "auth_uri": "auth_uri",  # noqa: E501
        "automute": "automute",  # noqa: E501
        "client_email": "client_email",  # noqa: E501
        "client_id": "client_id",  # noqa: E501
        "client_x509_cert_url": "client_x509_cert_url",  # noqa: E501
        "errors": "errors",  # noqa: E501
        "host_filters": "host_filters",  # noqa: E501
        "private_key": "private_key",  # noqa: E501
        "private_key_id": "private_key_id",  # noqa: E501
        "project_id": "project_id",  # noqa: E501
        "token_uri": "token_uri",  # noqa: E501
        "type": "type",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """GCPAccount - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            auth_provider_x509_cert_url (str): Should be `https://www.googleapis.com/oauth2/v1/certs`.. [optional]  # noqa: E501
            auth_uri (str): Should be `https://accounts.google.com/o/oauth2/auth`.. [optional]  # noqa: E501
            automute (bool): Silence monitors for expected GCE instance shutdowns.. [optional]  # noqa: E501
            client_email (str): Your email found in your JSON service account key.. [optional]  # noqa: E501
            client_id (str): Your ID found in your JSON service account key.. [optional]  # noqa: E501
            client_x509_cert_url (str): Should be `https://www.googleapis.com/robot/v1/metadata/x509/<CLIENT_EMAIL>` where `<CLIENT_EMAIL>` is the email found in your JSON service account key.. [optional]  # noqa: E501
            errors ([str]): An array of errors.. [optional]  # noqa: E501
            host_filters (str): Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog.. [optional]  # noqa: E501
            private_key (str): Your private key name found in your JSON service account key.. [optional]  # noqa: E501
            private_key_id (str): Your private key ID found in your JSON service account key.. [optional]  # noqa: E501
            project_id (str): Your Google Cloud project ID found in your JSON service account key.. [optional]  # noqa: E501
            token_uri (str): Should be `https://accounts.google.com/o/oauth2/token`.. [optional]  # noqa: E501
            type (str): The value for service_account found in your JSON service account key.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(GCPAccount, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
