# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v1.model.logs_list_request_time import LogsListRequestTime
    from datadog_api_client.v1.model.logs_sort import LogsSort

    globals()["LogsListRequestTime"] = LogsListRequestTime
    globals()["LogsSort"] = LogsSort


class LogsListRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {
        ("limit",): {
            "inclusive_maximum": 1000,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "time": (LogsListRequestTime,),  # noqa: E501
            "index": (str,),  # noqa: E501
            "limit": (int,),  # noqa: E501
            "query": (str,),  # noqa: E501
            "sort": (LogsSort,),  # noqa: E501
            "start_at": (str,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "time": "time",  # noqa: E501
        "index": "index",  # noqa: E501
        "limit": "limit",  # noqa: E501
        "query": "query",  # noqa: E501
        "sort": "sort",  # noqa: E501
        "start_at": "startAt",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, time, *args, **kwargs):  # noqa: E501
        """LogsListRequest - a model defined in OpenAPI

        Args:
            time (LogsListRequestTime):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            index (str): The log index on which the request is performed. For multi-index organizations, the default is all live indexes. Historical indexes of rehydrated logs must be specified.. [optional]  # noqa: E501
            limit (int): Number of logs return in the response.. [optional]  # noqa: E501
            query (str): The search query - following the log search syntax.. [optional]  # noqa: E501
            sort (LogsSort): [optional]  # noqa: E501
            start_at (str): Hash identifier of the first log to return in the list, available in a log `id` attribute. This parameter is used for the pagination feature.  **Note**: This parameter is ignored if the corresponding log is out of the scope of the specified time window.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.time = time

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, time, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(LogsListRequest, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.time = time
        return self
