# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v1.model.query_value_widget_definition_type import QueryValueWidgetDefinitionType
    from datadog_api_client.v1.model.query_value_widget_request import QueryValueWidgetRequest
    from datadog_api_client.v1.model.widget_custom_link import WidgetCustomLink
    from datadog_api_client.v1.model.widget_text_align import WidgetTextAlign
    from datadog_api_client.v1.model.widget_time import WidgetTime

    globals()["QueryValueWidgetDefinitionType"] = QueryValueWidgetDefinitionType
    globals()["QueryValueWidgetRequest"] = QueryValueWidgetRequest
    globals()["WidgetCustomLink"] = WidgetCustomLink
    globals()["WidgetTextAlign"] = WidgetTextAlign
    globals()["WidgetTime"] = WidgetTime


class QueryValueWidgetDefinition(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {
        ("requests",): {
            "max_items": 1,
            "min_items": 1,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "requests": ([QueryValueWidgetRequest],),  # noqa: E501
            "type": (QueryValueWidgetDefinitionType,),  # noqa: E501
            "autoscale": (bool,),  # noqa: E501
            "custom_links": ([WidgetCustomLink],),  # noqa: E501
            "custom_unit": (str,),  # noqa: E501
            "precision": (int,),  # noqa: E501
            "text_align": (WidgetTextAlign,),  # noqa: E501
            "time": (WidgetTime,),  # noqa: E501
            "title": (str,),  # noqa: E501
            "title_align": (WidgetTextAlign,),  # noqa: E501
            "title_size": (str,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "requests": "requests",  # noqa: E501
        "type": "type",  # noqa: E501
        "autoscale": "autoscale",  # noqa: E501
        "custom_links": "custom_links",  # noqa: E501
        "custom_unit": "custom_unit",  # noqa: E501
        "precision": "precision",  # noqa: E501
        "text_align": "text_align",  # noqa: E501
        "time": "time",  # noqa: E501
        "title": "title",  # noqa: E501
        "title_align": "title_align",  # noqa: E501
        "title_size": "title_size",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, requests, type, *args, **kwargs):  # noqa: E501
        """QueryValueWidgetDefinition - a model defined in OpenAPI

        Args:
            requests ([QueryValueWidgetRequest]): Widget definition.
            type (QueryValueWidgetDefinitionType):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            autoscale (bool): Whether to use auto-scaling or not.. [optional]  # noqa: E501
            custom_links ([WidgetCustomLink]): List of custom links.. [optional]  # noqa: E501
            custom_unit (str): Display a unit of your choice on the widget.. [optional]  # noqa: E501
            precision (int): Number of decimals to show. If not defined, the widget uses the raw value.. [optional]  # noqa: E501
            text_align (WidgetTextAlign): [optional]  # noqa: E501
            time (WidgetTime): [optional]  # noqa: E501
            title (str): Title of your widget.. [optional]  # noqa: E501
            title_align (WidgetTextAlign): [optional]  # noqa: E501
            title_size (str): Size of the title.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.requests = requests
        self.type = type

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, requests, type, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(QueryValueWidgetDefinition, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.requests = requests
        self.type = type
        return self
