# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v1.model.synthetics_basic_auth import SyntheticsBasicAuth
    from datadog_api_client.v1.model.synthetics_ci_test_metadata import SyntheticsCITestMetadata
    from datadog_api_client.v1.model.synthetics_device_id import SyntheticsDeviceID
    from datadog_api_client.v1.model.synthetics_test_headers import SyntheticsTestHeaders
    from datadog_api_client.v1.model.synthetics_test_options_retry import SyntheticsTestOptionsRetry

    globals()["SyntheticsBasicAuth"] = SyntheticsBasicAuth
    globals()["SyntheticsCITestMetadata"] = SyntheticsCITestMetadata
    globals()["SyntheticsDeviceID"] = SyntheticsDeviceID
    globals()["SyntheticsTestHeaders"] = SyntheticsTestHeaders
    globals()["SyntheticsTestOptionsRetry"] = SyntheticsTestOptionsRetry


class SyntheticsCITest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {}

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "public_id": (str,),  # noqa: E501
            "allow_insecure_certificates": (bool,),  # noqa: E501
            "basic_auth": (SyntheticsBasicAuth,),  # noqa: E501
            "body": (str,),  # noqa: E501
            "body_type": (str,),  # noqa: E501
            "cookies": (str,),  # noqa: E501
            "device_ids": ([SyntheticsDeviceID],),  # noqa: E501
            "follow_redirects": (bool,),  # noqa: E501
            "headers": (SyntheticsTestHeaders,),  # noqa: E501
            "locations": ([str],),  # noqa: E501
            "metadata": (SyntheticsCITestMetadata,),  # noqa: E501
            "retry": (SyntheticsTestOptionsRetry,),  # noqa: E501
            "start_url": (str,),  # noqa: E501
            "variables": ({str: (str,)},),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "public_id": "public_id",  # noqa: E501
        "allow_insecure_certificates": "allowInsecureCertificates",  # noqa: E501
        "basic_auth": "basicAuth",  # noqa: E501
        "body": "body",  # noqa: E501
        "body_type": "bodyType",  # noqa: E501
        "cookies": "cookies",  # noqa: E501
        "device_ids": "deviceIds",  # noqa: E501
        "follow_redirects": "followRedirects",  # noqa: E501
        "headers": "headers",  # noqa: E501
        "locations": "locations",  # noqa: E501
        "metadata": "metadata",  # noqa: E501
        "retry": "retry",  # noqa: E501
        "start_url": "startUrl",  # noqa: E501
        "variables": "variables",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, public_id, *args, **kwargs):  # noqa: E501
        """SyntheticsCITest - a model defined in OpenAPI

        Args:
            public_id (str): The public ID of the Synthetics test to trigger.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allow_insecure_certificates (bool): Disable certificate checks in API tests.. [optional]  # noqa: E501
            basic_auth (SyntheticsBasicAuth): [optional]  # noqa: E501
            body (str): Body to include in the test.. [optional]  # noqa: E501
            body_type (str): Type of the data sent in a synthetics API test.. [optional]  # noqa: E501
            cookies (str): Cookies for the request.. [optional]  # noqa: E501
            device_ids ([SyntheticsDeviceID]): For browser test, array with the different device IDs used to run the test.. [optional]  # noqa: E501
            follow_redirects (bool): For API HTTP test, whether or not the test should follow redirects.. [optional]  # noqa: E501
            headers (SyntheticsTestHeaders): [optional]  # noqa: E501
            locations ([str]): Array of locations used to run the test.. [optional]  # noqa: E501
            metadata (SyntheticsCITestMetadata): [optional]  # noqa: E501
            retry (SyntheticsTestOptionsRetry): [optional]  # noqa: E501
            start_url (str): Starting URL for the browser test.. [optional]  # noqa: E501
            variables ({str: (str,)}): Variables to replace in the test.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.public_id = public_id

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, public_id, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(SyntheticsCITest, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.public_id = public_id
        return self
