# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v1.model.http_method import HTTPMethod
    from datadog_api_client.v1.model.synthetics_basic_auth import SyntheticsBasicAuth
    from datadog_api_client.v1.model.synthetics_test_headers import SyntheticsTestHeaders
    from datadog_api_client.v1.model.synthetics_test_request_certificate import SyntheticsTestRequestCertificate

    globals()["HTTPMethod"] = HTTPMethod
    globals()["SyntheticsBasicAuth"] = SyntheticsBasicAuth
    globals()["SyntheticsTestHeaders"] = SyntheticsTestHeaders
    globals()["SyntheticsTestRequestCertificate"] = SyntheticsTestRequestCertificate


class SyntheticsTestRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {
        ("dns_server_port",): {
            "inclusive_maximum": 65535,
            "inclusive_minimum": 1,
        },
        ("number_of_packets",): {
            "inclusive_maximum": 10,
            "inclusive_minimum": 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "allow_insecure": (bool,),  # noqa: E501
            "basic_auth": (SyntheticsBasicAuth,),  # noqa: E501
            "body": (str,),  # noqa: E501
            "certificate": (SyntheticsTestRequestCertificate,),  # noqa: E501
            "dns_server": (str,),  # noqa: E501
            "dns_server_port": (int,),  # noqa: E501
            "headers": (SyntheticsTestHeaders,),  # noqa: E501
            "host": (str,),  # noqa: E501
            "method": (HTTPMethod,),  # noqa: E501
            "no_saving_response_body": (bool,),  # noqa: E501
            "number_of_packets": (int,),  # noqa: E501
            "port": (int,),  # noqa: E501
            "query": (dict,),  # noqa: E501
            "should_track_hops": (bool,),  # noqa: E501
            "timeout": (float,),  # noqa: E501
            "url": (str,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "allow_insecure": "allow_insecure",  # noqa: E501
        "basic_auth": "basicAuth",  # noqa: E501
        "body": "body",  # noqa: E501
        "certificate": "certificate",  # noqa: E501
        "dns_server": "dnsServer",  # noqa: E501
        "dns_server_port": "dnsServerPort",  # noqa: E501
        "headers": "headers",  # noqa: E501
        "host": "host",  # noqa: E501
        "method": "method",  # noqa: E501
        "no_saving_response_body": "noSavingResponseBody",  # noqa: E501
        "number_of_packets": "numberOfPackets",  # noqa: E501
        "port": "port",  # noqa: E501
        "query": "query",  # noqa: E501
        "should_track_hops": "shouldTrackHops",  # noqa: E501
        "timeout": "timeout",  # noqa: E501
        "url": "url",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SyntheticsTestRequest - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allow_insecure (bool): Allows loading insecure content for an HTTP request in a multistep test step.. [optional]  # noqa: E501
            basic_auth (SyntheticsBasicAuth): [optional]  # noqa: E501
            body (str): Body to include in the test.. [optional]  # noqa: E501
            certificate (SyntheticsTestRequestCertificate): [optional]  # noqa: E501
            dns_server (str): DNS server to use for DNS tests.. [optional]  # noqa: E501
            dns_server_port (int): DNS server port to use for DNS tests.. [optional]  # noqa: E501
            headers (SyntheticsTestHeaders): [optional]  # noqa: E501
            host (str): Host name to perform the test with.. [optional]  # noqa: E501
            method (HTTPMethod): [optional]  # noqa: E501
            no_saving_response_body (bool): Determines whether or not to save the response body.. [optional]  # noqa: E501
            number_of_packets (int): Number of pings to use per test.. [optional]  # noqa: E501
            port (int): Port to use when performing the test.. [optional]  # noqa: E501
            query (dict): Query to use for the test.. [optional]  # noqa: E501
            should_track_hops (bool): Turns on a traceroute probe to discover all gateways along the path to the host destination.. [optional]  # noqa: E501
            timeout (float): Timeout in seconds for the test.. [optional]  # noqa: E501
            url (str): URL to perform the test with.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(SyntheticsTestRequest, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
