# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v1.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


class UsageAttributionSupportedMetrics(ModelSimple):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ("value",): {
            "CUSTOM_TIMESERIES_USAGE": "custom_timeseries_usage",
            "CONTAINER_USAGE": "container_usage",
            "SNMP_PERCENTAGE": "snmp_percentage",
            "APM_HOST_USAGE": "apm_host_usage",
            "BROWSER_USAGE": "browser_usage",
            "NPM_HOST_PERCENTAGE": "npm_host_percentage",
            "INFRA_HOST_USAGE": "infra_host_usage",
            "CUSTOM_TIMESERIES_PERCENTAGE": "custom_timeseries_percentage",
            "CONTAINER_PERCENTAGE": "container_percentage",
            "LAMBDA_USAGE": "lambda_usage",
            "API_USAGE": "api_usage",
            "APM_HOST_PERCENTAGE": "apm_host_percentage",
            "INFRA_HOST_PERCENTAGE": "infra_host_percentage",
            "SNMP_USAGE": "snmp_usage",
            "BROWSER_PERCENTAGE": "browser_percentage",
            "API_PERCENTAGE": "api_percentage",
            "LAMBDA_PERCENTAGE": "lambda_percentage",
            "NPM_HOST_USAGE": "npm_host_usage",
            "LAMBDA_FUNCTIONS_USAGE": "lambda_functions_usage",
            "LAMBDA_FUNCTIONS_PERCENTAGE": "lambda_functions_percentage",
            "LAMBDA_INVOCATIONS_USAGE": "lambda_invocations_usage",
            "LAMBDA_INVOCATIONS_PERCENTAGE": "lambda_invocations_percentage",
            "FARGATE_USAGE": "fargate_usage",
            "FARGATE_PERCENTAGE": "fargate_percentage",
            "PROFILED_HOST_USAGE": "profiled_host_usage",
            "PROFILED_HOST_PERCENTAGE": "profiled_host_percentage",
            "PROFILED_CONTAINER_USAGE": "profiled_container_usage",
            "PROFILED_CONTAINER_PERCENTAGE": "profiled_container_percentage",
            "DBM_HOST_USAGE": "dbm_host_usage",
            "DBM_HOST_PERCENTAGE": "dbm_host_percentage",
            "DBM_QUERIES_USAGE": "dbm_queries_usage",
            "DBM_QUERIES_PERCENTAGE": "dbm_queries_percentage",
            "ALL": "*",
        },
    }

    validations = {}

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            "value": (str,),
        }

    discriminator = None

    attribute_map = {}

    _composed_schemas = None

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):
        """UsageAttributionSupportedMetrics - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] (str): Supported fields for usage attribution requests (valid requests contain one or more metrics, or `*` for all).., must be one of ["custom_timeseries_usage", "container_usage", "snmp_percentage", "apm_host_usage", "browser_usage", "npm_host_percentage", "infra_host_usage", "custom_timeseries_percentage", "container_percentage", "lambda_usage", "api_usage", "apm_host_percentage", "infra_host_percentage", "snmp_usage", "browser_percentage", "api_percentage", "lambda_percentage", "npm_host_usage", "lambda_functions_usage", "lambda_functions_percentage", "lambda_invocations_usage", "lambda_invocations_percentage", "fargate_usage", "fargate_percentage", "profiled_host_usage", "profiled_host_percentage", "profiled_container_usage", "profiled_container_percentage", "dbm_host_usage", "dbm_host_percentage", "dbm_queries_usage", "dbm_queries_percentage", "*", ]  # noqa: E501

        Keyword Args:
            value (str): Supported fields for usage attribution requests (valid requests contain one or more metrics, or `*` for all).., must be one of ["custom_timeseries_usage", "container_usage", "snmp_percentage", "apm_host_usage", "browser_usage", "npm_host_percentage", "infra_host_usage", "custom_timeseries_percentage", "container_percentage", "lambda_usage", "api_usage", "apm_host_percentage", "infra_host_percentage", "snmp_usage", "browser_percentage", "api_percentage", "lambda_percentage", "npm_host_usage", "lambda_functions_usage", "lambda_functions_percentage", "lambda_invocations_usage", "lambda_invocations_percentage", "fargate_usage", "fargate_percentage", "profiled_host_usage", "profiled_host_percentage", "profiled_container_usage", "profiled_container_percentage", "dbm_host_usage", "dbm_host_percentage", "dbm_queries_usage", "dbm_queries_percentage", "*", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        super().__init__(kwargs)

        if "value" in kwargs:
            value = kwargs.pop("value")
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=self._path_to_item,
                valid_classes=(self.__class__,),
            )

        self._check_pos_args(args)

        self.value = value

        self._check_kw_args(kwargs)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):
        """Helper creating a new instance from a response."""
        return cls(*args, **kwargs)
