# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v2.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v2.model.api_error_response import APIErrorResponse
from datadog_api_client.v2.model.incident_related_object import IncidentRelatedObject
from datadog_api_client.v2.model.incident_team_create_request import IncidentTeamCreateRequest
from datadog_api_client.v2.model.incident_team_response import IncidentTeamResponse
from datadog_api_client.v2.model.incident_team_update_request import IncidentTeamUpdateRequest
from datadog_api_client.v2.model.incident_teams_response import IncidentTeamsResponse


class IncidentTeamsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_incident_team_endpoint = _Endpoint(
            settings={
                "response_type": (IncidentTeamResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/teams",
                "operation_id": "create_incident_team",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (IncidentTeamCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_incident_team_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/teams/{team_id}",
                "operation_id": "delete_incident_team",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "team_id",
                ],
                "required": [
                    "team_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "team_id": (str,),
                },
                "attribute_map": {
                    "team_id": "team_id",
                },
                "location_map": {
                    "team_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_incident_team_endpoint = _Endpoint(
            settings={
                "response_type": (IncidentTeamResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/teams/{team_id}",
                "operation_id": "get_incident_team",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "team_id",
                    "include",
                ],
                "required": [
                    "team_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "team_id": (str,),
                    "include": (IncidentRelatedObject,),
                },
                "attribute_map": {
                    "team_id": "team_id",
                    "include": "include",
                },
                "location_map": {
                    "team_id": "path",
                    "include": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_incident_teams_endpoint = _Endpoint(
            settings={
                "response_type": (IncidentTeamsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/teams",
                "operation_id": "list_incident_teams",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "include",
                    "page_size",
                    "page_offset",
                    "filter",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "include": (IncidentRelatedObject,),
                    "page_size": (int,),
                    "page_offset": (int,),
                    "filter": (str,),
                },
                "attribute_map": {
                    "include": "include",
                    "page_size": "page[size]",
                    "page_offset": "page[offset]",
                    "filter": "filter",
                },
                "location_map": {
                    "include": "query",
                    "page_size": "query",
                    "page_offset": "query",
                    "filter": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_incident_team_endpoint = _Endpoint(
            settings={
                "response_type": (IncidentTeamResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/teams/{team_id}",
                "operation_id": "update_incident_team",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "team_id",
                    "body",
                ],
                "required": [
                    "team_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "team_id": (str,),
                    "body": (IncidentTeamUpdateRequest,),
                },
                "attribute_map": {
                    "team_id": "team_id",
                },
                "location_map": {
                    "team_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_incident_team(self, body, **kwargs):
        """Create a new incident team  # noqa: E501

        Creates a new incident team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_incident_team(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (IncidentTeamCreateRequest): Incident Team Payload.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncidentTeamResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_incident_team_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_incident_team_endpoint.call_with_http_info(**kwargs)

    def delete_incident_team(self, team_id, **kwargs):
        """Delete an existing incident team  # noqa: E501

        Deletes an existing incident team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_incident_team(team_id, async_req=True)
        >>> result = thread.get()

        Args:
            team_id (str): The ID of the incident team.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_incident_team_endpoint.default_arguments(kwargs)
        kwargs["team_id"] = team_id
        return self._delete_incident_team_endpoint.call_with_http_info(**kwargs)

    def get_incident_team(self, team_id, **kwargs):
        """Get details of an incident team  # noqa: E501

        Get details of an incident team. If the `include[users]` query parameter is provided, the included attribute will contain the users related to these incident teams.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_incident_team(team_id, async_req=True)
        >>> result = thread.get()

        Args:
            team_id (str): The ID of the incident team.

        Keyword Args:
            include (IncidentRelatedObject): Specifies which types of related objects should be included in the response.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncidentTeamResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_incident_team_endpoint.default_arguments(kwargs)
        kwargs["team_id"] = team_id
        return self._get_incident_team_endpoint.call_with_http_info(**kwargs)

    def list_incident_teams(self, **kwargs):
        """Get a list of all incident teams  # noqa: E501

        Get all incident teams for the requesting user's organization. If the `include[users]` query parameter is provided, the included attribute will contain the users related to these incident teams.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_incident_teams(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            include (IncidentRelatedObject): Specifies which types of related objects should be included in the response.. [optional]
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_offset (int): Specific offset to use as the beginning of the returned page.. [optional] if omitted the server will use the default value of 0
            filter (str): A search query that filters teams by name.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncidentTeamsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_incident_teams_endpoint.default_arguments(kwargs)
        return self._list_incident_teams_endpoint.call_with_http_info(**kwargs)

    def update_incident_team(self, team_id, body, **kwargs):
        """Update an existing incident team  # noqa: E501

        Updates an existing incident team. Only provide the attributes which should be updated as this request is a partial update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_incident_team(team_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            team_id (str): The ID of the incident team.
            body (IncidentTeamUpdateRequest): Incident Team Payload.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncidentTeamResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_incident_team_endpoint.default_arguments(kwargs)
        kwargs["team_id"] = team_id
        kwargs["body"] = body
        return self._update_incident_team_endpoint.call_with_http_info(**kwargs)
