# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v2.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v2.model.api_error_response import APIErrorResponse
from datadog_api_client.v2.model.api_key_create_request import APIKeyCreateRequest
from datadog_api_client.v2.model.api_key_response import APIKeyResponse
from datadog_api_client.v2.model.api_key_update_request import APIKeyUpdateRequest
from datadog_api_client.v2.model.api_keys_response import APIKeysResponse
from datadog_api_client.v2.model.api_keys_sort import APIKeysSort
from datadog_api_client.v2.model.application_key_create_request import ApplicationKeyCreateRequest
from datadog_api_client.v2.model.application_key_response import ApplicationKeyResponse
from datadog_api_client.v2.model.application_key_update_request import ApplicationKeyUpdateRequest
from datadog_api_client.v2.model.application_keys_sort import ApplicationKeysSort
from datadog_api_client.v2.model.list_application_keys_response import ListApplicationKeysResponse


class KeyManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_api_key_endpoint = _Endpoint(
            settings={
                "response_type": (APIKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/api_keys",
                "operation_id": "create_api_key",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (APIKeyCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_current_user_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/current_user/application_keys",
                "operation_id": "create_current_user_application_key",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (ApplicationKeyCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_api_key_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/api_keys/{api_key_id}",
                "operation_id": "delete_api_key",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "api_key_id",
                ],
                "required": [
                    "api_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "api_key_id": (str,),
                },
                "attribute_map": {
                    "api_key_id": "api_key_id",
                },
                "location_map": {
                    "api_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_application_key_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/application_keys/{app_key_id}",
                "operation_id": "delete_application_key",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                ],
                "required": [
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "app_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._delete_current_user_application_key_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/current_user/application_keys/{app_key_id}",
                "operation_id": "delete_current_user_application_key",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                ],
                "required": [
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "app_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_api_key_endpoint = _Endpoint(
            settings={
                "response_type": (APIKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/api_keys/{api_key_id}",
                "operation_id": "get_api_key",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "api_key_id",
                    "include",
                ],
                "required": [
                    "api_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "api_key_id": (str,),
                    "include": (str,),
                },
                "attribute_map": {
                    "api_key_id": "api_key_id",
                    "include": "include",
                },
                "location_map": {
                    "api_key_id": "path",
                    "include": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/application_keys/{app_key_id}",
                "operation_id": "get_application_key",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                    "include",
                ],
                "required": [
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                    "include": (str,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                    "include": "include",
                },
                "location_map": {
                    "app_key_id": "path",
                    "include": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_current_user_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/current_user/application_keys/{app_key_id}",
                "operation_id": "get_current_user_application_key",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                ],
                "required": [
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "app_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_api_keys_endpoint = _Endpoint(
            settings={
                "response_type": (APIKeysResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/api_keys",
                "operation_id": "list_api_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                    "filter_created_at_start",
                    "filter_created_at_end",
                    "filter_modified_at_start",
                    "filter_modified_at_end",
                    "include",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (APIKeysSort,),
                    "filter": (str,),
                    "filter_created_at_start": (str,),
                    "filter_created_at_end": (str,),
                    "filter_modified_at_start": (str,),
                    "filter_modified_at_end": (str,),
                    "include": (str,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                    "filter_created_at_start": "filter[created_at][start]",
                    "filter_created_at_end": "filter[created_at][end]",
                    "filter_modified_at_start": "filter[modified_at][start]",
                    "filter_modified_at_end": "filter[modified_at][end]",
                    "include": "include",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                    "filter_created_at_start": "query",
                    "filter_created_at_end": "query",
                    "filter_modified_at_start": "query",
                    "filter_modified_at_end": "query",
                    "include": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_application_keys_endpoint = _Endpoint(
            settings={
                "response_type": (ListApplicationKeysResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/application_keys",
                "operation_id": "list_application_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                    "filter_created_at_start",
                    "filter_created_at_end",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (ApplicationKeysSort,),
                    "filter": (str,),
                    "filter_created_at_start": (str,),
                    "filter_created_at_end": (str,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                    "filter_created_at_start": "filter[created_at][start]",
                    "filter_created_at_end": "filter[created_at][end]",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                    "filter_created_at_start": "query",
                    "filter_created_at_end": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_current_user_application_keys_endpoint = _Endpoint(
            settings={
                "response_type": (ListApplicationKeysResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/current_user/application_keys",
                "operation_id": "list_current_user_application_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                    "filter_created_at_start",
                    "filter_created_at_end",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (ApplicationKeysSort,),
                    "filter": (str,),
                    "filter_created_at_start": (str,),
                    "filter_created_at_end": (str,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                    "filter_created_at_start": "filter[created_at][start]",
                    "filter_created_at_end": "filter[created_at][end]",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                    "filter_created_at_start": "query",
                    "filter_created_at_end": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_api_key_endpoint = _Endpoint(
            settings={
                "response_type": (APIKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/api_keys/{api_key_id}",
                "operation_id": "update_api_key",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "api_key_id",
                    "body",
                ],
                "required": [
                    "api_key_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "api_key_id": (str,),
                    "body": (APIKeyUpdateRequest,),
                },
                "attribute_map": {
                    "api_key_id": "api_key_id",
                },
                "location_map": {
                    "api_key_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/application_keys/{app_key_id}",
                "operation_id": "update_application_key",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                    "body",
                ],
                "required": [
                    "app_key_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                    "body": (ApplicationKeyUpdateRequest,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "app_key_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_current_user_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/current_user/application_keys/{app_key_id}",
                "operation_id": "update_current_user_application_key",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "app_key_id",
                    "body",
                ],
                "required": [
                    "app_key_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "app_key_id": (str,),
                    "body": (ApplicationKeyUpdateRequest,),
                },
                "attribute_map": {
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "app_key_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_api_key(self, body, **kwargs):
        """Create an API key  # noqa: E501

        Create an API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_api_key(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (APIKeyCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_api_key_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_api_key_endpoint.call_with_http_info(**kwargs)

    def create_current_user_application_key(self, body, **kwargs):
        """Create an application key for current user  # noqa: E501

        Create an application key for current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_current_user_application_key(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (ApplicationKeyCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_current_user_application_key_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_current_user_application_key_endpoint.call_with_http_info(**kwargs)

    def delete_api_key(self, api_key_id, **kwargs):
        """Delete an API key  # noqa: E501

        Delete an API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_api_key(api_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_key_id (str): The ID of the API key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_api_key_endpoint.default_arguments(kwargs)
        kwargs["api_key_id"] = api_key_id
        return self._delete_api_key_endpoint.call_with_http_info(**kwargs)

    def delete_application_key(self, app_key_id, **kwargs):
        """Delete an application key  # noqa: E501

        Delete an application key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_application_key(app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        return self._delete_application_key_endpoint.call_with_http_info(**kwargs)

    def delete_current_user_application_key(self, app_key_id, **kwargs):
        """Delete an application key owned by current user  # noqa: E501

        Delete an application key owned by current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_current_user_application_key(app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_current_user_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        return self._delete_current_user_application_key_endpoint.call_with_http_info(**kwargs)

    def get_api_key(self, api_key_id, **kwargs):
        """Get API key  # noqa: E501

        Get an API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_api_key(api_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_key_id (str): The ID of the API key.

        Keyword Args:
            include (str): Comma separated list of resource paths for related resources to include in the response. Supported resource paths are `created_by` and `modified_by`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_api_key_endpoint.default_arguments(kwargs)
        kwargs["api_key_id"] = api_key_id
        return self._get_api_key_endpoint.call_with_http_info(**kwargs)

    def get_application_key(self, app_key_id, **kwargs):
        """Get an application key  # noqa: E501

        Get an application key for your org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_application_key(app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.

        Keyword Args:
            include (str): Resource path for related resources to include in the response. Only `owned_by` is supported.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        return self._get_application_key_endpoint.call_with_http_info(**kwargs)

    def get_current_user_application_key(self, app_key_id, **kwargs):
        """Get one application key owned by current user  # noqa: E501

        Get an application key owned by current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_user_application_key(app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_current_user_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        return self._get_current_user_application_key_endpoint.call_with_http_info(**kwargs)

    def list_api_keys(self, **kwargs):
        """Get all API keys  # noqa: E501

        List all API keys available for your account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_api_keys(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (APIKeysSort): API key attribute used to sort results. Sort order is ascending by default. In order to specify a descending sort, prefix the attribute with a minus sign.. [optional]
            filter (str): Filter API keys by the specified string.. [optional]
            filter_created_at_start (str): Only include API keys created on or after the specified date.. [optional]
            filter_created_at_end (str): Only include API keys created on or before the specified date.. [optional]
            filter_modified_at_start (str): Only include API keys modified on or after the specified date.. [optional]
            filter_modified_at_end (str): Only include API keys modified on or before the specified date.. [optional]
            include (str): Comma separated list of resource paths for related resources to include in the response. Supported resource paths are `created_by` and `modified_by`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKeysResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_api_keys_endpoint.default_arguments(kwargs)
        return self._list_api_keys_endpoint.call_with_http_info(**kwargs)

    def list_application_keys(self, **kwargs):
        """Get all application keys  # noqa: E501

        List all application keys available for your org  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_application_keys(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (ApplicationKeysSort): Application key attribute used to sort results. Sort order is ascending by default. In order to specify a descending sort, prefix the attribute with a minus sign.. [optional]
            filter (str): Filter application keys by the specified string.. [optional]
            filter_created_at_start (str): Only include application keys created on or after the specified date.. [optional]
            filter_created_at_end (str): Only include application keys created on or before the specified date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListApplicationKeysResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_application_keys_endpoint.default_arguments(kwargs)
        return self._list_application_keys_endpoint.call_with_http_info(**kwargs)

    def list_current_user_application_keys(self, **kwargs):
        """Get all application keys owned by current user  # noqa: E501

        List all application keys available for current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_current_user_application_keys(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (ApplicationKeysSort): Application key attribute used to sort results. Sort order is ascending by default. In order to specify a descending sort, prefix the attribute with a minus sign.. [optional]
            filter (str): Filter application keys by the specified string.. [optional]
            filter_created_at_start (str): Only include application keys created on or after the specified date.. [optional]
            filter_created_at_end (str): Only include application keys created on or before the specified date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListApplicationKeysResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_current_user_application_keys_endpoint.default_arguments(kwargs)
        return self._list_current_user_application_keys_endpoint.call_with_http_info(**kwargs)

    def update_api_key(self, api_key_id, body, **kwargs):
        """Edit an API key  # noqa: E501

        Update an API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_api_key(api_key_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            api_key_id (str): The ID of the API key.
            body (APIKeyUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_api_key_endpoint.default_arguments(kwargs)
        kwargs["api_key_id"] = api_key_id
        kwargs["body"] = body
        return self._update_api_key_endpoint.call_with_http_info(**kwargs)

    def update_application_key(self, app_key_id, body, **kwargs):
        """Edit an application key  # noqa: E501

        Edit an application key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_application_key(app_key_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.
            body (ApplicationKeyUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        kwargs["body"] = body
        return self._update_application_key_endpoint.call_with_http_info(**kwargs)

    def update_current_user_application_key(self, app_key_id, body, **kwargs):
        """Edit an application key owned by current user  # noqa: E501

        Edit an application key owned by current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_current_user_application_key(app_key_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            app_key_id (str): The ID of the application key.
            body (ApplicationKeyUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_current_user_application_key_endpoint.default_arguments(kwargs)
        kwargs["app_key_id"] = app_key_id
        kwargs["body"] = body
        return self._update_current_user_application_key_endpoint.call_with_http_info(**kwargs)
