# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v2.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v2.model.api_error_response import APIErrorResponse
from datadog_api_client.v2.model.logs_metric_create_request import LogsMetricCreateRequest
from datadog_api_client.v2.model.logs_metric_response import LogsMetricResponse
from datadog_api_client.v2.model.logs_metric_update_request import LogsMetricUpdateRequest
from datadog_api_client.v2.model.logs_metrics_response import LogsMetricsResponse


class LogsMetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_logs_metric_endpoint = _Endpoint(
            settings={
                "response_type": (LogsMetricResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/logs/config/metrics",
                "operation_id": "create_logs_metric",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (LogsMetricCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_logs_metric_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/logs/config/metrics/{metric_id}",
                "operation_id": "delete_logs_metric",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "metric_id",
                ],
                "required": [
                    "metric_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "metric_id": (str,),
                },
                "attribute_map": {
                    "metric_id": "metric_id",
                },
                "location_map": {
                    "metric_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_logs_metric_endpoint = _Endpoint(
            settings={
                "response_type": (LogsMetricResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/logs/config/metrics/{metric_id}",
                "operation_id": "get_logs_metric",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "metric_id",
                ],
                "required": [
                    "metric_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "metric_id": (str,),
                },
                "attribute_map": {
                    "metric_id": "metric_id",
                },
                "location_map": {
                    "metric_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_logs_metrics_endpoint = _Endpoint(
            settings={
                "response_type": (LogsMetricsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/logs/config/metrics",
                "operation_id": "list_logs_metrics",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_logs_metric_endpoint = _Endpoint(
            settings={
                "response_type": (LogsMetricResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/logs/config/metrics/{metric_id}",
                "operation_id": "update_logs_metric",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "metric_id",
                    "body",
                ],
                "required": [
                    "metric_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "metric_id": (str,),
                    "body": (LogsMetricUpdateRequest,),
                },
                "attribute_map": {
                    "metric_id": "metric_id",
                },
                "location_map": {
                    "metric_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_logs_metric(self, body, **kwargs):
        """Create a log-based metric  # noqa: E501

        Create a metric based on your ingested logs in your organization. Returns the log-based metric object from the request body when the request is successful.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_logs_metric(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (LogsMetricCreateRequest): The definition of the new log-based metric.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsMetricResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_logs_metric_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_logs_metric_endpoint.call_with_http_info(**kwargs)

    def delete_logs_metric(self, metric_id, **kwargs):
        """Delete a log-based metric  # noqa: E501

        Delete a specific log-based metric from your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_logs_metric(metric_id, async_req=True)
        >>> result = thread.get()

        Args:
            metric_id (str): The name of the log-based metric.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_logs_metric_endpoint.default_arguments(kwargs)
        kwargs["metric_id"] = metric_id
        return self._delete_logs_metric_endpoint.call_with_http_info(**kwargs)

    def get_logs_metric(self, metric_id, **kwargs):
        """Get a log-based metric  # noqa: E501

        Get a specific log-based metric from your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logs_metric(metric_id, async_req=True)
        >>> result = thread.get()

        Args:
            metric_id (str): The name of the log-based metric.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsMetricResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_logs_metric_endpoint.default_arguments(kwargs)
        kwargs["metric_id"] = metric_id
        return self._get_logs_metric_endpoint.call_with_http_info(**kwargs)

    def list_logs_metrics(self, **kwargs):
        """Get all log-based metrics  # noqa: E501

        Get the list of configured log-based metrics with their definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_logs_metrics(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsMetricsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_logs_metrics_endpoint.default_arguments(kwargs)
        return self._list_logs_metrics_endpoint.call_with_http_info(**kwargs)

    def update_logs_metric(self, metric_id, body, **kwargs):
        """Update a log-based metric  # noqa: E501

        Update a specific log-based metric from your organization. Returns the log-based metric object from the request body when the request is successful.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_logs_metric(metric_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            metric_id (str): The name of the log-based metric.
            body (LogsMetricUpdateRequest): New definition of the log-based metric.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogsMetricResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_logs_metric_endpoint.default_arguments(kwargs)
        kwargs["metric_id"] = metric_id
        kwargs["body"] = body
        return self._update_logs_metric_endpoint.call_with_http_info(**kwargs)
