# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v2.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v2.model.api_error_response import APIErrorResponse
from datadog_api_client.v2.model.permissions_response import PermissionsResponse
from datadog_api_client.v2.model.relationship_to_permission import RelationshipToPermission
from datadog_api_client.v2.model.relationship_to_user import RelationshipToUser
from datadog_api_client.v2.model.role_create_request import RoleCreateRequest
from datadog_api_client.v2.model.role_create_response import RoleCreateResponse
from datadog_api_client.v2.model.role_response import RoleResponse
from datadog_api_client.v2.model.role_update_request import RoleUpdateRequest
from datadog_api_client.v2.model.role_update_response import RoleUpdateResponse
from datadog_api_client.v2.model.roles_response import RolesResponse
from datadog_api_client.v2.model.roles_sort import RolesSort
from datadog_api_client.v2.model.users_response import UsersResponse


class RolesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._add_permission_to_role_endpoint = _Endpoint(
            settings={
                "response_type": (PermissionsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/permissions",
                "operation_id": "add_permission_to_role",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "body",
                ],
                "required": [
                    "role_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "body": (RelationshipToPermission,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._add_user_to_role_endpoint = _Endpoint(
            settings={
                "response_type": (UsersResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/users",
                "operation_id": "add_user_to_role",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "body",
                ],
                "required": [
                    "role_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "body": (RelationshipToUser,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._create_role_endpoint = _Endpoint(
            settings={
                "response_type": (RoleCreateResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles",
                "operation_id": "create_role",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "body",
                ],
                "required": [
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "body": (RoleCreateRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_role_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}",
                "operation_id": "delete_role",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                ],
                "required": [
                    "role_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_role_endpoint = _Endpoint(
            settings={
                "response_type": (RoleResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}",
                "operation_id": "get_role",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                ],
                "required": [
                    "role_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_permissions_endpoint = _Endpoint(
            settings={
                "response_type": (PermissionsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/permissions",
                "operation_id": "list_permissions",
                "http_method": "GET",
                "servers": None,
            },
            params_map={"all": [], "required": [], "nullable": [], "enum": [], "validation": []},
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_role_permissions_endpoint = _Endpoint(
            settings={
                "response_type": (PermissionsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/permissions",
                "operation_id": "list_role_permissions",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                ],
                "required": [
                    "role_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_role_users_endpoint = _Endpoint(
            settings={
                "response_type": (UsersResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/users",
                "operation_id": "list_role_users",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                ],
                "required": [
                    "role_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (str,),
                    "filter": (str,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                },
                "location_map": {
                    "role_id": "path",
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_roles_endpoint = _Endpoint(
            settings={
                "response_type": (RolesResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles",
                "operation_id": "list_roles",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (RolesSort,),
                    "filter": (str,),
                },
                "attribute_map": {
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                },
                "location_map": {
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._remove_permission_from_role_endpoint = _Endpoint(
            settings={
                "response_type": (PermissionsResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/permissions",
                "operation_id": "remove_permission_from_role",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "body",
                ],
                "required": [
                    "role_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "body": (RelationshipToPermission,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._remove_user_from_role_endpoint = _Endpoint(
            settings={
                "response_type": (UsersResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}/users",
                "operation_id": "remove_user_from_role",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "body",
                ],
                "required": [
                    "role_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "body": (RelationshipToUser,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._update_role_endpoint = _Endpoint(
            settings={
                "response_type": (RoleUpdateResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/roles/{role_id}",
                "operation_id": "update_role",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "role_id",
                    "body",
                ],
                "required": [
                    "role_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "role_id": (str,),
                    "body": (RoleUpdateRequest,),
                },
                "attribute_map": {
                    "role_id": "role_id",
                },
                "location_map": {
                    "role_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def add_permission_to_role(self, role_id, body, **kwargs):
        """Grant permission to a role  # noqa: E501

        Adds a permission to a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_permission_to_role(role_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.
            body (RelationshipToPermission):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermissionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._add_permission_to_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        kwargs["body"] = body
        return self._add_permission_to_role_endpoint.call_with_http_info(**kwargs)

    def add_user_to_role(self, role_id, body, **kwargs):
        """Add a user to a role  # noqa: E501

        Adds a user to a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user_to_role(role_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.
            body (RelationshipToUser):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._add_user_to_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        kwargs["body"] = body
        return self._add_user_to_role_endpoint.call_with_http_info(**kwargs)

    def create_role(self, body, **kwargs):
        """Create role  # noqa: E501

        Create a new role for your organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_role(body, async_req=True)
        >>> result = thread.get()

        Args:
            body (RoleCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RoleCreateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_role_endpoint.default_arguments(kwargs)
        kwargs["body"] = body
        return self._create_role_endpoint.call_with_http_info(**kwargs)

    def delete_role(self, role_id, **kwargs):
        """Delete role  # noqa: E501

        Disables a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role(role_id, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        return self._delete_role_endpoint.call_with_http_info(**kwargs)

    def get_role(self, role_id, **kwargs):
        """Get a role  # noqa: E501

        Get a role in the organization specified by the role’s `role_id`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role(role_id, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RoleResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        return self._get_role_endpoint.call_with_http_info(**kwargs)

    def list_permissions(self, **kwargs):
        """List permissions  # noqa: E501

        Returns a list of all permissions, including name, description, and ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_permissions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermissionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_permissions_endpoint.default_arguments(kwargs)
        return self._list_permissions_endpoint.call_with_http_info(**kwargs)

    def list_role_permissions(self, role_id, **kwargs):
        """List permissions for a role  # noqa: E501

        Returns a list of all permissions for a single role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_role_permissions(role_id, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermissionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_role_permissions_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        return self._list_role_permissions_endpoint.call_with_http_info(**kwargs)

    def list_role_users(self, role_id, **kwargs):
        """Get all users of a role  # noqa: E501

        Gets all users of a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_role_users(role_id, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.

        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (str): User attribute to order results by. Sort order is **ascending** by default. Sort order is **descending** if the field is prefixed by a negative sign, for example `sort=-name`. Options: `name`, `email`, `status`.. [optional] if omitted the server will use the default value of "name"
            filter (str): Filter all users by the given string. Defaults to no filtering.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_role_users_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        return self._list_role_users_endpoint.call_with_http_info(**kwargs)

    def list_roles(self, **kwargs):
        """List roles  # noqa: E501

        Returns all roles, including their names and IDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_roles(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (RolesSort): Sort roles depending on the given field. Sort order is **ascending** by default. Sort order is **descending** if the field is prefixed by a negative sign, for example: `sort=-name`.. [optional]
            filter (str): Filter all roles by the given string.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RolesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_roles_endpoint.default_arguments(kwargs)
        return self._list_roles_endpoint.call_with_http_info(**kwargs)

    def remove_permission_from_role(self, role_id, body, **kwargs):
        """Revoke permission  # noqa: E501

        Removes a permission from a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_permission_from_role(role_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.
            body (RelationshipToPermission):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermissionsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._remove_permission_from_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        kwargs["body"] = body
        return self._remove_permission_from_role_endpoint.call_with_http_info(**kwargs)

    def remove_user_from_role(self, role_id, body, **kwargs):
        """Remove a user from a role  # noqa: E501

        Removes a user from a role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_from_role(role_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.
            body (RelationshipToUser):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._remove_user_from_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        kwargs["body"] = body
        return self._remove_user_from_role_endpoint.call_with_http_info(**kwargs)

    def update_role(self, role_id, body, **kwargs):
        """Update a role  # noqa: E501

        Edit a role. Can only be used with application keys belonging to administrators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_role(role_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            role_id (str): The ID of the role.
            body (RoleUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RoleUpdateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_role_endpoint.default_arguments(kwargs)
        kwargs["role_id"] = role_id
        kwargs["body"] = body
        return self._update_role_endpoint.call_with_http_info(**kwargs)
