# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


import re  # noqa: F401
import sys  # noqa: F401

from datadog_api_client.v2.api_client import ApiClient, Endpoint as _Endpoint
from datadog_api_client.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from datadog_api_client.v2.model.api_error_response import APIErrorResponse
from datadog_api_client.v2.model.application_key_create_request import ApplicationKeyCreateRequest
from datadog_api_client.v2.model.application_key_response import ApplicationKeyResponse
from datadog_api_client.v2.model.application_key_update_request import ApplicationKeyUpdateRequest
from datadog_api_client.v2.model.application_keys_sort import ApplicationKeysSort
from datadog_api_client.v2.model.list_application_keys_response import ListApplicationKeysResponse
from datadog_api_client.v2.model.partial_application_key_response import PartialApplicationKeyResponse


class ServiceAccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self._create_service_account_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (ApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/service_accounts/{service_account_id}/application_keys",
                "operation_id": "create_service_account_application_key",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "service_account_id",
                    "body",
                ],
                "required": [
                    "service_account_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service_account_id": (str,),
                    "body": (ApplicationKeyCreateRequest,),
                },
                "attribute_map": {
                    "service_account_id": "service_account_id",
                },
                "location_map": {
                    "service_account_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

        self._delete_service_account_application_key_endpoint = _Endpoint(
            settings={
                "response_type": None,
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}",
                "operation_id": "delete_service_account_application_key",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "service_account_id",
                    "app_key_id",
                ],
                "required": [
                    "service_account_id",
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service_account_id": (str,),
                    "app_key_id": (str,),
                },
                "attribute_map": {
                    "service_account_id": "service_account_id",
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "service_account_id": "path",
                    "app_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._get_service_account_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (PartialApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}",
                "operation_id": "get_service_account_application_key",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service_account_id",
                    "app_key_id",
                ],
                "required": [
                    "service_account_id",
                    "app_key_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service_account_id": (str,),
                    "app_key_id": (str,),
                },
                "attribute_map": {
                    "service_account_id": "service_account_id",
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "service_account_id": "path",
                    "app_key_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._list_service_account_application_keys_endpoint = _Endpoint(
            settings={
                "response_type": (ListApplicationKeysResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/service_accounts/{service_account_id}/application_keys",
                "operation_id": "list_service_account_application_keys",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "service_account_id",
                    "page_size",
                    "page_number",
                    "sort",
                    "filter",
                    "filter_created_at_start",
                    "filter_created_at_end",
                ],
                "required": [
                    "service_account_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service_account_id": (str,),
                    "page_size": (int,),
                    "page_number": (int,),
                    "sort": (ApplicationKeysSort,),
                    "filter": (str,),
                    "filter_created_at_start": (str,),
                    "filter_created_at_end": (str,),
                },
                "attribute_map": {
                    "service_account_id": "service_account_id",
                    "page_size": "page[size]",
                    "page_number": "page[number]",
                    "sort": "sort",
                    "filter": "filter",
                    "filter_created_at_start": "filter[created_at][start]",
                    "filter_created_at_end": "filter[created_at][end]",
                },
                "location_map": {
                    "service_account_id": "path",
                    "page_size": "query",
                    "page_number": "query",
                    "sort": "query",
                    "filter": "query",
                    "filter_created_at_start": "query",
                    "filter_created_at_end": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

        self._update_service_account_application_key_endpoint = _Endpoint(
            settings={
                "response_type": (PartialApplicationKeyResponse,),
                "auth": ["apiKeyAuth", "appKeyAuth"],
                "endpoint_path": "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}",
                "operation_id": "update_service_account_application_key",
                "http_method": "PATCH",
                "servers": None,
            },
            params_map={
                "all": [
                    "service_account_id",
                    "app_key_id",
                    "body",
                ],
                "required": [
                    "service_account_id",
                    "app_key_id",
                    "body",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "service_account_id": (str,),
                    "app_key_id": (str,),
                    "body": (ApplicationKeyUpdateRequest,),
                },
                "attribute_map": {
                    "service_account_id": "service_account_id",
                    "app_key_id": "app_key_id",
                },
                "location_map": {
                    "service_account_id": "path",
                    "app_key_id": "path",
                    "body": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )

    def create_service_account_application_key(self, service_account_id, body, **kwargs):
        """Create an application key for this service account  # noqa: E501

        Create an application key for this service account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_service_account_application_key(service_account_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            service_account_id (str): The ID of the service account.
            body (ApplicationKeyCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._create_service_account_application_key_endpoint.default_arguments(kwargs)
        kwargs["service_account_id"] = service_account_id
        kwargs["body"] = body
        return self._create_service_account_application_key_endpoint.call_with_http_info(**kwargs)

    def delete_service_account_application_key(self, service_account_id, app_key_id, **kwargs):
        """Delete an application key for this service account  # noqa: E501

        Delete an application key owned by this service account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_service_account_application_key(service_account_id, app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_account_id (str): The ID of the service account.
            app_key_id (str): The ID of the application key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._delete_service_account_application_key_endpoint.default_arguments(kwargs)
        kwargs["service_account_id"] = service_account_id
        kwargs["app_key_id"] = app_key_id
        return self._delete_service_account_application_key_endpoint.call_with_http_info(**kwargs)

    def get_service_account_application_key(self, service_account_id, app_key_id, **kwargs):
        """Get one application key for this service account  # noqa: E501

        Get an application key owned by this service account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_service_account_application_key(service_account_id, app_key_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_account_id (str): The ID of the service account.
            app_key_id (str): The ID of the application key.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PartialApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._get_service_account_application_key_endpoint.default_arguments(kwargs)
        kwargs["service_account_id"] = service_account_id
        kwargs["app_key_id"] = app_key_id
        return self._get_service_account_application_key_endpoint.call_with_http_info(**kwargs)

    def list_service_account_application_keys(self, service_account_id, **kwargs):
        """List application keys for this service account  # noqa: E501

        List all application keys available for this service account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_service_account_application_keys(service_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_account_id (str): The ID of the service account.

        Keyword Args:
            page_size (int): Size for a given page.. [optional] if omitted the server will use the default value of 10
            page_number (int): Specific page number to return.. [optional] if omitted the server will use the default value of 0
            sort (ApplicationKeysSort): Application key attribute used to sort results. Sort order is ascending by default. In order to specify a descending sort, prefix the attribute with a minus sign.. [optional]
            filter (str): Filter application keys by the specified string.. [optional]
            filter_created_at_start (str): Only include application keys created on or after the specified date.. [optional]
            filter_created_at_end (str): Only include application keys created on or before the specified date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListApplicationKeysResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._list_service_account_application_keys_endpoint.default_arguments(kwargs)
        kwargs["service_account_id"] = service_account_id
        return self._list_service_account_application_keys_endpoint.call_with_http_info(**kwargs)

    def update_service_account_application_key(self, service_account_id, app_key_id, body, **kwargs):
        """Edit an application key for this service account  # noqa: E501

        Edit an application key owned by this service account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_service_account_application_key(service_account_id, app_key_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            service_account_id (str): The ID of the service account.
            app_key_id (str): The ID of the application key.
            body (ApplicationKeyUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (float/tuple): timeout setting for this request. If one
                number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PartialApplicationKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs = self._update_service_account_application_key_endpoint.default_arguments(kwargs)
        kwargs["service_account_id"] = service_account_id
        kwargs["app_key_id"] = app_key_id
        kwargs["body"] = body
        return self._update_service_account_application_key_endpoint.call_with_http_info(**kwargs)
