# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.v2.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
)


def lazy_import():
    from datadog_api_client.v2.model.security_monitoring_filter import SecurityMonitoringFilter
    from datadog_api_client.v2.model.security_monitoring_rule_case import SecurityMonitoringRuleCase
    from datadog_api_client.v2.model.security_monitoring_rule_options import SecurityMonitoringRuleOptions
    from datadog_api_client.v2.model.security_monitoring_rule_query import SecurityMonitoringRuleQuery

    globals()["SecurityMonitoringFilter"] = SecurityMonitoringFilter
    globals()["SecurityMonitoringRuleCase"] = SecurityMonitoringRuleCase
    globals()["SecurityMonitoringRuleOptions"] = SecurityMonitoringRuleOptions
    globals()["SecurityMonitoringRuleQuery"] = SecurityMonitoringRuleQuery


class SecurityMonitoringRuleUpdatePayload(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {
        ("version",): {
            "inclusive_maximum": 2147483647,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "cases": ([SecurityMonitoringRuleCase],),  # noqa: E501
            "filters": ([SecurityMonitoringFilter],),  # noqa: E501
            "has_extended_title": (bool,),  # noqa: E501
            "is_enabled": (bool,),  # noqa: E501
            "message": (str,),  # noqa: E501
            "name": (str,),  # noqa: E501
            "options": (SecurityMonitoringRuleOptions,),  # noqa: E501
            "queries": ([SecurityMonitoringRuleQuery],),  # noqa: E501
            "tags": ([str],),  # noqa: E501
            "version": (int,),  # noqa: E501
        }

    discriminator = None

    attribute_map = {
        "cases": "cases",  # noqa: E501
        "filters": "filters",  # noqa: E501
        "has_extended_title": "hasExtendedTitle",  # noqa: E501
        "is_enabled": "isEnabled",  # noqa: E501
        "message": "message",  # noqa: E501
        "name": "name",  # noqa: E501
        "options": "options",  # noqa: E501
        "queries": "queries",  # noqa: E501
        "tags": "tags",  # noqa: E501
        "version": "version",  # noqa: E501
    }

    read_only_vars = {}

    _composed_schemas = {}

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SecurityMonitoringRuleUpdatePayload - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            cases ([SecurityMonitoringRuleCase]): Cases for generating signals.. [optional]  # noqa: E501
            filters ([SecurityMonitoringFilter]): Additional queries to filter matched events before they are processed.. [optional]  # noqa: E501
            has_extended_title (bool): Whether the notifications include the triggering group-by values in their title.. [optional]  # noqa: E501
            is_enabled (bool): Whether the rule is enabled.. [optional]  # noqa: E501
            message (str): Message for generated signals.. [optional]  # noqa: E501
            name (str): Name of the rule.. [optional]  # noqa: E501
            options (SecurityMonitoringRuleOptions): [optional]  # noqa: E501
            queries ([SecurityMonitoringRuleQuery]): Queries for selecting logs which are part of the rule.. [optional]  # noqa: E501
            tags ([str]): Tags for generated signals.. [optional]  # noqa: E501
            version (int): The version of the rule being updated.. [optional]  # noqa: E501
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Helper creating a new instance from a response."""

        self = super(SecurityMonitoringRuleUpdatePayload, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        return self
