"""Add indexes on nodes

Revision ID: 90d6250dc394
Revises: 6b30d917f125
Create Date: 2024-10-05 17:20:13.317534+00:00

"""
# pylint: disable=no-member, invalid-name, missing-function-docstring, unused-import, no-name-in-module

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '90d6250dc394'
down_revision = '6b30d917f125'
branch_labels = None
depends_on = None


def upgrade():
    with op.batch_alter_table('node', schema=None) as batch_op:
        batch_op.create_index('cursor_index', ['created_at', 'id'], unique=False, postgresql_using='btree')


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('node', schema=None) as batch_op:
        batch_op.drop_index('cursor_index', postgresql_using='btree')
