# Library Documentation

If you encounter any problems or have suggestions for improvement while using this library, we kindly request that you open an issue on our GitHub repository. Your feedback is invaluable in helping us enhance the quality and functionality of the library. Please feel free to describe the issue in detail, including any relevant information, steps to reproduce, or expected behavior. We appreciate your contribution to making this library better for all users. Thank you.

# Function Documentation

# To Use The Library

```python
from datamusepython import DatamusePython
print(DatamusePython.{function})
'''

## getAdjectiveByRelation
Retrieves adjectives related to a given noun within specific topics using the Datamuse API.

**Args:**
- `word1` (str): The noun for which you want to find related adjectives.
- `word` (str): The topics to consider for related adjectives.

**Returns:**
- `str`: A space-separated string of related adjectives.

## getWordSpelledSimilar
Retrieves words that are spelled similarly to a given word using the Datamuse API.

**Args:**
- `word` (str): The word to find similar spellings for.

**Returns:**
- `str`: A space-separated string of words with similar spellings.

## getWordsThatSoundSimilar
Retrieves words that sound similar to a given word using the Datamuse API.

**Args:**
- `word` (str): The word to find words that sound similar to.

**Returns:**
- `str`: A space-separated string of words that sound similar.

## nouns_described_by_adjective (Deprecated)
Retrieves nouns commonly described by a given adjective using the Datamuse API.

**Args:**
- `adjective` (str): The adjective to find associated nouns for.

**Returns:**
- `str`: A space-separated string of associated nouns.

**Note:**
This function is deprecated. Please use 'getNounsMatchingAdjective' instead.

## getNounsMatchingAdjective
Retrieves nouns commonly described by the given adjective using the Datamuse API.

**Args:**
- `adjective` (str): The adjective to find associated nouns for.

**Returns:**
- `str`: A space-separated string of associated nouns.

## getWordWithDifferentPrefix
Retrieves words related to 'word1' that have a specific 'word' prefix using the Datamuse API.

**Args:**
- `word1` (str): The base word to find related words for.
- `word` (str): The desired prefix for related words.

**Returns:**
- `str`: A space-separated string of related words.

## getWordWithDifferentSuffix
Retrieves words related to 'word1' that have a specific 'word' suffix using the Datamuse API.

**Args:**
- `word1` (str): The base word to find related words for.
- `word` (str): The desired suffix for related words.

**Returns:**
- `str`: A space-separated string of related words.

## getWordWithCertainAmountOfLetters
Retrieves words with a specific number of letters that combine 'word1', 'letters', and 'word2' using the Datamuse API.

**Args:**
- `word1` (str): The first part of the word.
- `letters` (str): The specific letters to include.
- `word2` (str): The second part of the word.

**Returns:**
- `str`: A space-separated string of words with the specified letters and format.

## getRhymingWords
Retrieves words that rhyme with 'rhyming_word' and are related to 'base_word' using the Datamuse API.

**Args:**
- `base_word` (str): The base word to find related rhyming words for.
- `rhyming_word` (str): The word to find rhyming words for.

**Returns:**
- `str`: A space-separated string of related rhyming words.

## getWordRythm
Retrieves words that rhyme with a given word using the Datamuse API.

**Args:**
- `word1` (str): The word to find rhyming words for.

**Returns:**
- `str`: A space-separated string of rhyming words.

## getWordSuggestions
Retrieves word suggestions based on an input word using the Datamuse API.

**Args:**
- `word1` (str): The input word to get suggestions for.

**Returns:**
- `str`: A space-separated string of suggested words.

## getWordThatFollowWord
Retrieves words that follow 'base_word' in a sentence and start with the specified 'prefix' using the Datamuse API.

**Args:**
- `base_word` (str): The base word to find following words for.
- `prefix` (str): The desired prefix for following words.

**Returns:**
- `str`: A space-separated string of following words.

## getWordThatDescribesAdjective
Retrieves words that commonly describe the given adjective using the Datamuse API.

**Args:**
- `word1` (str): The adjective to find associated describing words for.

**Returns:**
- `str`: A space-separated string of describing words.

## getWordTriggeredByAssociation
Retrieves words triggered by association with a given word using the Datamuse API.

**Args:**
- `word1` (str): The word to find associated words for.

**Returns:**
- `str`: A space-separated string of associated words.

