# dawn-python

[![PyPI version](https://badge.fury.io/py/dawn-python.svg?v=0.1.4)](https://badge.fury.io/py/dawn-python)

[ctypeslib](https://github.com/trolldbois/ctypeslib) based python bindings to the [Dawn](https://dawn.googlesource.com/dawn) WebGPU engine with a focus on the compute pipeline. Besides the autogenerated bindings, a small `utils` interface (similar to [wgpu-py](https://github.com/pygfx/wgpu-py)) is provided to make it easier to run compute.

## How to use

1. Install from PyPI

`pip install dawn-python`

2. Import utils, and webgpu
```python
from pydawn import utils, webgpu

if __name__ == "__main__":
    # Creating an adapter
    adapter = utils.request_adapter_sync(power_preference=webgpu.WGPUPowerPreference_HighPerformance)

    # Creating a device with a list of required features
    dev = utils.request_device_sync(adapter, [webgpu.WGPUFeatureName_ShaderF16, webgpu.WGPUFeatureName_TimestampQuery])
```

For more details see `examples/query_set.py`

## Generating bindings

1. [Build dawn](https://dawn.googlesource.com/dawn/+/HEAD/docs/quickstart-cmake.md) or use the pre-built lib in the repo
2. `pip install ctypeslib2`
3. `clang2py -l libwebgpu_dawn.dylib webgpu.h --nm nm_patch.py -o webgpu.py`

## Examples

`python3 examples/simple_compute.py`

## Supported platforms

- [x] MacOS
- [ ] Ubuntu
- [ ] Windows

## License

BSD 3-Clause, please see [LICENSE](https://dawn.googlesource.com/dawn/+/HEAD/LICENSE)