# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import datetime
import typing
from enum import Enum

class AdvanceEpoch:
    time: AdvanceTime
    epoch_id: builtins.int
    json: typing.Any
    def __new__(cls, epoch_id:builtins.int, time:AdvanceTime) -> AdvanceEpoch: ...
    def __repr__(self) -> builtins.str: ...

class AdvanceSettlementEpoch:
    time: AdvanceTime
    actions: builtins.list[SettlementAction]
    epoch_id: builtins.int
    json: typing.Any
    def __new__(cls, epoch_id:builtins.int, time:AdvanceTime, actions:typing.Sequence[SettlementAction]) -> AdvanceSettlementEpoch: ...
    def __repr__(self) -> builtins.str: ...

class AdvanceTime:
    value: builtins.int
    timestamp: builtins.int
    json: typing.Any
    def __new__(cls, value:builtins.int, timestamp:builtins.int) -> AdvanceTime: ...
    def __repr__(self) -> builtins.str: ...

class Balance:
    r"""
    Maps token address to balance amount
    """
    def __new__(cls, amount:Decimal, address:TokenSymbol) -> Balance: ...
    def __repr__(self) -> builtins.str: ...
    def __len__(self) -> builtins.int: ...
    def __getitem__(self, key:TokenSymbol) -> Decimal: ...
    def __setitem__(self, key:TokenSymbol, value:Decimal) -> None: ...
    @classmethod
    def default(cls, _cls:type) -> Balance:
        r"""
        Return an empty `Balance` with zero for every token.
        """
    @classmethod
    def new_from_many(cls, _cls:type, amounts:typing.Mapping[TokenSymbol, Decimal]) -> Balance:
        r"""
        Construct a `Balance` from a mapping (`dict`) of
        `TokenSymbol` → `Decimal` amounts.
        """
    def total_value(self) -> Decimal:
        r"""
        Total value of this balance, obtained by summing
        every token amount. This will be either in USD or DDX, depending on
        its contents.
        """
    def amounts(self) -> builtins.list[Decimal]:
        r"""
        Raw amounts ordered by the canonical token list.
        """

class Block:
    r"""
    We use a single `BlockProducer` to sequence blocks along with other requests to ensure that
    all Execution Operators synchronize their state with Ethereum event in the same order.
    
    # Notes
    
    Some Ethereum events (e.g. Deposits) must only be processed on confirmed blocks.
    Block confirmation count is handled client-side during execution. The block producer's
    responsibility is just to post block numbers into the `RequestQueue`.
    """
    json: typing.Any
    def __new__(cls, number:builtins.int) -> Block: ...
    def __repr__(self) -> builtins.str: ...

class BookOrder:
    r"""
    A Bid or Ask in the orderbook (maker order)
    """
    side: OrderSide
    r"""
    Bid = 0, Ask = 1
    """
    amount: Decimal
    r"""
    Order amount
    """
    price: Decimal
    r"""
    Price offered to takers
    """
    trader_address: builtins.str
    r"""
    Maker address
    """
    strategy_id_hash: builtins.str
    r"""
    Maker strategy identifier
    """
    book_ordinal: builtins.int
    r"""
    Per market ordinal sequencing inclusion in the order book
    """
    time_value: builtins.int
    r"""
    Time stamp of the post order transaction
    """
    def __new__(cls, side:OrderSide, amount:Decimal, price:Decimal, trader_address:builtins.str, strategy_id_hash:builtins.str, book_ordinal:builtins.int, time_value:builtins.int) -> BookOrder: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> BookOrder: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> BookOrder:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class BookOrderKey:
    symbol: ProductSymbol
    order_hash: builtins.str
    def __new__(cls, symbol:ProductSymbol, order_hash:builtins.str) -> BookOrderKey: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> BookOrderKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> BookOrderKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class CancelAllIntent:
    r"""
    Batch cancel all orders for a given strategy
    """
    symbol: ProductSymbol
    strategy: builtins.str
    r"""
    Strategy to cancel orders for
    """
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function.
    """
    session_key_signature: typing.Optional[builtins.str]
    r"""
    EIP-191 signature of the 1CT session public key
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the order cancellation intent attributes
    """
    json: typing.Any
    def __new__(cls, symbol:ProductSymbol, strategy:builtins.str, nonce:builtins.str, session_key_signature:typing.Optional[builtins.str], signature:typing.Optional[builtins.str]=None) -> CancelAllIntent: ...
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class CancelOrderIntent:
    symbol: ProductSymbol
    order_hash: builtins.str
    r"""
    hash of the corresponding order intent
    """
    nonce: builtins.str
    r"""
    `nonce` specified in the order intent to cancel (to lookup the order without storing its hash)
    A salt for uniqueness of the EIP-712 hash function. May optionally have business meaning to the client.
    """
    session_key_signature: typing.Optional[builtins.str]
    r"""
    EIP-191 signature of the 1CT session public key
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the order cancellation intent attributes
    """
    json: typing.Any
    def __new__(cls, symbol:ProductSymbol, order_hash:builtins.str, nonce:builtins.str, session_key_signature:typing.Optional[builtins.str], signature:typing.Optional[builtins.str]=None) -> CancelOrderIntent: ...
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class Decimal:
    r"""
    Wrapped rust_decimal::Decimal. Constructor only supports str, e.g d = Decimal("123.456")
    """
    def __new__(cls, maybe_value:typing.Optional[typing.Any]=None) -> Decimal:
        r"""
        Create a new Decimal In Python:
        let d1 = Decimal("123.456")
        let d2 = Decimal("-987.654")
        let d3 = Decimal("456")
        let d4 = Decimal() # Decimal("0")
        Accepts `None`, another `Decimal`, a string, an `int`, or a `float`.  
        When no value (or `None`) is supplied the resulting `Decimal` is zero.
        """
    def recorded_amount(self) -> Decimal:
        r"""
        Returns a value rounded toward zero to `TOKEN_UNIT_SCALE` decimal
        places, matching the precision stored on-chain as `RecordedAmount`.
        """
    def to_usdc_grains(self) -> builtins.int:
        r"""
        Converts the current amount into raw USDC grains
        (`u128`, scaled by `10^TOKEN_UNIT_SCALE`).
        Fails if the result does not fit in `u128`.
        """
    def to_ddx_grains(self) -> builtins.int:
        r"""
        Converts the current amount into raw DDX grains
        (`u128`, scaled by `10^18`).
        Fails if the result does not fit in `u128`.
        """
    @classmethod
    def from_usdc_grains(cls, _cls:type, u:builtins.int) -> Decimal:
        r"""
        Creates a `Decimal` from a `u128` expressed in USDC grains
        (i.e. already scaled by `10^TOKEN_UNIT_SCALE`).
        """
    @classmethod
    def from_ddx_grains(cls, _cls:type, u:builtins.int) -> Decimal:
        r"""
        Creates a `Decimal` from a `u128` expressed in DDX grains
        (i.e. already scaled by `10^18`).
        """
    def quantize(self, precision:builtins.int) -> Decimal:
        r"""
        Returns a copy of this value rounded toward zero to the requested
        number of fractional digits (`precision`).
        """
    def __setstate__(self, state:typing.Any) -> None: ...
    def __getstate__(self) -> typing.Any: ...
    def __repr__(self) -> builtins.str: ...
    def __eq__(self, other:typing.Any) -> builtins.bool: ...
    def __ne__(self, other:typing.Any) -> builtins.bool: ...
    def __lt__(self, other:typing.Any) -> builtins.bool: ...
    def __le__(self, other:typing.Any) -> builtins.bool: ...
    def __gt__(self, other:typing.Any) -> builtins.bool: ...
    def __ge__(self, other:typing.Any) -> builtins.bool: ...
    def __hash__(self) -> builtins.int: ...
    def __add__(self, other:typing.Any) -> Decimal: ...
    def __radd__(self, other:typing.Any) -> Decimal: ...
    def __sub__(self, other:typing.Any) -> Decimal: ...
    def __rsub__(self, other:typing.Any) -> Decimal: ...
    def __mul__(self, other:typing.Any) -> Decimal: ...
    def __rmul__(self, other:typing.Any) -> Decimal: ...
    def __truediv__(self, other:typing.Any) -> Decimal: ...
    def __rtruediv__(self, other:typing.Any) -> Decimal: ...
    def __mod__(self, other:typing.Any) -> Decimal: ...
    def __rmod__(self, other:typing.Any) -> Decimal: ...
    def __pow__(self, exponent:typing.Any, modulo:typing.Any=None) -> Decimal: ...
    def __rpow__(self, base:typing.Any, modulo:typing.Any=None) -> Decimal: ...
    def __neg__(self) -> Decimal: ...
    def __abs__(self) -> Decimal: ...
    def __int__(self) -> builtins.int: ...
    def __float__(self) -> builtins.float: ...

class DerivadexSMT:
    r"""
    Wrapped DerivaDEX Sparse Merkle Tree.
    """
    def all_book_orders_for_symbol(self, symbol:ProductSymbol) -> builtins.list[tuple[BookOrderKey, BookOrder]]:
        r"""
        Helper that returns the filtered list described by the method.
        """
    def all_positions_for_symbol(self, symbol:ProductSymbol) -> builtins.list[tuple[PositionKey, Position]]:
        r"""
        Helper that returns the filtered list described by the method.
        """
    def all_prices_for_symbol(self, symbol:ProductSymbol) -> builtins.list[tuple[PriceKey, Price]]:
        r"""
        Helper that returns the filtered list described by the method.
        """
    def all_leaves(self) -> builtins.list[tuple[H256, Item]]:
        r"""
        Helper that returns the filtered list described by the method.
        """
    def epoch_metadata(self, key:EpochMetadataKey) -> typing.Optional[EpochMetadata]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_epoch_metadata(self, key:EpochMetadataKey, maybe_inner:typing.Optional[EpochMetadata]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_epoch_metadatas(self) -> builtins.list[tuple[EpochMetadataKey, EpochMetadata]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def insurance_fund_contribution(self, key:InsuranceFundContributionKey) -> typing.Optional[InsuranceFundContribution]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_insurance_fund_contribution(self, key:InsuranceFundContributionKey, maybe_inner:typing.Optional[InsuranceFundContribution]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_insurance_fund_contributions(self) -> builtins.list[tuple[InsuranceFundContributionKey, InsuranceFundContribution]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def tradable_product(self, key:TradableProductKey) -> typing.Optional[TradableProduct]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_tradable_product(self, key:TradableProductKey, maybe_inner:typing.Optional[TradableProduct]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_tradable_products(self) -> builtins.list[tuple[TradableProductKey, TradableProduct]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def specs(self, key:SpecsKey) -> typing.Optional[Specs]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_specs(self, key:SpecsKey, maybe_inner:typing.Optional[Specs]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_specs(self) -> builtins.list[tuple[SpecsKey, Specs]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def signer(self, key:SignerKey) -> typing.Optional[Signer]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_signer(self, key:SignerKey, maybe_inner:typing.Optional[Signer]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_signers(self) -> builtins.list[tuple[SignerKey, Signer]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def stats(self, key:StatsKey) -> typing.Optional[Stats]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_stats(self, key:StatsKey, maybe_inner:typing.Optional[Stats]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_stats(self) -> builtins.list[tuple[StatsKey, Stats]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def insurance_fund(self, key:InsuranceFundKey) -> typing.Optional[InsuranceFund]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_insurance_fund(self, key:InsuranceFundKey, maybe_inner:typing.Optional[InsuranceFund]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_insurance_funds(self) -> builtins.list[tuple[InsuranceFundKey, InsuranceFund]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def price(self, key:PriceKey) -> typing.Optional[Price]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_price(self, key:PriceKey, maybe_inner:typing.Optional[Price]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_prices(self) -> builtins.list[tuple[PriceKey, Price]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def book_order(self, key:BookOrderKey) -> typing.Optional[BookOrder]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_book_order(self, key:BookOrderKey, maybe_inner:typing.Optional[BookOrder]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_book_orders(self) -> builtins.list[tuple[BookOrderKey, BookOrder]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def position(self, key:PositionKey) -> typing.Optional[Position]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_position(self, key:PositionKey, maybe_inner:typing.Optional[Position]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_positions(self) -> builtins.list[tuple[PositionKey, Position]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def strategy(self, key:StrategyKey) -> typing.Optional[Strategy]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_strategy(self, key:StrategyKey, maybe_inner:typing.Optional[Strategy]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_strategies(self) -> builtins.list[tuple[StrategyKey, Strategy]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def trader(self, key:TraderKey) -> typing.Optional[Trader]:
        r"""
        Fetch the item stored at `key`, or `None` if the leaf is empty.
        """
    def store_trader(self, key:TraderKey, maybe_inner:typing.Optional[Trader]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf and return the new
        SMT root hash.
        """
    def all_traders(self) -> builtins.list[tuple[TraderKey, Trader]]:
        r"""
        Return every item of this type currently stored in the tree.
        """
    def __repr__(self) -> builtins.str: ...
    def __new__(cls) -> DerivadexSMT:
        r"""
        Construct an empty in-memory SMT with a fresh root.
        """
    @classmethod
    def from_genesis(cls, _cls:type, insurance_fund_cap:Balance, ddx_fee_pool:Decimal, specs:typing.Any, current_time:datetime.datetime) -> DerivadexSMT:
        r"""
        Build the genesis SMT, taking `current_time` into account for futures.
        """
    def root(self) -> H256:
        r"""
        Current SMT root hash.
        """
    def merkle_proof(self, keys:typing.Sequence[H256]) -> MerkleProof:
        r"""
        Generate a compiled Merkle proof covering all provided leaf `keys`.
        """
    def store_item_by_key(self, key:H256, maybe_inner:typing.Optional[Item]) -> H256:
        r"""
        Insert (`Some`) or delete (`None`) a leaf at `key` and return the
        updated tree root hash.
        """
    def __deepcopy__(self, _memo:dict) -> DerivadexSMT: ...

class EpochMetadata:
    r"""
    Metadata about an epoch that has been transitioned.
    """
    ddx_fee_pool: Decimal
    r"""
    The DDX fee pool. This represents the total DDX fees collected in this epoch and are
    distributed among custodians during a valid checkpoint.
    """
    next_book_ordinals: builtins.dict[ProductSymbol, builtins.int]
    r"""
    The next book ordinals for all of the active markets. This mapping
    allows follower nodes to reliably generate the market index from the
    sparse merkle tree. The ordinals are logged at the end of the epoch and are None if this is
    the current epoch.
    """
    def __new__(cls, ddx_fee_pool:Decimal, next_book_ordinals:typing.Mapping[ProductSymbol, builtins.int]) -> EpochMetadata: ...
    @classmethod
    def default(cls, _cls:type) -> EpochMetadata:
        r"""
        Return empty `EpochMetadata` with zero fee pool and no order ordinals.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> EpochMetadata: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> EpochMetadata:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class EpochMetadataKey:
    epoch_id: builtins.int
    def __new__(cls, epoch_id:builtins.int) -> EpochMetadataKey: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> EpochMetadataKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> EpochMetadataKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class H256:
    r"""
    Wrapped sparse_merkle_tree::H256.
    """
    @classmethod
    def from_bytes(cls, _cls:type, b:builtins.bytes) -> H256:
        r"""
        Construct an `H256` from a 32-byte buffer passed from Python.
        Raises `H256Error` when the supplied slice is not exactly 32 bytes long.
        """
    def as_bytes(self) -> builtins.bytes:
        r"""
        Return the underlying 32-byte value as an immutable `bytes`/`memoryview`.
        """
    @staticmethod
    def zero() -> H256:
        r"""
        Return a new zero hash (all bits set to 0).
        """
    def is_zero(self) -> builtins.bool:
        r"""
        `true` if this value equals the zero hash.
        """
    def get_bit(self, i:builtins.int) -> builtins.bool:
        r"""
        Return the bit at position `i` (0 = most-significant bit).
        """
    def set_bit(self, i:builtins.int) -> None:
        r"""
        Set the bit at position `i` to `1`.
        """
    def clear_bit(self, i:builtins.int) -> None:
        r"""
        Clear the bit at position `i` (set it to `0`).
        """
    def fork_height(self, key:H256) -> builtins.int:
        r"""
        Return the length (in bits) of the common prefix between this key and `key`.
        """
    def parent_path(self, height:builtins.int) -> H256:
        r"""
        Return a new key that keeps the first `height` bits of this key
        (i.e. the path of the parent node at that height).
        """
    def copy_bits(self, start:builtins.int) -> H256:
        r"""
        Copy the suffix of this key starting at bit `start` into a new `H256`.
        """
    def __setstate__(self, state:typing.Any) -> None: ...
    def __getstate__(self) -> typing.Any: ...
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class IndexFundPerpetual:
    allocation: builtins.dict[builtins.str, Decimal]
    rebalance_interval: builtins.int
    initial_index_price: Decimal
    tick_size: Decimal
    max_order_notional: Decimal
    max_taker_price_deviation: Decimal
    min_order_size: Decimal
    def __new__(cls, **kwds) -> IndexFundPerpetual: ...

class IndexPrice:
    r"""
    An index price is the price update of an instrument coming from the price feed.
    
    It is signed by the price feed's enclave.
    """
    symbol: ProductSymbol
    r"""
    Symbol of the instrument
    """
    price: Decimal
    r"""
    Current market price in the source exchange
    """
    prev_price: Decimal
    r"""
    The previous price update. Useful to prove that no prices were skipped.
    """
    metadata: PriceMetadata
    r"""
    Additional metadata required by the price feed to initialize
    """
    timestamp: builtins.int
    json: typing.Any
    def __new__(cls, symbol:ProductSymbol, price:Decimal, prev_price:Decimal, metadata:PriceMetadata, timestamp:builtins.int) -> IndexPrice: ...
    def hash(self) -> builtins.str:
        r"""
        Compute the hash of this index price request.
        """
    def __repr__(self) -> builtins.str: ...

class InsuranceFund:
    def __len__(self) -> builtins.int: ...
    def __getitem__(self, key:TokenSymbol) -> Decimal: ...
    def __setitem__(self, key:TokenSymbol, value:Decimal) -> None: ...
    def __new__(cls, amount:Decimal, symbol:TokenSymbol) -> InsuranceFund:
        r"""
        Construct a balance initialized with `amount` of `symbol`.
        """
    @classmethod
    def default(cls, cls:type) -> InsuranceFund:
        r"""
        Return an empty balance with zero for every token.
        """
    @classmethod
    def new_from_many(cls, cls:type, amounts:typing.Mapping[TokenSymbol, Decimal]) -> InsuranceFund:
        r"""
        Construct a balance from a mapping of token amounts.
        """
    def total_value(self) -> Decimal:
        r"""
        Total value of this balance, obtained by summing
        every token amount. This will be either in USD or DDX, depending on
        its contents.
        """
    def amounts(self) -> builtins.list[Decimal]:
        r"""
        Raw amounts ordered by the canonical token list.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> InsuranceFund: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> InsuranceFund:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class InsuranceFundContribution:
    r"""
    An insurance fund contribution
    """
    avail_balance: Balance
    r"""
    Total contribution to the insurance fund, minus any withdrawals
    """
    locked_balance: Balance
    r"""
    Balance locked for withdrawal
    """
    def __new__(cls, avail_balance:Balance, locked_balance:Balance) -> InsuranceFundContribution: ...
    @classmethod
    def default(cls, _cls:type) -> InsuranceFundContribution:
        r"""
        Return an empty `InsuranceFundContribution` with zero balances.
        """
    def update_avail_balance(self, symbol:TokenSymbol, amount:Decimal) -> Balance:
        r"""
        Return a copy of `avail_balance` with `symbol` set to `amount`.
        """
    def update_locked_balance(self, symbol:TokenSymbol, amount:Decimal) -> Balance:
        r"""
        Return a copy of `locked_balance` with `symbol` set to `amount`.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> InsuranceFundContribution: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> InsuranceFundContribution:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class InsuranceFundContributionKey:
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> InsuranceFundContributionKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> InsuranceFundContributionKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """
    def __new__(cls, inner:builtins.str) -> InsuranceFundContributionKey: ...

class InsuranceFundKey:
    def __new__(cls) -> InsuranceFundKey: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> InsuranceFundKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> InsuranceFundKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class Item:
    def __repr__(self) -> builtins.str: ...
    def item_kind(self) -> ItemKind:
        r"""
        Return this item's [`ItemKind`] discriminant.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode the wrapped value for hashing / storage.
        """
    @classmethod
    def abi_decode_value_into_item(cls, cls:type, kind:ItemKind, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode the bytes produced by `abi_encoded_value()` back into
        an [`Item`] of the supplied kind.
        """
    @classmethod
    def decode_key(cls, cls:type, kind:ItemKind, encoded_key:H256) -> typing.Any:
        r"""
        Decode a 32-byte SMT key into its strongly-typed form for
        the provided item kind.
        """

class MerkleProof:
    def __repr__(self) -> builtins.str: ...
    def as_bytes(self) -> builtins.bytes:
        r"""
        Return the compiled proof as a raw byte slice suitable for
        on-chain verification.
        """

class MintPriceCheckpoint:
    time_value: builtins.int
    json: typing.Any
    def __new__(cls, time_value:builtins.int) -> MintPriceCheckpoint: ...
    def __repr__(self) -> builtins.str: ...

class ModifyOrderIntent:
    r"""
    Modify order intents are intents that modify the original order details of a specific order
    identified by its order hash.
    
    This is identical to a cancel and a re-placing of the new order,
    the only difference from doing them separately being that the execution is atomic when executed
    as a ModifyOrderIntent.
    """
    order_hash: builtins.str
    r"""
    Order hash of the order to modify
    """
    symbol: ProductSymbol
    r"""
    Symbol of the market
    """
    strategy: builtins.str
    r"""
    Strategy Id (label)
    """
    side: OrderSide
    r"""
    Side: 0-Long, 1-Short
    """
    order_type: OrderType
    r"""
    0-Limit, 1-Market, 2-Stop-Limit
    """
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function. May optionally have business meaning to the client.
    """
    amount: Decimal
    r"""
    Order amount
    """
    price: Decimal
    r"""
    Order price. For a limit order, it is the limit price.
    """
    stop_price: Decimal
    r"""
    Stop price. Set to 0 if the order is not a Stop-Limit.
    """
    session_key_signature: typing.Optional[builtins.str]
    r"""
    EIP-191 signature of the 1CT session public key
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the order intent attributes
    """
    json: typing.Any
    def __new__(cls, order_hash:builtins.str, symbol:ProductSymbol, strategy:builtins.str, side:OrderSide, order_type:OrderType, nonce:builtins.str, amount:Decimal, price:Decimal, stop_price:Decimal, session_key_signature:typing.Optional[builtins.str], signature:typing.Optional[builtins.str]=None) -> ModifyOrderIntent: ...
    def hash(self) -> builtins.str:
        r"""
        Compute the hash of this modify order intent.
        """
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class OperatorContext:
    r"""
    Holds application-layer environment information
    
    Information in here as analogous to something like the operating system locale, but at the application layer.
    In the git application for instance, such context includes name and email.
    Storing this information globally saves us the noise of repeating the same informational arguments
    in multiple functions throughout the application.
    
    This does NOT include logic inputs of individual units like configuration parameters (like db credentials),
    business rules (like epoch sizes), etc. We capture these in `TrustedContext` and `NodeContext`, and
    pass them explicitly to individual components (in the name of functional testability).
    
    This information does not impact logic routes (testability)
    """
    contract_address: builtins.str
    chain_id: builtins.int

class OrderIntent:
    r"""
    Order intents are meta-transactions signed by traders Ethereum wallets and submitted to operators.
    
    They come in through the API, signed by their maker. We verify that:
    
    a) the signatures recovers the `trader_address`
    b) the maker has enough collateral to be solvent when the order gets filled
    
    Following verification, we match an order intent against the order book. This may result in
    fill(s) or posting into the order book depending on the matches found.
    """
    symbol: ProductSymbol
    r"""
    Symbol of the market
    """
    strategy: builtins.str
    r"""
    Strategy Id (label)
    """
    side: OrderSide
    r"""
    Side: 0-Long, 1-Short
    """
    order_type: OrderType
    r"""
    0-Limit, 1-Market, 2-Stop-Limit
    """
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function. May optionally have business meaning to the client.
    """
    amount: Decimal
    r"""
    Order amount
    """
    price: Decimal
    r"""
    Order price. For a limit order, it is the limit price.
    """
    stop_price: Decimal
    r"""
    Stop price. Set to 0 if the order is not a Stop-Limit.
    """
    session_key_signature: typing.Optional[builtins.str]
    r"""
    EIP-191 signature of the 1CT session public key
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the order intent attributes
    """
    json: typing.Any
    def __new__(cls, symbol:ProductSymbol, strategy:builtins.str, side:OrderSide, order_type:OrderType, nonce:builtins.str, amount:Decimal, price:Decimal, stop_price:Decimal, session_key_signature:typing.Optional[builtins.str], signature:typing.Optional[builtins.str]=None) -> OrderIntent: ...
    def hash(self) -> builtins.str:
        r"""
        Compute the hash of this order intent.
        """
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class OrderType:
    def __repr__(self) -> builtins.str: ...

class Position:
    r"""
    An individual position held in an strategy
    """
    side: PositionSide
    r"""
    The position side: Long = 0, Short = 1
    """
    balance: Decimal
    r"""
    The position size denominated in the same unit as the underlying
    """
    avg_entry_price: Decimal
    r"""
    The average entry price (updated when adding to the position)
    """
    def __new__(cls, side:PositionSide, balance:Decimal, avg_entry_price:Decimal) -> Position: ...
    @classmethod
    def default(cls, _cls:type) -> Position:
        r"""
        Return an empty `Position` with zero balance and no entry price.
        """
    def bankruptcy_price(self, mark_price:Decimal, account_total_value:Decimal) -> Decimal:
        r"""
        Bankruptcy price at which margin would be exhausted.
        """
    def unrealized_pnl(self, price:Decimal) -> Decimal:
        r"""
        Unrealized profit and loss at the specified `price`.
        """
    def avg_pnl(self, price:Decimal) -> Decimal:
        r"""
        Average P&L per contract at the specified `price`.
        """
    def increase(self, price:Decimal, amount:Decimal) -> tuple[Position, Decimal]:
        r"""
        Increase position size by `amount` at `price`; returns the new
        position together with any realized P&L.
        """
    def decrease(self, price:Decimal, amount:Decimal) -> tuple[Position, Decimal]:
        r"""
        Decrease position size by `amount` at `price`; returns the new
        position and realized P&L.
        """
    def cross_over(self, price:Decimal, amount:Decimal) -> tuple[Position, Decimal]:
        r"""
        Reverse side by `amount` at `price`; returns updated position and P&L.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Position: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Position:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class PositionKey:
    trader_address: builtins.str
    strategy_id_hash: builtins.str
    symbol: ProductSymbol
    def __new__(cls, trader_address:builtins.str, strategy_id_hash:builtins.str, symbol:ProductSymbol) -> PositionKey: ...
    def as_strategy_key(self) -> StrategyKey:
        r"""
        Convert this position key into its owner `StrategyKey`.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> PositionKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> PositionKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class Price:
    r"""
    A price value (used for funding and liquidations)
    """
    index_price: Decimal
    r"""
    The index price number coming from a price feed
    """
    mark_price_metadata: MarkPriceMetadata
    ordinal: builtins.int
    time_value: builtins.int
    mark_price: Decimal
    def __new__(cls, index_price:Decimal, mark_price_metadata:MarkPriceMetadata, ordinal:builtins.int, time_value:builtins.int) -> Price: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Price: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Price:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class PriceKey:
    symbol: ProductSymbol
    index_price_hash: builtins.str
    def __new__(cls, symbol:ProductSymbol, index_price_hash:builtins.str) -> PriceKey: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> PriceKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> PriceKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class ProductSymbol:
    def __new__(cls, symbol:builtins.str) -> ProductSymbol:
        r"""
        Construct a product symbol from a string representation such as `"ETHP"`.
        Returns an error if the supplied string cannot be parsed.
        """
    def __deepcopy__(self, _memo:dict) -> ProductSymbol: ...
    def __repr__(self) -> builtins.str: ...
    def __len__(self) -> builtins.int: ...
    def is_perpetual(self) -> builtins.bool:
        r"""
        Return `true` when this symbol represents a perpetual contract.
        """
    def is_future(self) -> builtins.bool:
        r"""
        Return `true` when this symbol corresponds to a fixed-expiry future.
        """
    def futures_quarter(self) -> typing.Optional[Quarter]:
        r"""
        For futures symbols, return the associated `Quarter`; otherwise `None`.
        """
    def price_metadata(self) -> PriceMetadata:
        r"""
        Construct a `PriceMetadata` value appropriate for this product type.
        """

class ProfileUpdateIntent:
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function. May optionally have business meaning to the client.
    """
    pay_fees_in_ddx: builtins.bool
    r"""
    Sets the flag in the trader profile
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the order intent attributes
    """
    json: typing.Any
    def __new__(cls, nonce:builtins.str, pay_fees_in_ddx:builtins.bool, signature:typing.Optional[builtins.str]=None) -> ProfileUpdateIntent: ...
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class QuarterlyExpiryFuture:
    r"""
    Quarterly expiry futures are contracts that expire at a month 28-day basis.
    
    This only include attributes common to all quarterly expiry futures.
    """
    underlying: builtins.str
    tick_size: Decimal
    max_order_notional: Decimal
    max_taker_price_deviation: Decimal
    min_order_size: Decimal
    def __new__(cls, **kwds) -> QuarterlyExpiryFuture: ...

class SettlementAction:
    @classmethod
    def FuturesExpiry(cls, _cls:type, quarter:Quarter) -> SettlementAction:
        r"""
        Settlement action representing the expiry of a quarterly future.
        """
    def futures_quarter(self) -> typing.Optional[Quarter]:
        r"""
        For futures-expiry actions, return the quarter of the quarterly expiry future.
        """
    def __repr__(self) -> builtins.str: ...

class Signer:
    def __new__(cls, inner:builtins.str) -> Signer:
        r"""
        Construct a new `Signer` identified by `inner` release hash.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Signer: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Signer:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class SignerKey:
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> SignerKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> SignerKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """
    def __new__(cls, inner:builtins.str) -> SignerKey: ...

class SingleNamePerpetual:
    r"""
    A set of specification about each market (aka derivative contracts)
    """
    underlying: builtins.str
    tick_size: Decimal
    max_order_notional: Decimal
    max_taker_price_deviation: Decimal
    min_order_size: Decimal
    def __new__(cls, **kwds) -> SingleNamePerpetual: ...

class Specs:
    def __new__(cls, inner:builtins.str) -> Specs:
        r"""
        Wrapped `SpecsExpr`.
        """
    def as_product_specs(self, specs_kind:SpecsKind) -> ProductSpecs:
        r"""
        Convert this expression into concrete `ProductSpecs` of the requested kind.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Specs: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Specs:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class SpecsKey:
    r"""
    Common key for all specs kind.
    """
    kind: SpecsKind
    name: builtins.str
    r"""
    Defined by convention associated with the specs kind.
    At the time of writing, the naming conventions are:
    
    - `SingleNamePerpetual`: The product market symbol for the single name perpetuals in our universe (e.g. ETHP, BTCP).
    - `MarketGateway`: The host name (e.g. api.binance.com, api.exchange.coinbase.com).
    """
    def __new__(cls, kind:SpecsKind, name:builtins.str) -> SpecsKey: ...
    def current_tradable_products(self, current_time:datetime.datetime) -> builtins.list[TradableProductKey]:
        r"""
        List the currently tradable products that are live at `current_time`.
        """
    def has_lifecycle(self) -> typing.Optional[builtins.bool]:
        r"""
        Return whether this specs has a lifecycle constraint.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> SpecsKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> SpecsKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class Stats:
    r"""
    A trader statistics value. This is used to store verified data like trade
    volume data for trade mining.
    """
    maker_volume: Decimal
    r"""
    The maker volume of the trader during this trade mining period
    """
    taker_volume: Decimal
    r"""
    The taker volume of the trader during this trade mining period
    """
    def __new__(cls, maker_volume:Decimal, taker_volume:Decimal) -> Stats: ...
    @classmethod
    def default(cls, _cls:type) -> Stats:
        r"""
        Return a `Stats` structure with all counters set to zero.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Stats: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Stats:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class StatsKey:
    trader: builtins.str
    def __new__(cls, trader:builtins.str) -> StatsKey: ...
    def as_trader_key(self) -> TraderKey:
        r"""
        Convert this stats key into the corresponding `TraderKey`.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> StatsKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> StatsKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class Strategy:
    r"""
    An trading strategy (aka sub-account, formerly known as account)
    """
    avail_collateral: Balance
    r"""
    Amount of the collateral per token available as margin
    """
    locked_collateral: Balance
    r"""
    Amount of collateral per token frozen for withdrawal
    """
    max_leverage: builtins.int
    r"""
    Maximum amount of leverage allowed
    """
    frozen: builtins.bool
    r"""
    Whether the entire account frozen for strategy tokenization
    """
    def __new__(cls, avail_collateral:Balance, locked_collateral:Balance, max_leverage:builtins.int, frozen:builtins.bool) -> Strategy: ...
    @classmethod
    def default(cls, _cls:type) -> Strategy:
        r"""
        Return an empty `Strategy` with default parameters.
        """
    def update_avail_collateral(self, symbol:TokenSymbol, amount:Decimal) -> Balance:
        r"""
        Return a new `Balance` obtained by updating this strategy's
        available collateral for `symbol` to `amount`.
        """
    def update_locked_collateral(self, symbol:TokenSymbol, amount:Decimal) -> Balance:
        r"""
        Return a new `Balance` obtained by updating this strategy's
        locked collateral for `symbol` to `amount`.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Strategy: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Strategy:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class StrategyKey:
    trader_address: builtins.str
    strategy_id_hash: builtins.str
    def __new__(cls, trader_address:builtins.str, strategy_id_hash:builtins.str) -> StrategyKey: ...
    @staticmethod
    def generate_strategy_id_hash(strategy_id:builtins.str) -> builtins.str:
        r"""
        Deterministically hash `strategy_id` into a `StrategyIdHash`.
        """
    def as_position_key(self, symbol:ProductSymbol) -> PositionKey:
        r"""
        Derive the `PositionKey` for `symbol` that belongs to this strategy.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> StrategyKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> StrategyKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class TradableProduct:
    def __new__(cls) -> TradableProduct: ...
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> TradableProduct: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> TradableProduct:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class TradableProductKey:
    specs: SpecsKey
    parameters: typing.Optional[TradableProductParameters]
    def __new__(cls, specs:SpecsKey, parameters:typing.Optional[TradableProductParameters]) -> TradableProductKey: ...
    def as_product_symbol(self) -> ProductSymbol:
        r"""
        Convert this key into its `ProductSymbol`.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> TradableProductKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> TradableProductKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """

class Trader:
    r"""
    An individual trader
    """
    avail_ddx_balance: Decimal
    r"""
    The DDX balance stated / usable for trading
    """
    locked_ddx_balance: Decimal
    r"""
    The DDX balance locked for withdrawal
    """
    pay_fees_in_ddx: builtins.bool
    r"""
    Switch to paying fees with DDX
    """
    access_denied: builtins.bool
    r"""
    Whether the trader is denied access to the platform
    """
    referral_address: builtins.str
    def __new__(cls, avail_ddx_balance:Decimal, locked_ddx_balance:Decimal, pay_fees_in_ddx:builtins.bool) -> Trader: ...
    def set_referral_address(self, hex:builtins.str) -> None: ...
    @classmethod
    def default(cls, _cls:type) -> Trader:
        r"""
        Return a zero-initialized `Trader` value.
        """
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> Trader: ...
    def as_item(self) -> Item:
        r"""
        Wrap this concrete structure into the generic [`Item`] enum.
        """
    @classmethod
    def from_item(cls, _cls:type, item:Item) -> Trader:
        r"""
        Down-cast a generic [`Item`] into this concrete type.
        """
    def abi_encoded_value(self) -> builtins.bytes:
        r"""
        ABI-encode this value.
        """
    @classmethod
    def abi_decode_value_into_item(cls, _cls:type, abi_encoded_value:builtins.bytes) -> typing.Optional[Item]:
        r"""
        Decode bytes back into an [`Item`] of this concrete type.
        """
    def is_void(self) -> builtins.bool:
        r"""
        `true` when this value represents the special *void* marker
        used to delete a leaf from the SMT.
        """

class TraderKey:
    def __repr__(self) -> builtins.str: ...
    def __deepcopy__(self, _memo:dict) -> TraderKey: ...
    def encode_key(self) -> H256:
        r"""
        Encode this state-key into the 32-byte format used on-chain.
        """
    @classmethod
    def decode_key(cls, _cls:type, value:H256) -> TraderKey:
        r"""
        Decode a previously-encoded key back into its strongly-typed form.
        """
    def __new__(cls, inner:builtins.str) -> TraderKey: ...

class UpdateProductListings:
    r"""
    A signal to update product listings is sent by the operator clock tick mechanism based on the
    current wall clock time. It is used to add or remove products from the exchange's product
    listings.
    
    Motivating example: there are different futures products all corresponding to the same futures
    specs class, but each future is listed/available to trade at different times. For example, ETHF{}
    is a specs class representing futures tracking the price of ETH. ETHFH is a specific tradable
    product referring to the ETH future expiring in March that is listed at the time of writing one
    week before the expiry of the preceding September future until its expiry in March. The operator
    will update the listings to add ETHFH and remove ETHFH at the appropriate times.
    """
    additions: builtins.list[TradableProductKey]
    removals: builtins.list[TradableProductKey]
    json: typing.Any
    def __new__(cls, additions:typing.Sequence[TradableProductKey], removals:typing.Sequence[TradableProductKey]) -> UpdateProductListings: ...
    def __repr__(self) -> builtins.str: ...

class WithdrawDDXIntent:
    r"""
    Traders signal their intent to withdraw ddx which freezes the specified amount
    in their account.
    
    Funds may be available on-chain at the next checkpoint the operator is kind enough to
    "prove" the withdrawals on behalf of traders.
    
    Otherwise, traders may submit a merkle proof at any time after a `Checkpoint` to collect
    their funds.
    """
    amount: Decimal
    r"""
    Amount to withdraw
    """
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function. May optionally have
    business meaning to the client.
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the withdraw ddx intent attributes
    """
    json: typing.Any
    def __new__(cls, amount:Decimal, nonce:builtins.str, signature:typing.Optional[builtins.str]=None) -> WithdrawDDXIntent: ...
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class WithdrawIntent:
    r"""
    Traders signal their intent to withdraw which freezes the requested collateral in their account.
    
    Funds may be available on-chain at the next checkpoint the operator is kind enough to "prove"
    the withdrawals on behalf of traders. Otherwise, traders may submit a merkle proof
    at any time after a `Checkpoint` to collect their funds.
    """
    strategy_id: builtins.str
    r"""
    Strategy Id (label)
    """
    currency: builtins.str
    r"""
    Ethereum address of the collateral token (ERC-20)
    """
    amount: Decimal
    r"""
    Amount to withdraw
    """
    nonce: builtins.str
    r"""
    A salt for uniqueness of the EIP-712 hash function. May optionally have business meaning to the client.
    """
    signature: builtins.str
    r"""
    EIP-712 signature of the withdraw intent attributes
    """
    json: typing.Any
    def __new__(cls, strategy_id:builtins.str, currency:builtins.str, amount:Decimal, nonce:builtins.str, signature:typing.Optional[builtins.str]=None) -> WithdrawIntent: ...
    def __repr__(self) -> builtins.str: ...
    def hash_eip712(self, message_metadata:typing.Optional[tuple[builtins.int, builtins.str]]=None) -> builtins.str:
        r"""
        Compute the EIP-712 digest for this intent.
        Passing `message_metadata=(chain_id, verifying_contract)`
        overrides the default values used in the hash.
        """
    def recover_signer(self) -> tuple[builtins.str, builtins.str]:
        r"""
        Recover the `(eip712_hash, trader_address)` that signed
        this intent.
        """

class InsuranceFundUpdateKind(Enum):
    Unassigned = ...
    Deposit = ...
    Withdraw = ...

    def __new__(cls, name:builtins.str) -> InsuranceFundUpdateKind:
        r"""
        Parse an `InsuranceFundUpdateKind` from its string discriminant.
        """

class ItemKind(Enum):
    Empty = ...
    Trader = ...
    Strategy = ...
    Position = ...
    BookOrder = ...
    Price = ...
    InsuranceFund = ...
    Stats = ...
    Signer = ...
    Specs = ...
    TradableProduct = ...
    InsuranceFundContribution = ...
    EpochMetadata = ...

    def __new__(cls, value:builtins.int) -> ItemKind:
        r"""
        Create an `ItemKind` from its numeric discriminant (`u8`).  
        Returns `PyValueError` if the value does not correspond to a variant.
        """

    def discriminants(self) -> dict:
        r"""
        Return a Python `dict` that maps variant names to their discriminant values.
        """

class MarkPriceMetadata(Enum):
    r"""
    Metadata for calculating the mark price, along with the current index price
    """
    Ema = ...
    r"""
    The mark price is calculated using the ema
    The calculated exponential moving address (input to the mark price and verifiable using orderbook snapshot in the aggregate tree)
    """
    Average = ...
    r"""
    The mark price is calculated as an average using the sum and amount of previous index prices
    Mark price = (accum + index_price) / (count + 1)
    """

    ema: typing.Optional[Decimal]

    @classmethod
    def from_dict(cls, _cls:type, ob:typing.Any) -> MarkPriceMetadata:
        r"""
        Deserialize `MarkPriceMetadata` from the operator serialization.
        """

    def __repr__(self) -> builtins.str: ...

    def __deepcopy__(self, _memo:dict) -> MarkPriceMetadata: ...

class OrderSide(Enum):
    Bid = ...
    Ask = ...

    def __new__(cls, name:builtins.str) -> OrderSide:
        r"""
        Parse an `OrderSide` (`"Bid"` or `"Ask"`) from its string `name`.
        """

class PositionSide(Enum):
    Empty = ...
    Long = ...
    Short = ...

class PriceDirection(Enum):
    r"""
    Direction of the price movement compared to the last price update executed.
    """
    Up = ...
    Down = ...
    Flat = ...
    Unknown = ...
    r"""
    Not enough context to determine the direction
    """

class PriceMetadata(Enum):
    Empty = ...
    SingleNamePerpetual = ...
    IndexFundPerpetual = ...
    QuarterlyExpiryFuture = ...

    weights: typing.Optional[builtins.dict[builtins.str, Decimal]]

    @classmethod
    def from_dict(cls, _cls:type, ob:typing.Any) -> PriceMetadata:
        r"""
        Deserialize `PriceMetadata` from the operator serialization.
        """

    def __repr__(self) -> builtins.str: ...

class ProductSpecs(Enum):
    SingleNamePerpetual = ...
    IndexFundPerpetual = ...
    QuarterlyExpiryFuture = ...

    tick_size: Decimal

    max_order_notional: Decimal

    max_taker_price_deviation: Decimal

    min_order_size: Decimal

    def __repr__(self) -> builtins.str: ...

    def underlying_symbols(self) -> builtins.list[builtins.str]:
        r"""
        Return the list of underlying symbols referenced by this specification.
        """

class Quarter(Enum):
    March = ...
    June = ...
    September = ...
    December = ...

    def __repr__(self) -> builtins.str: ...

    def __new__(cls, name:builtins.str) -> Quarter:
        r"""
        Parse a calendar quarter ("March", "June", …) from `name`.
        """

    @classmethod
    def find_quarter(cls, _cls:type, datetime:datetime.datetime) -> Quarter:
        r"""
        Determine the quarter in which `datetime` lies.
        """

    def expiry_date_after(self, datetime:datetime.datetime) -> datetime.datetime:
        r"""
        First expiry date for this quarter strictly after `datetime`.
        """

    @classmethod
    def upcoming_expiry_date(cls, _cls:type, current_time:datetime.datetime) -> datetime.datetime:
        r"""
        Next quarterly-futures expiry date from `current_time`.
        """

    def next(self) -> Quarter:
        r"""
        Return the quarter immediately following this one.
        """

class SpecsKind(Enum):
    SingleNamePerpetual = ...
    IndexFundPerpetual = ...
    QuarterlyExpiryFuture = ...
    MarketGateway = ...

    def __new__(cls, kind:builtins.str) -> SpecsKind:
        r"""
        Parse a `SpecsKind` from its string representation.
        """

class StrategyUpdateKind(Enum):
    r"""
    Differentiates various types of strategy updates.
    
    Enumerates different scenarios like deposits, withdrawals, and other events
    that impact a trader's strategy, enabling appropriate response and adjustment in the strategy.
    """
    Unassigned = ...
    r"""
    Used as placeholder in default events.
    """
    Deposit = ...
    r"""
    Reacts to contract deposit event.
    """
    Withdraw = ...
    r"""
    Reacts to contract withdraw event, decreasing the (claimed) locked collateral.
    """
    WithdrawIntent = ...
    r"""
    A client request to withdraw funds, which moves funds from available collateral to locked collateral.
    """
    FundingPayment = ...
    RealizedPnl = ...

    def __new__(cls, name:builtins.str) -> StrategyUpdateKind:
        r"""
        Parse a `StrategyUpdateKind` from its string discriminant.
        """

class TokenSymbol(Enum):
    r"""
    Well-known ERC20 tokens used in the underpinning of the protocol
    """
    USDC = ...
    DDX = ...

    @classmethod
    def from_address(cls, _cls:type, address:builtins.str) -> TokenSymbol:
        r"""
        Construct a `TokenSymbol` from the on-chain token `address`.
        """

    def address(self) -> builtins.str:
        r"""
        Return the canonical on-chain address for this token.
        """

class TradableProductParameters(Enum):
    QuarterlyExpiryFuture = ...

    quarter: typing.Optional[Quarter]

    @classmethod
    def from_dict(cls, _cls:type, ob:typing.Any) -> TradableProductParameters:
        r"""
        Deserialize `TradableProductParameters` from the operator serialization.
        """

    def __repr__(self) -> builtins.str: ...

class TradeSide(Enum):
    Maker = ...
    Taker = ...

    def trading_fee(self, amount:Decimal, price:Decimal) -> Decimal:
        r"""
        Compute the trading fee for the given `amount` at `price` on this side.
        """

class TraderUpdateKind(Enum):
    r"""
    Differentiates various types of trader updates.
    """
    Unassigned = ...
    r"""
    Used as placeholder in default events.
    """
    DepositDDX = ...
    r"""
    Reacts to contract DDX deposit event.
    """
    WithdrawDDX = ...
    r"""
    Reacts to contract DDX withdraw event, decreasing the (claimed) locked collateral.
    """
    WithdrawDDXIntent = ...
    TradeMiningReward = ...
    Profile = ...
    r"""
    Trader profile parameter updates sent via a client intention.
    """
    FeeDistribution = ...
    r"""
    Fee distribution event.
    """
    Denial = ...
    r"""
    Denial of access to the platform due to KYC blacklist, expiration, or other reasons.
    """
    Admission = ...
    r"""
    Admission to the platform due to KYC re-approval, unbanned, or other reasons.
    """

    def __new__(cls, name:builtins.str) -> TraderUpdateKind:
        r"""
        Parse a `TraderUpdateKind` from its string discriminant.
        """

def get_operator_context() -> OperatorContext:
    r"""
    Get the operator application context for this DerivaDEX instance.
    """

def reinit_operator_context() -> None:
    r"""
    Reinitialize the operator application context for this DerivaDEX instance.
    """

class CoreCommonError(Exception): ...

class DecimalError(Exception): ...

class H256Error(Exception): ...

