from __future__ import annotations

from textual.pilot import Pilot
from textual.widgets.markdown import MarkdownFence

from tests.snapshots.snap_compare import SnapCompare
from decoder.cli.textual_ui.widgets.messages import AssistantMessage


def test_snapshot_allows_horizontal_scrolling_for_long_code_blocks(
    snap_compare: SnapCompare,
) -> None:
    assistant_message_md = """Here's a very long print instruction:

```python
def lorem_ipsum():
    # Print a very long line (Lorem Ipsum)
    print("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.")
```

The `print` statement includes a very long line of Lorem Ipsum text to demonstrate a lengthy output."""

    async def run_before(pilot: Pilot) -> None:
        app = pilot.app
        assistant_message = AssistantMessage(assistant_message_md)
        messages_area = app.query_one("#messages")
        await messages_area.mount(assistant_message)
        await assistant_message.write_initial_content()
        await pilot.pause(0.1)

        markdown_fence = app.query_one(MarkdownFence)
        markdown_fence.scroll_relative(x=15, immediate=True)

    assert snap_compare(
        "base_snapshot_test_app.py:BaseSnapshotTestApp",
        run_before=run_before,
        terminal_size=(120, 36),
    )
