# coding: utf-8

"""
    Deep3 Labs API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v0.0.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictFloat, StrictInt, StrictStr, constr, validator

from typing import List, Union

from deep3.models.chains_response import ChainsResponse
from deep3.models.hodl_c1_response import HodlC1Response
from deep3.models.hodl_c1_x_token_request import HodlC1XTokenRequest
from deep3.models.hodl_c1_x_token_response import HodlC1XTokenResponse
from deep3.models.hodl_c1_x_tokens_request import HodlC1XTokensRequest
from deep3.models.hodl_c1_x_tokens_response_inner import HodlC1XTokensResponseInner
from deep3.models.hodler_response import HodlerResponse
from deep3.models.models_response import ModelsResponse
from deep3.models.prediction_response import PredictionResponse
from deep3.models.stake_sage_h_response import StakeSageHResponse
from deep3.models.stake_sage_l_response import StakeSageLResponse

from deep3.api_client import ApiClient
from deep3.api_response import ApiResponse
from deep3.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class Deep3Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_chains(self, **kwargs) -> ChainsResponse:  # noqa: E501
        """Get currently supported chains and the active machine learning models  # noqa: E501

        Will return currently supported chains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chains(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChainsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_chains_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_chains_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_chains_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get currently supported chains and the active machine learning models  # noqa: E501

        Will return currently supported chains  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChainsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chains" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "ChainsResponse",
        }

        return self.api_client.call_api(
            '/chains', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_hodl_c1_prediction(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> HodlC1Response:  # noqa: E501
        """Get a HODL-C1 prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_prediction(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HodlC1Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_hodl_c1_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_hodl_c1_prediction_with_http_info(chain_id, address, **kwargs)  # noqa: E501

    @validate_arguments
    def get_hodl_c1_prediction_with_http_info(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a HODL-C1 prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_prediction_with_http_info(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HodlC1Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'chain_id',
            'address'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hodl_c1_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['chain_id']:
            _path_params['chainId'] = _params['chain_id']

        if _params['address']:
            _path_params['address'] = _params['address']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "HodlC1Response",
        }

        return self.api_client.call_api(
            '/hodl-c1/chain/{chainId}/account/{address}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_hodl_c1_x_token_prediction(self, hodl_c1_x_token_request : Annotated[HodlC1XTokenRequest, Field(..., description="An object with a primary token address and any mappings for different chain addresses")], **kwargs) -> HodlC1XTokenResponse:  # noqa: E501
        """Get a HODL-C1 cross-chain token prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_x_token_prediction(hodl_c1_x_token_request, async_req=True)
        >>> result = thread.get()

        :param hodl_c1_x_token_request: An object with a primary token address and any mappings for different chain addresses (required)
        :type hodl_c1_x_token_request: HodlC1XTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HodlC1XTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_hodl_c1_x_token_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_hodl_c1_x_token_prediction_with_http_info(hodl_c1_x_token_request, **kwargs)  # noqa: E501

    @validate_arguments
    def get_hodl_c1_x_token_prediction_with_http_info(self, hodl_c1_x_token_request : Annotated[HodlC1XTokenRequest, Field(..., description="An object with a primary token address and any mappings for different chain addresses")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a HODL-C1 cross-chain token prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_x_token_prediction_with_http_info(hodl_c1_x_token_request, async_req=True)
        >>> result = thread.get()

        :param hodl_c1_x_token_request: An object with a primary token address and any mappings for different chain addresses (required)
        :type hodl_c1_x_token_request: HodlC1XTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HodlC1XTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'hodl_c1_x_token_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hodl_c1_x_token_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['hodl_c1_x_token_request'] is not None:
            _body_params = _params['hodl_c1_x_token_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "HodlC1XTokenResponse",
        }

        return self.api_client.call_api(
            '/hodl-c1/x/token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_hodl_c1_x_token_predictions(self, hodl_c1_x_tokens_request : Annotated[HodlC1XTokensRequest, Field(..., description="An array of objects with a primary token address and any mappings for different chain addresses")], **kwargs) -> List[HodlC1XTokensResponseInner]:  # noqa: E501
        """Get HODL-C1 cross-chain token predictions  # noqa: E501

        Will return the predictions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_x_token_predictions(hodl_c1_x_tokens_request, async_req=True)
        >>> result = thread.get()

        :param hodl_c1_x_tokens_request: An array of objects with a primary token address and any mappings for different chain addresses (required)
        :type hodl_c1_x_tokens_request: HodlC1XTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[HodlC1XTokensResponseInner]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_hodl_c1_x_token_predictions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_hodl_c1_x_token_predictions_with_http_info(hodl_c1_x_tokens_request, **kwargs)  # noqa: E501

    @validate_arguments
    def get_hodl_c1_x_token_predictions_with_http_info(self, hodl_c1_x_tokens_request : Annotated[HodlC1XTokensRequest, Field(..., description="An array of objects with a primary token address and any mappings for different chain addresses")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get HODL-C1 cross-chain token predictions  # noqa: E501

        Will return the predictions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodl_c1_x_token_predictions_with_http_info(hodl_c1_x_tokens_request, async_req=True)
        >>> result = thread.get()

        :param hodl_c1_x_tokens_request: An array of objects with a primary token address and any mappings for different chain addresses (required)
        :type hodl_c1_x_tokens_request: HodlC1XTokensRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[HodlC1XTokensResponseInner], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'hodl_c1_x_tokens_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hodl_c1_x_token_predictions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['hodl_c1_x_tokens_request'] is not None:
            _body_params = _params['hodl_c1_x_tokens_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[HodlC1XTokensResponseInner]",
        }

        return self.api_client.call_api(
            '/hodl-c1/x/tokens', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_hodler_prediction(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], public_address : Annotated[constr(strict=True), Field(..., description="The public address for the wallet")], **kwargs) -> HodlerResponse:  # noqa: E501
        """(Deprecated) Get a Hodler prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodler_prediction(chain_id, public_address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param public_address: The public address for the wallet (required)
        :type public_address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HodlerResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_hodler_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_hodler_prediction_with_http_info(chain_id, public_address, **kwargs)  # noqa: E501

    @validate_arguments
    def get_hodler_prediction_with_http_info(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], public_address : Annotated[constr(strict=True), Field(..., description="The public address for the wallet")], **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) Get a Hodler prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hodler_prediction_with_http_info(chain_id, public_address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param public_address: The public address for the wallet (required)
        :type public_address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HodlerResponse, status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("GET /hodler/{chainId}/{publicAddress} is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'chain_id',
            'public_address'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hodler_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['chain_id']:
            _path_params['chainId'] = _params['chain_id']

        if _params['public_address']:
            _path_params['publicAddress'] = _params['public_address']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "HodlerResponse",
        }

        return self.api_client.call_api(
            '/hodler/{chainId}/{publicAddress}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_models(self, **kwargs) -> ModelsResponse:  # noqa: E501
        """Get active machine learning models and the chains they support  # noqa: E501

        Will return active machine learning models  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_models(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ModelsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_models_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_models_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_models_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get active machine learning models and the chains they support  # noqa: E501

        Will return active machine learning models  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_models_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ModelsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_models" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "ModelsResponse",
        }

        return self.api_client.call_api(
            '/models', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_prediction(self, model : Annotated[StrictStr, Field(..., description="The model for the prediction")], chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], public_address : Annotated[constr(strict=True), Field(..., description="The public address to predict")], **kwargs) -> PredictionResponse:  # noqa: E501
        """Get a prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prediction(model, chain_id, public_address, async_req=True)
        >>> result = thread.get()

        :param model: The model for the prediction (required)
        :type model: str
        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param public_address: The public address to predict (required)
        :type public_address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PredictionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_prediction_with_http_info(model, chain_id, public_address, **kwargs)  # noqa: E501

    @validate_arguments
    def get_prediction_with_http_info(self, model : Annotated[StrictStr, Field(..., description="The model for the prediction")], chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], public_address : Annotated[constr(strict=True), Field(..., description="The public address to predict")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prediction_with_http_info(model, chain_id, public_address, async_req=True)
        >>> result = thread.get()

        :param model: The model for the prediction (required)
        :type model: str
        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param public_address: The public address to predict (required)
        :type public_address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PredictionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'model',
            'chain_id',
            'public_address'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['model']:
            _path_params['model'] = _params['model']

        if _params['chain_id']:
            _path_params['chainId'] = _params['chain_id']

        if _params['public_address']:
            _path_params['publicAddress'] = _params['public_address']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "PredictionResponse",
        }

        return self.api_client.call_api(
            '/prediction/{model}/{chainId}/{publicAddress}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_stake_sage_h_prediction(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> StakeSageHResponse:  # noqa: E501
        """Get a StakeSage-H prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stake_sage_h_prediction(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StakeSageHResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_stake_sage_h_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_stake_sage_h_prediction_with_http_info(chain_id, address, **kwargs)  # noqa: E501

    @validate_arguments
    def get_stake_sage_h_prediction_with_http_info(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a StakeSage-H prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stake_sage_h_prediction_with_http_info(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StakeSageHResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'chain_id',
            'address'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stake_sage_h_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['chain_id']:
            _path_params['chainId'] = _params['chain_id']

        if _params['address']:
            _path_params['address'] = _params['address']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "StakeSageHResponse",
        }

        return self.api_client.call_api(
            '/stakesage-h/chain/{chainId}/account/{address}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_stake_sage_l_prediction(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> StakeSageLResponse:  # noqa: E501
        """Get a StakeSage-L prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stake_sage_l_prediction(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StakeSageLResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_stake_sage_l_prediction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_stake_sage_l_prediction_with_http_info(chain_id, address, **kwargs)  # noqa: E501

    @validate_arguments
    def get_stake_sage_l_prediction_with_http_info(self, chain_id : Annotated[Union[StrictFloat, StrictInt], Field(..., description="The chain id for the prediction")], address : Annotated[constr(strict=True), Field(..., description="The address for the account")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get a StakeSage-L prediction  # noqa: E501

        Will return the prediction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_stake_sage_l_prediction_with_http_info(chain_id, address, async_req=True)
        >>> result = thread.get()

        :param chain_id: The chain id for the prediction (required)
        :type chain_id: float
        :param address: The address for the account (required)
        :type address: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StakeSageLResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'chain_id',
            'address'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stake_sage_l_prediction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['chain_id']:
            _path_params['chainId'] = _params['chain_id']

        if _params['address']:
            _path_params['address'] = _params['address']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey']  # noqa: E501

        _response_types_map = {
            '200': "StakeSageLResponse",
        }

        return self.api_client.call_api(
            '/stakesage-l/chain/{chainId}/account/{address}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
