# DevCycle Python Server SDK

The DevCycle Python SDK used for feature management.

This SDK allows your application to interface with the [DevCycle Bucketing API](https://docs.devcycle.com/bucketing-api/#tag/devcycle).

## Requirements.

* Python 3.7+

## Installation

```sh
pip install devcycle-python-server-sdk
```
(you may need to run `pip` with root permission: `sudo pip install devcycle-python-server-sdk`)

## Getting Started

The core DevCycle objects are in the `devcycle_python_sdk` package. To get started, import the `DevCycleLocalClient` class and the `DevCycleLocalOptions` class. The `DevCycleLocalClient` class is used to interact with the DevCycle API. The `DevCycleLocalOptions` class is used to configure the client.

```python
from devcycle_python_sdk import DevCycleLocalClient, DevCycleLocalOptions
from devcycle_python_sdk.models.user import DevCycleUser

options = DevCycleLocalOptions()

# create an instance of the client class
client = DevCycleLocalClient('DEVCYCLE_SERVER_SDK_KEY', options)

user = DevCycleUser(
    user_id='test',
    email='example@example.ca',
    country='CA'
)

value = client.variable_value(user, 'variable-key', 'default-value')
```

The DevCycle client is designed to work as a singleton in your application. You should create a single instance of the client during application initialization

## Usage

To find usage documentation, visit our [docs](https://docs.devcycle.com/docs/sdk/server-side-sdks/python#usage).

## Development

When developing the SDK it is recommended that you have both a 3.7 and 3.11 python interpreter installed in order to verify changes across different versions of python.

### Dependencies

To set up dependencies for local development, run:
```
pip install -r requirements.test.txt
```

To run the example app against the local version of the API for testing and development, run:
```sh
pip install --editable .
```
from the top level of the repo (same level as setup.py). Then run the example app as normal.


### Linting & Formatting

Linting checks on PRs are run using [ruff](https://github.com/charliermarsh/ruff), and are configured using `.ruff.toml`. To run the linter locally, run this command from the top level of the repo:
```
ruff check .
```

Ruff can automatically fix simple linting errors (the ones marked with `[*]`). To do so, run:
```
ruff check . --fix
```

Formatting checks on PRs are done using [black](https://github.com/psf/black). To run the formatter locally, run this command from the top level of the repo:

```
black --target-version py37 --extend-exclude '_pb2\.pyi?$' .
```

### Unit Tests

To run the unit tests, run:
```bash
pytest
```

### Benchmarks

To run the benchmarks, run:
```bash
pytest --benchmark-only
```

### Protobuf Code Generation

To generate the protobuf source files run the following from the root of the project. Ensure you have `protoc` installed.

```bash
protoc --proto_path=./protobuf/ --python_out=devcycle_python_sdk/protobuf --pyi_out=devcycle_python_sdk/protobuf variableForUserParams.proto
```

This will rebuild the `variableForUserParams_pb2.py` file. DO NOT edit this file directly.