
---

# 📘 `devDocs` – AI-Powered README Generator

`devDocs` is a command-line tool that automatically generates clean, professional `README.md` files by analyzing your **project structure**, **source code**, and any **existing documentation**.

Powered by the **Google Gemini API**, it's ideal for:

* 💡 Open-source contributors
* 🛠️ Internal dev tools
* 🚀 Hackathon projects needing docs fast

---

## 📂 Example Project Layout

Before and after running `devDocs`:

```bash
your-project/
├── src/
│   ├── main.py
│   └── utils.py
├── tests/
├── requirements.txt
├── LICENSE
├── docs/          # ← Generated by devDocs
└── README.md      # ← Overwritten by devDocs (if chosen)
```

---

## ⚙️ How It Works

1. **Scans** project directory and source files
2. **Parses** content (code, comments, old README)
3. **Generates** documentation via Google Gemini
4. **Saves** output in Markdown format

### Optional Features

* Preserve existing README (unless `--overwrite` is set)
* Include/exclude specific files or folders via filters

---

## 📦 Installation

Install via pip:

```bash
pip install devDocs
```

---

## 🔑 Requirements

* Python 3.8+
* Google Gemini API Key (get one at [Google AI Studio](https://aistudio.google.com/))

---

## 🚀 Usage

Run inside your project’s root:

```bash
devDocs [OPTIONS]
```

Paste your **Gemini API key** when prompted.

### CLI Options

| Option          | Description                                       |
| --------------- | ------------------------------------------------- |
| `--path`        | Root folder to scan (default: `.`)                |
| `--name`        | Project name to display in the README             |
| `--description` | Short project summary                             |
| `--authors`     | Comma-separated list of authors                   |
| `--keywords`    | Comma-separated keywords (e.g., cli, docs, ai)    |
| `--overwrite`   | Overwrite existing `README.md` (default: False)   |
| `--output`      | Output folder (default: `docs/`)                  |
| `--exclude`     | Comma-separated paths/extensions to exclude       |
| `--include`     | Comma-separated paths/extensions to force include |

---

### ✅ Example

```bash
devDocs --path . \
        --name "Cool Dev Tool" \
        --description "Generate AI-based READMEs effortlessly" \
        --authors "Gantavya Bansal" \
        --keywords "cli, docs, automation" \
        --output docs \
        --overwrite
```

---

## 🧠 Key Features

✅ Auto-generates structured `README.md`
✅ Respects original files unless `--overwrite`
✅ Fine-grained include/exclude control
✅ Generates a visual folder tree
✅ Clean output in a dedicated `--output` folder
✅ Backed by Google Gemini for high-quality results

---

## 🧱 Tech Stack

* Python 3.8+
* [`google-genai`](https://pypi.org/project/google-generativeai/)
* Built-in: `argparse`, `os`, `logging`, `time`

---

## 🛠️ Dev Notes

### Workflow

```
CLI args → Filter files → Extract context → Call Gemini → Write docs
```

### API Prompt Template

```python
system_instruction = '''
You are Gantavya Bansal, a senior engineer and technical writer.
Generate professional Markdown documentation using context from code and folder structure.
Include:
- Title
- Folder Tree
- Description
- Usage
- Tech Stack
- Known Issues
- Licensing
'''
```

---

## ⚠️ Limitations

* 📶 Requires internet (for Gemini API)
* 🔁 Retry logic for failed API calls is minimal
* ❌ Regex not yet supported in filters
* 📄 Only outputs `.md` format (Markdown)

---

## 📜 License

Released under the **MIT License**. Use, modify, and share freely — attribution appreciated.

---

## 🤝 Contribute

Found a bug or have an idea?
Open an issue or submit a PR — contributions are always welcome!

---