# DevNotes

A tool for managing development notes and project tasks.

## Features

- Project task management
- Code structure analysis
- Mermaid diagram generation
- Function relationship visualization
- Task extraction from code comments
- Trello integration for task synchronization

## Installation

```bash
pip install devnotes
```

To use the diagram rendering functionality, you need to install `mermaid-cli`:

```bash
npm install -g @mermaid-js/mermaid-cli
```

## Usage

### Initialization

```bash
# Initialize a new project with the current directory name
# Initialize a new project with the current directory name
devnotes init

# Initialize a new project with a specific name
devnotes init --name "My Awesome Project"

# Update the project name later
devnotes set-project-name "New Project Name"

# Update settings with latest improvements
devnotes update

# Initialize a new project with a specific name
devnotes init --name "My Awesome Project"
```

### Task Management

```bash
# Add a new task interactively
devnotes task-add-interactive

# List all tasks
devnotes task-list

# Edit an existing task
devnotes task-edit

# Mark a task as done
devnotes task-done 001
```

### Code Analysis

```bash
# Scan the project
devnotes scan
```

#### Task Extraction from Code Comments

You can define tasks directly in your code using special comment tags:

```python
# Simple task
#TASK: Implement error handling

# Task with tags
#TASK(bug,high-priority): Fix memory leak in this function

# Task with metadata
#TASK(feature)[due:2023-12-31][priority:high][status:in_progress]: Add new feature
# DESCRIPTION: This is a detailed description of the task
# It can span multiple lines as long as each line starts with #
```

When you run `devnotes scan`, these comments will be automatically converted to tasks in your project.

Supported metadata fields:
- `due`: Due date for the task (e.g., `2023-12-31`)
- `priority`: Priority level (e.g., `high`, `medium`, `low`)
- `status`: Current status (e.g., `todo`, `in_progress`, `done`)

You can also add a multi-line description by adding comment lines starting with `# DESCRIPTION:` followed by additional comment lines.

### Diagrams

```bash
# Generate a task diagram
devnotes diagram tasks

# Generate a call graph
devnotes diagram callgraph

# Generate a hierarchy diagram
devnotes diagram hierarchy

# Generate a diagram and render it
devnotes diagram tasks --render

# Generate a diagram, render it and open it in the browser
devnotes diagram callgraph --open

# Render a Mermaid diagram to SVG
devnotes render --path .project/call_graph.mmd
```

## Configuration

Settings are stored in `.project/settings.yaml`. You can update the settings with:

```bash
devnotes update
```

### Configuration Options

The `settings.yaml` file supports the following configuration options:

```yaml
# Task status options
statuses: ["todo", "in_progress", "done", "blocked"]
default_status: "todo"
default_tags: []

# Diagram settings
diagram:
  output: "project_structure.mmd"
  style: "graph TD"

# Scan settings
scan:
  exclude: [".project", ".venv"]
  exclude_stdlib_calls: true
```

#### Status Colors

You can customize the colors for each status by adding a `status_colors` section:

```yaml
status_colors:
  todo: "yellow"
  in_progress: "cyan"
  done: "green"
  blocked: "red"
```

### Trello Integration

DevNotes supports synchronizing tasks with Trello:

```bash
# Configure Trello integration (interactive mode)
devnotes trello setup

# Quick setup with automatic list mapping
devnotes trello setup --quick

# Create a new Trello board with appropriate lists and custom fields and custom fields
devnotes trello create-board

# Sync tasks bidirectionally (both to and from Trello)
devnotes trello sync

# Sync only from local to Trello
devnotes trello sync --direction=to

# Sync only from Trello to local
devnotes trello sync --direction=from

# View integration status
devnotes trello status
```

To use this feature, you need to:
1. Obtain an API key and token from Trello (https://trello.com/app-key)
2. Choose one of the following configuration methods:
   - **Method 1 (recommended for new users)**: Run `devnotes trello create-board` to create a new Trello board with all the necessary lists already correctly configured
   - **Method 2**: Run `devnotes trello setup --quick` for quick setup with automatic mapping of existing lists
   - **Method 3**: Run `devnotes trello setup` for detailed manual configuration
3. Follow the on-screen instructions

#### Custom Fields

When you create a new board with `devnotes trello create-board`, the following custom fields are automatically created:

- **Project**: Shows the project name (set during initialization with `devnotes init`)
- **File**: Shows the file path where the task is located
- **Function/Class**: Shows the function or class name related to the task
- **ID DevNotes**: Shows the DevNotes task ID for easy reference

These custom fields make it easier to identify and organize tasks in Trello, especially when you're using a single board for multiple projects.

#### Custom Fields

When you create a new board with `devnotes trello create-board`, the following custom fields are automatically created:

- **Project**: Shows the project name (set during initialization with `devnotes init`)
- **File**: Shows the file path where the task is located
- **Function/Class**: Shows the function or class name related to the task
- **ID DevNotes**: Shows the DevNotes task ID for easy reference

These custom fields make it easier to identify and organize tasks in Trello, especially when you're using a single board for multiple projects.

The quick setup mode (`--quick`) attempts to automatically map Trello lists to task statuses based on common names (e.g., "To Do" → "todo", "In Progress" → "in_progress", etc.). If it can't find a match, it will ask you to manually select the appropriate list.

The `create-board` command is the easiest way to get started, as it automatically creates a new Trello board with all the necessary lists and custom fields already correctly configured for DevNotes.

## Requirements

- Python 3.8+
- Mermaid CLI (optional, for diagram rendering)

## License

MIT