"""
Command registry for DevPulse CLI.
Imports all command modules and makes them available for registration.
"""

from devpulse.commands import track, logs, secrets, stats, sync, ai, health

# List of all command modules with their CLI names
COMMAND_MODULES = [
    ("track", track.app, "Track time and commands"),
    ("logs", logs.app, "Analyze and search logs"),
    ("secrets", secrets.app, "Scan for secrets and sensitive data"),
    ("stats", stats.app, "View analytics and statistics"),
    ("sync", sync.app, "Sync data with cloud dashboard"),
    ("ai", ai.app, "AI-powered insights and suggestions"),
    ("health", health.app, "System health monitoring"),
]
