# Guides

In-depth guides for common tasks and patterns with the DevRev Python SDK.

## Core Guides

<div class="grid cards" markdown>

-   :material-sync:{ .lg .middle } **Sync vs Async**

    ---

    Learn when to use synchronous vs asynchronous clients for optimal performance.

    [:octicons-arrow-right-24: Read Guide](sync-vs-async.md)

-   :material-page-next:{ .lg .middle } **Pagination**

    ---

    Efficiently iterate through large datasets with cursor-based pagination.

    [:octicons-arrow-right-24: Read Guide](pagination.md)

-   :material-alert-circle:{ .lg .middle } **Error Handling**

    ---

    Handle API errors gracefully with structured exceptions.

    [:octicons-arrow-right-24: Read Guide](error-handling.md)

-   :material-console:{ .lg .middle } **Logging & Debugging**

    ---

    Debug issues and monitor SDK behavior with logging.

    [:octicons-arrow-right-24: Read Guide](logging.md)

-   :material-cog:{ .lg .middle } **Configuration**

    ---

    Configure timeouts, retries, and other SDK options.

    [:octicons-arrow-right-24: Read Guide](configuration.md)

-   :material-test-tube:{ .lg .middle } **Testing**

    ---

    Mock the SDK for unit testing your applications.

    [:octicons-arrow-right-24: Read Guide](testing.md)

</div>

## Guide Overview

| Guide | Description | Difficulty |
|-------|-------------|------------|
| [Sync vs Async](sync-vs-async.md) | Choose the right client type | Beginner |
| [Pagination](pagination.md) | Handle large datasets | Beginner |
| [Error Handling](error-handling.md) | Graceful error management | Beginner |
| [Logging](logging.md) | Debug and monitor | Intermediate |
| [Configuration](configuration.md) | Advanced options | Intermediate |
| [Testing](testing.md) | Mock the SDK | Advanced |

## Need More Help?

- [API Reference](../api/index.md) - Detailed API documentation
- [Examples](../examples/index.md) - Real-world code examples
- [GitHub Issues](https://github.com/mgmonteleone/py-dev-rev/issues) - Report bugs or ask questions

