"""DevRev SDK Pydantic Models.

This module contains all Pydantic models for the DevRev API.
"""

from devrev.models.accounts import (
    Account,
    AccountsCreateRequest,
    AccountsCreateResponse,
    AccountsDeleteRequest,
    AccountsDeleteResponse,
    AccountsExportRequest,
    AccountsExportResponse,
    AccountsGetRequest,
    AccountsGetResponse,
    AccountsListRequest,
    AccountsListResponse,
    AccountsMergeRequest,
    AccountsMergeResponse,
    AccountSummary,
    AccountsUpdateRequest,
    AccountsUpdateResponse,
    AccountTier,
)
from devrev.models.articles import (
    Article,
    ArticlesCreateRequest,
    ArticlesCreateResponse,
    ArticlesDeleteRequest,
    ArticlesDeleteResponse,
    ArticlesGetRequest,
    ArticlesGetResponse,
    ArticlesListRequest,
    ArticlesListResponse,
    ArticleStatus,
    ArticleSummary,
    ArticlesUpdateRequest,
    ArticlesUpdateResponse,
)
from devrev.models.base import (
    CustomSchemaSpec,
    DateFilter,
    DateTimeFilter,
    DevRevBaseModel,
    DevRevResponseModel,
    ObjectSummary,
    OrgSummary,
    PaginatedResponse,
    SetTagWithValue,
    StageInfo,
    StageUpdate,
    TagWithValue,
    UserSummary,
)
from devrev.models.code_changes import (
    CodeChange,
    CodeChangesCreateRequest,
    CodeChangesCreateResponse,
    CodeChangesDeleteRequest,
    CodeChangesDeleteResponse,
    CodeChangesGetRequest,
    CodeChangesGetResponse,
    CodeChangesListRequest,
    CodeChangesListResponse,
    CodeChangeSummary,
    CodeChangesUpdateRequest,
    CodeChangesUpdateResponse,
)
from devrev.models.conversations import (
    Conversation,
    ConversationsCreateRequest,
    ConversationsCreateResponse,
    ConversationsDeleteRequest,
    ConversationsDeleteResponse,
    ConversationsExportRequest,
    ConversationsExportResponse,
    ConversationsGetRequest,
    ConversationsGetResponse,
    ConversationsListRequest,
    ConversationsListResponse,
    ConversationSummary,
    ConversationsUpdateRequest,
    ConversationsUpdateResponse,
)
from devrev.models.dev_users import (
    DevUser,
    DevUserExternalIdentity,
    DevUsersActivateRequest,
    DevUsersActivateResponse,
    DevUsersCreateRequest,
    DevUsersCreateResponse,
    DevUsersDeactivateRequest,
    DevUsersDeactivateResponse,
    DevUsersGetRequest,
    DevUsersGetResponse,
    DevUsersIdentitiesLinkRequest,
    DevUsersIdentitiesLinkResponse,
    DevUsersIdentitiesUnlinkRequest,
    DevUsersIdentitiesUnlinkResponse,
    DevUsersListRequest,
    DevUsersListResponse,
    DevUsersMergeRequest,
    DevUsersMergeResponse,
    DevUsersSelfRequest,
    DevUsersSelfResponse,
    DevUsersSelfUpdateRequest,
    DevUsersSelfUpdateResponse,
    DevUserState,
    DevUserSummary,
    DevUsersUpdateRequest,
    DevUsersUpdateResponse,
)
from devrev.models.groups import (
    Group,
    GroupMember,
    GroupMembersAddRequest,
    GroupMembersAddResponse,
    GroupMembersListRequest,
    GroupMembersListResponse,
    GroupMembersRemoveRequest,
    GroupMembersRemoveResponse,
    GroupsCreateRequest,
    GroupsCreateResponse,
    GroupsGetRequest,
    GroupsGetResponse,
    GroupsListRequest,
    GroupsListResponse,
    GroupSummary,
    GroupsUpdateRequest,
    GroupsUpdateResponse,
    GroupType,
)
from devrev.models.links import (
    Link,
    LinksCreateRequest,
    LinksCreateResponse,
    LinksDeleteRequest,
    LinksDeleteResponse,
    LinksGetRequest,
    LinksGetResponse,
    LinksListRequest,
    LinksListResponse,
    LinkSummary,
    LinkType,
)
from devrev.models.parts import (
    Part,
    PartsCreateRequest,
    PartsCreateResponse,
    PartsDeleteRequest,
    PartsDeleteResponse,
    PartsGetRequest,
    PartsGetResponse,
    PartsListRequest,
    PartsListResponse,
    PartSummary,
    PartsUpdateRequest,
    PartsUpdateResponse,
    PartType,
)
from devrev.models.rev_users import (
    RevUser,
    RevUsersCreateRequest,
    RevUsersCreateResponse,
    RevUsersDeleteRequest,
    RevUsersDeleteResponse,
    RevUsersGetRequest,
    RevUsersGetResponse,
    RevUsersListRequest,
    RevUsersListResponse,
    RevUsersMergeRequest,
    RevUsersMergeResponse,
    RevUserState,
    RevUserSummary,
    RevUsersUpdateRequest,
    RevUsersUpdateResponse,
)
from devrev.models.slas import (
    Sla,
    SlasCreateRequest,
    SlasCreateResponse,
    SlasGetRequest,
    SlasGetResponse,
    SlasListRequest,
    SlasListResponse,
    SlaStatus,
    SlasTransitionRequest,
    SlasTransitionResponse,
    SlaSummary,
    SlasUpdateRequest,
    SlasUpdateResponse,
    SlaTrackerStatus,
)
from devrev.models.tags import (
    Tag,
    TagsCreateRequest,
    TagsCreateResponse,
    TagsDeleteRequest,
    TagsDeleteResponse,
    TagsGetRequest,
    TagsGetResponse,
    TagsListRequest,
    TagsListResponse,
    TagSummary,
    TagsUpdateRequest,
    TagsUpdateResponse,
)
from devrev.models.timeline_entries import (
    TimelineEntriesCreateRequest,
    TimelineEntriesCreateResponse,
    TimelineEntriesDeleteRequest,
    TimelineEntriesDeleteResponse,
    TimelineEntriesGetRequest,
    TimelineEntriesGetResponse,
    TimelineEntriesListRequest,
    TimelineEntriesListResponse,
    TimelineEntriesUpdateRequest,
    TimelineEntriesUpdateResponse,
    TimelineEntry,
    TimelineEntryType,
)
from devrev.models.webhooks import (
    Webhook,
    WebhooksCreateRequest,
    WebhooksCreateResponse,
    WebhooksDeleteRequest,
    WebhooksDeleteResponse,
    WebhooksGetRequest,
    WebhooksGetResponse,
    WebhooksListRequest,
    WebhooksListResponse,
    WebhookStatus,
    WebhookSummary,
    WebhooksUpdateRequest,
    WebhooksUpdateResponse,
)
from devrev.models.works import (
    IssuePriority,
    TicketChannels,
    TicketSeverity,
    Work,
    WorksCountRequest,
    WorksCountResponse,
    WorksCreateRequest,
    WorksCreateResponse,
    WorksDeleteRequest,
    WorksDeleteResponse,
    WorksExportRequest,
    WorksExportResponse,
    WorksGetRequest,
    WorksGetResponse,
    WorksListRequest,
    WorksListResponse,
    WorkSummary,
    WorksUpdateRequest,
    WorksUpdateResponse,
    WorkType,
)

__all__ = [
    # Base models
    "DevRevBaseModel",
    "DevRevResponseModel",
    "PaginatedResponse",
    "DateFilter",
    "DateTimeFilter",
    "CustomSchemaSpec",
    "UserSummary",
    "ObjectSummary",
    "OrgSummary",
    "TagWithValue",
    "SetTagWithValue",
    "StageInfo",
    "StageUpdate",
    # Accounts
    "Account",
    "AccountSummary",
    "AccountTier",
    "AccountsCreateRequest",
    "AccountsCreateResponse",
    "AccountsGetRequest",
    "AccountsGetResponse",
    "AccountsListRequest",
    "AccountsListResponse",
    "AccountsUpdateRequest",
    "AccountsUpdateResponse",
    "AccountsDeleteRequest",
    "AccountsDeleteResponse",
    "AccountsMergeRequest",
    "AccountsMergeResponse",
    "AccountsExportRequest",
    "AccountsExportResponse",
    # Articles
    "Article",
    "ArticleSummary",
    "ArticleStatus",
    "ArticlesCreateRequest",
    "ArticlesCreateResponse",
    "ArticlesGetRequest",
    "ArticlesGetResponse",
    "ArticlesListRequest",
    "ArticlesListResponse",
    "ArticlesUpdateRequest",
    "ArticlesUpdateResponse",
    "ArticlesDeleteRequest",
    "ArticlesDeleteResponse",
    # Code Changes
    "CodeChange",
    "CodeChangeSummary",
    "CodeChangesCreateRequest",
    "CodeChangesCreateResponse",
    "CodeChangesGetRequest",
    "CodeChangesGetResponse",
    "CodeChangesListRequest",
    "CodeChangesListResponse",
    "CodeChangesUpdateRequest",
    "CodeChangesUpdateResponse",
    "CodeChangesDeleteRequest",
    "CodeChangesDeleteResponse",
    # Conversations
    "Conversation",
    "ConversationSummary",
    "ConversationsCreateRequest",
    "ConversationsCreateResponse",
    "ConversationsGetRequest",
    "ConversationsGetResponse",
    "ConversationsListRequest",
    "ConversationsListResponse",
    "ConversationsUpdateRequest",
    "ConversationsUpdateResponse",
    "ConversationsDeleteRequest",
    "ConversationsDeleteResponse",
    "ConversationsExportRequest",
    "ConversationsExportResponse",
    # Dev Users
    "DevUser",
    "DevUserSummary",
    "DevUserState",
    "DevUserExternalIdentity",
    "DevUsersCreateRequest",
    "DevUsersCreateResponse",
    "DevUsersGetRequest",
    "DevUsersGetResponse",
    "DevUsersListRequest",
    "DevUsersListResponse",
    "DevUsersUpdateRequest",
    "DevUsersUpdateResponse",
    "DevUsersActivateRequest",
    "DevUsersActivateResponse",
    "DevUsersDeactivateRequest",
    "DevUsersDeactivateResponse",
    "DevUsersIdentitiesLinkRequest",
    "DevUsersIdentitiesLinkResponse",
    "DevUsersIdentitiesUnlinkRequest",
    "DevUsersIdentitiesUnlinkResponse",
    "DevUsersMergeRequest",
    "DevUsersMergeResponse",
    "DevUsersSelfRequest",
    "DevUsersSelfResponse",
    "DevUsersSelfUpdateRequest",
    "DevUsersSelfUpdateResponse",
    # Groups
    "Group",
    "GroupSummary",
    "GroupType",
    "GroupMember",
    "GroupsCreateRequest",
    "GroupsCreateResponse",
    "GroupsGetRequest",
    "GroupsGetResponse",
    "GroupsListRequest",
    "GroupsListResponse",
    "GroupsUpdateRequest",
    "GroupsUpdateResponse",
    "GroupMembersAddRequest",
    "GroupMembersAddResponse",
    "GroupMembersRemoveRequest",
    "GroupMembersRemoveResponse",
    "GroupMembersListRequest",
    "GroupMembersListResponse",
    # Links
    "Link",
    "LinkSummary",
    "LinkType",
    "LinksCreateRequest",
    "LinksCreateResponse",
    "LinksGetRequest",
    "LinksGetResponse",
    "LinksListRequest",
    "LinksListResponse",
    "LinksDeleteRequest",
    "LinksDeleteResponse",
    # Parts
    "Part",
    "PartSummary",
    "PartType",
    "PartsCreateRequest",
    "PartsCreateResponse",
    "PartsGetRequest",
    "PartsGetResponse",
    "PartsListRequest",
    "PartsListResponse",
    "PartsUpdateRequest",
    "PartsUpdateResponse",
    "PartsDeleteRequest",
    "PartsDeleteResponse",
    # Rev Users
    "RevUser",
    "RevUserSummary",
    "RevUserState",
    "RevUsersCreateRequest",
    "RevUsersCreateResponse",
    "RevUsersGetRequest",
    "RevUsersGetResponse",
    "RevUsersListRequest",
    "RevUsersListResponse",
    "RevUsersUpdateRequest",
    "RevUsersUpdateResponse",
    "RevUsersDeleteRequest",
    "RevUsersDeleteResponse",
    "RevUsersMergeRequest",
    "RevUsersMergeResponse",
    # SLAs
    "Sla",
    "SlaSummary",
    "SlaStatus",
    "SlaTrackerStatus",
    "SlasCreateRequest",
    "SlasCreateResponse",
    "SlasGetRequest",
    "SlasGetResponse",
    "SlasListRequest",
    "SlasListResponse",
    "SlasUpdateRequest",
    "SlasUpdateResponse",
    "SlasTransitionRequest",
    "SlasTransitionResponse",
    # Tags
    "Tag",
    "TagSummary",
    "TagsCreateRequest",
    "TagsCreateResponse",
    "TagsGetRequest",
    "TagsGetResponse",
    "TagsListRequest",
    "TagsListResponse",
    "TagsUpdateRequest",
    "TagsUpdateResponse",
    "TagsDeleteRequest",
    "TagsDeleteResponse",
    # Timeline Entries
    "TimelineEntry",
    "TimelineEntryType",
    "TimelineEntriesCreateRequest",
    "TimelineEntriesCreateResponse",
    "TimelineEntriesGetRequest",
    "TimelineEntriesGetResponse",
    "TimelineEntriesListRequest",
    "TimelineEntriesListResponse",
    "TimelineEntriesUpdateRequest",
    "TimelineEntriesUpdateResponse",
    "TimelineEntriesDeleteRequest",
    "TimelineEntriesDeleteResponse",
    # Webhooks
    "Webhook",
    "WebhookSummary",
    "WebhookStatus",
    "WebhooksCreateRequest",
    "WebhooksCreateResponse",
    "WebhooksGetRequest",
    "WebhooksGetResponse",
    "WebhooksListRequest",
    "WebhooksListResponse",
    "WebhooksUpdateRequest",
    "WebhooksUpdateResponse",
    "WebhooksDeleteRequest",
    "WebhooksDeleteResponse",
    # Works
    "Work",
    "WorkSummary",
    "WorkType",
    "IssuePriority",
    "TicketSeverity",
    "TicketChannels",
    "WorksCreateRequest",
    "WorksCreateResponse",
    "WorksGetRequest",
    "WorksGetResponse",
    "WorksListRequest",
    "WorksListResponse",
    "WorksUpdateRequest",
    "WorksUpdateResponse",
    "WorksDeleteRequest",
    "WorksDeleteResponse",
    "WorksExportRequest",
    "WorksExportResponse",
    "WorksCountRequest",
    "WorksCountResponse",
]
