"""DevRev SDK Pydantic Models.

This module contains all Pydantic models for the DevRev API.
"""

from devrev.models.accounts import (
    Account,
    AccountsCreateRequest,
    AccountsCreateResponse,
    AccountsDeleteRequest,
    AccountsDeleteResponse,
    AccountsExportRequest,
    AccountsExportResponse,
    AccountsGetRequest,
    AccountsGetResponse,
    AccountsListRequest,
    AccountsListResponse,
    AccountsMergeRequest,
    AccountsMergeResponse,
    AccountSummary,
    AccountsUpdateRequest,
    AccountsUpdateResponse,
    AccountTier,
)
from devrev.models.articles import (
    Article,
    ArticlesCountRequest,
    ArticlesCountResponse,
    ArticlesCreateRequest,
    ArticlesCreateResponse,
    ArticlesDeleteRequest,
    ArticlesDeleteResponse,
    ArticlesGetRequest,
    ArticlesGetResponse,
    ArticlesListRequest,
    ArticlesListResponse,
    ArticleStatus,
    ArticleSummary,
    ArticlesUpdateRequest,
    ArticlesUpdateResponse,
)
from devrev.models.base import (
    CustomSchemaSpec,
    DateFilter,
    DateTimeFilter,
    DevRevBaseModel,
    DevRevResponseModel,
    ObjectSummary,
    OrgSummary,
    PaginatedResponse,
    SetTagWithValue,
    StageInfo,
    StageUpdate,
    TagWithValue,
    UserSummary,
)
from devrev.models.brands import (
    Brand,
    BrandsCreateRequest,
    BrandsCreateResponse,
    BrandsDeleteRequest,
    BrandsDeleteResponse,
    BrandsGetRequest,
    BrandsGetResponse,
    BrandsListRequest,
    BrandsListResponse,
    BrandsUpdateRequest,
    BrandsUpdateResponse,
)
from devrev.models.code_changes import (
    CodeChange,
    CodeChangesCreateRequest,
    CodeChangesCreateResponse,
    CodeChangesDeleteRequest,
    CodeChangesDeleteResponse,
    CodeChangesGetRequest,
    CodeChangesGetResponse,
    CodeChangesListRequest,
    CodeChangesListResponse,
    CodeChangeSummary,
    CodeChangesUpdateRequest,
    CodeChangesUpdateResponse,
)
from devrev.models.conversations import (
    Conversation,
    ConversationExportItem,
    ConversationsCreateRequest,
    ConversationsCreateResponse,
    ConversationsDeleteRequest,
    ConversationsDeleteResponse,
    ConversationsExportRequest,
    ConversationsExportResponse,
    ConversationsGetRequest,
    ConversationsGetResponse,
    ConversationsListRequest,
    ConversationsListResponse,
    ConversationSummary,
    ConversationsUpdateRequest,
    ConversationsUpdateResponse,
)
from devrev.models.dev_users import (
    DevUser,
    DevUserExternalIdentity,
    DevUsersActivateRequest,
    DevUsersActivateResponse,
    DevUsersCreateRequest,
    DevUsersCreateResponse,
    DevUsersDeactivateRequest,
    DevUsersDeactivateResponse,
    DevUsersGetRequest,
    DevUsersGetResponse,
    DevUsersIdentitiesLinkRequest,
    DevUsersIdentitiesLinkResponse,
    DevUsersIdentitiesUnlinkRequest,
    DevUsersIdentitiesUnlinkResponse,
    DevUsersListRequest,
    DevUsersListResponse,
    DevUsersMergeRequest,
    DevUsersMergeResponse,
    DevUsersSelfRequest,
    DevUsersSelfResponse,
    DevUsersSelfUpdateRequest,
    DevUsersSelfUpdateResponse,
    DevUserState,
    DevUserSummary,
    DevUsersUpdateRequest,
    DevUsersUpdateResponse,
)
from devrev.models.engagements import (
    Engagement,
    EngagementsCountRequest,
    EngagementsCountResponse,
    EngagementsCreateRequest,
    EngagementsCreateResponse,
    EngagementsDeleteRequest,
    EngagementsDeleteResponse,
    EngagementsGetRequest,
    EngagementsGetResponse,
    EngagementsListRequest,
    EngagementsListResponse,
    EngagementsUpdateRequest,
    EngagementsUpdateResponse,
    EngagementType,
)
from devrev.models.groups import (
    Group,
    GroupMember,
    GroupMembersAddRequest,
    GroupMembersAddResponse,
    GroupMembersListRequest,
    GroupMembersListResponse,
    GroupMembersRemoveRequest,
    GroupMembersRemoveResponse,
    GroupsCreateRequest,
    GroupsCreateResponse,
    GroupsGetRequest,
    GroupsGetResponse,
    GroupsListRequest,
    GroupsListResponse,
    GroupsMembersCountRequest,
    GroupsMembersCountResponse,
    GroupSummary,
    GroupsUpdateRequest,
    GroupsUpdateResponse,
    GroupType,
)
from devrev.models.incidents import (
    Incident,
    IncidentGroupItem,
    IncidentsCreateRequest,
    IncidentsCreateResponse,
    IncidentsDeleteRequest,
    IncidentsDeleteResponse,
    IncidentSeverity,
    IncidentsGetRequest,
    IncidentsGetResponse,
    IncidentsGroupRequest,
    IncidentsGroupResponse,
    IncidentsListRequest,
    IncidentsListResponse,
    IncidentStage,
    IncidentsUpdateRequest,
    IncidentsUpdateResponse,
)
from devrev.models.links import (
    Link,
    LinksCreateRequest,
    LinksCreateResponse,
    LinksDeleteRequest,
    LinksDeleteResponse,
    LinksGetRequest,
    LinksGetResponse,
    LinksListRequest,
    LinksListResponse,
    LinkSummary,
    LinkType,
)
from devrev.models.notifications import (
    NotificationsSendRequest,
    NotificationsSendResponse,
)
from devrev.models.parts import (
    Part,
    PartsCreateRequest,
    PartsCreateResponse,
    PartsDeleteRequest,
    PartsDeleteResponse,
    PartsGetRequest,
    PartsGetResponse,
    PartsListRequest,
    PartsListResponse,
    PartSummary,
    PartsUpdateRequest,
    PartsUpdateResponse,
    PartType,
)
from devrev.models.preferences import (
    Preferences,
    PreferencesGetRequest,
    PreferencesGetResponse,
    PreferencesUpdateRequest,
    PreferencesUpdateResponse,
)
from devrev.models.question_answers import (
    QuestionAnswer,
    QuestionAnswersCreateRequest,
    QuestionAnswersCreateResponse,
    QuestionAnswersDeleteRequest,
    QuestionAnswersGetRequest,
    QuestionAnswersGetResponse,
    QuestionAnswersListRequest,
    QuestionAnswersListResponse,
    QuestionAnswersUpdateRequest,
    QuestionAnswersUpdateResponse,
)
from devrev.models.recommendations import (
    ChatChoice,
    ChatCompletionRequest,
    ChatCompletionResponse,
    ChatMessage,
    GetReplyRequest,
    GetReplyResponse,
    MessageRole,
    TokenUsage,
)
from devrev.models.rev_users import (
    RevUser,
    RevUsersAssociationsAddRequest,
    RevUsersAssociationsAddResponse,
    RevUsersAssociationsListRequest,
    RevUsersAssociationsListResponse,
    RevUsersAssociationsRemoveRequest,
    RevUsersAssociationsRemoveResponse,
    RevUsersCreateRequest,
    RevUsersCreateResponse,
    RevUsersDeletePersonalDataRequest,
    RevUsersDeletePersonalDataResponse,
    RevUsersDeleteRequest,
    RevUsersDeleteResponse,
    RevUsersGetPersonalDataRequest,
    RevUsersGetPersonalDataResponse,
    RevUsersGetRequest,
    RevUsersGetResponse,
    RevUsersLinkRequest,
    RevUsersLinkResponse,
    RevUsersListRequest,
    RevUsersListResponse,
    RevUsersMergeRequest,
    RevUsersMergeResponse,
    RevUserState,
    RevUserSummary,
    RevUsersUnlinkRequest,
    RevUsersUnlinkResponse,
    RevUsersUpdateRequest,
    RevUsersUpdateResponse,
)
from devrev.models.search import (
    AccountSearchSummary,
    ArticleSearchSummary,
    ConversationSearchSummary,
    CoreSearchRequest,
    HybridSearchRequest,
    PartSearchSummary,
    SearchNamespace,
    SearchResponse,
    SearchResult,
    TagSearchSummary,
    UserSearchSummary,
    WorkSearchSummary,
)
from devrev.models.slas import (
    Sla,
    SlasCreateRequest,
    SlasCreateResponse,
    SlasGetRequest,
    SlasGetResponse,
    SlasListRequest,
    SlasListResponse,
    SlaStatus,
    SlasTransitionRequest,
    SlasTransitionResponse,
    SlaSummary,
    SlasUpdateRequest,
    SlasUpdateResponse,
    SlaTrackerStatus,
)
from devrev.models.sync import (
    ExternalRef,
    StagedInfo,
    SyncDirection,
    SyncMetadata,
    SyncStatus,
    SyncUnit,
    SyncUnitsGetRequest,
    SyncUnitsGetResponse,
    SyncUnitsListRequest,
    SyncUnitsListResponse,
)
from devrev.models.tags import (
    Tag,
    TagsCreateRequest,
    TagsCreateResponse,
    TagsDeleteRequest,
    TagsDeleteResponse,
    TagsGetRequest,
    TagsGetResponse,
    TagsListRequest,
    TagsListResponse,
    TagSummary,
    TagsUpdateRequest,
    TagsUpdateResponse,
)
from devrev.models.tasks import (
    Task,
    TaskPriority,
    TasksCreateRequest,
    TasksCreateResponse,
    TasksDeleteRequest,
    TasksDeleteResponse,
    TasksGetRequest,
    TasksGetResponse,
    TasksListRequest,
    TasksListResponse,
    TaskStatus,
    TasksUpdateRequest,
    TasksUpdateResponse,
)
from devrev.models.timeline_entries import (
    TimelineEntriesCreateRequest,
    TimelineEntriesCreateResponse,
    TimelineEntriesDeleteRequest,
    TimelineEntriesDeleteResponse,
    TimelineEntriesGetRequest,
    TimelineEntriesGetResponse,
    TimelineEntriesListRequest,
    TimelineEntriesListResponse,
    TimelineEntriesUpdateRequest,
    TimelineEntriesUpdateResponse,
    TimelineEntry,
    TimelineEntryType,
)
from devrev.models.timeline_events import (
    FieldChange,
    TimelineChangeEvent,
    TimelineEventsGetRequest,
    TimelineEventsGetResponse,
    TimelineEventsListRequest,
    TimelineEventsListResponse,
    TimelineEventType,
)
from devrev.models.track_events import (
    TrackEvent,
    TrackEventsPublishRequest,
    TrackEventsPublishResponse,
)
from devrev.models.uoms import (
    Uom,
    UomAggregationType,
    UomMetricScope,
    UomsCountRequest,
    UomsCountResponse,
    UomsCreateRequest,
    UomsCreateResponse,
    UomsDeleteRequest,
    UomsDeleteResponse,
    UomsGetRequest,
    UomsGetResponse,
    UomsListRequest,
    UomsListResponse,
    UomsUpdateRequest,
    UomsUpdateResponse,
)
from devrev.models.webhooks import (
    Webhook,
    WebhooksCreateRequest,
    WebhooksCreateResponse,
    WebhooksDeleteRequest,
    WebhooksDeleteResponse,
    WebhooksFetchRequest,
    WebhooksFetchResponse,
    WebhooksGetRequest,
    WebhooksGetResponse,
    WebhooksListRequest,
    WebhooksListResponse,
    WebhookStatus,
    WebhookSummary,
    WebhooksUpdateRequest,
    WebhooksUpdateResponse,
)
from devrev.models.widgets import (
    Widget,
    WidgetAggregationType,
    WidgetDataSource,
    WidgetDataSourceType,
    WidgetGroupByConfig,
    WidgetQuery,
    WidgetsGetRequest,
    WidgetsGetResponse,
    WidgetsListRequest,
    WidgetsListResponse,
    WidgetVisualizationType,
)
from devrev.models.works import (
    IssuePriority,
    TicketChannels,
    TicketSeverity,
    Work,
    WorksCountRequest,
    WorksCountResponse,
    WorksCreateRequest,
    WorksCreateResponse,
    WorksDeleteRequest,
    WorksDeleteResponse,
    WorksExportRequest,
    WorksExportResponse,
    WorksGetRequest,
    WorksGetResponse,
    WorksListRequest,
    WorksListResponse,
    WorkSummary,
    WorksUpdateRequest,
    WorksUpdateResponse,
    WorkType,
)

__all__ = [
    # Base models
    "DevRevBaseModel",
    "DevRevResponseModel",
    "PaginatedResponse",
    "DateFilter",
    "DateTimeFilter",
    "CustomSchemaSpec",
    "UserSummary",
    "ObjectSummary",
    "OrgSummary",
    "TagWithValue",
    "SetTagWithValue",
    "StageInfo",
    "StageUpdate",
    # Accounts
    "Account",
    "AccountSummary",
    "AccountTier",
    "AccountsCreateRequest",
    "AccountsCreateResponse",
    "AccountsGetRequest",
    "AccountsGetResponse",
    "AccountsListRequest",
    "AccountsListResponse",
    "AccountsUpdateRequest",
    "AccountsUpdateResponse",
    "AccountsDeleteRequest",
    "AccountsDeleteResponse",
    "AccountsMergeRequest",
    "AccountsMergeResponse",
    "AccountsExportRequest",
    "AccountsExportResponse",
    # Articles
    "Article",
    "ArticleSummary",
    "ArticleStatus",
    "ArticlesCountRequest",
    "ArticlesCountResponse",
    "ArticlesCreateRequest",
    "ArticlesCreateResponse",
    "ArticlesGetRequest",
    "ArticlesGetResponse",
    "ArticlesListRequest",
    "ArticlesListResponse",
    "ArticlesUpdateRequest",
    "ArticlesUpdateResponse",
    "ArticlesDeleteRequest",
    "ArticlesDeleteResponse",
    # Brands
    "Brand",
    "BrandsCreateRequest",
    "BrandsCreateResponse",
    "BrandsGetRequest",
    "BrandsGetResponse",
    "BrandsListRequest",
    "BrandsListResponse",
    "BrandsUpdateRequest",
    "BrandsUpdateResponse",
    "BrandsDeleteRequest",
    "BrandsDeleteResponse",
    # Code Changes
    "CodeChange",
    "CodeChangeSummary",
    "CodeChangesCreateRequest",
    "CodeChangesCreateResponse",
    "CodeChangesGetRequest",
    "CodeChangesGetResponse",
    "CodeChangesListRequest",
    "CodeChangesListResponse",
    "CodeChangesUpdateRequest",
    "CodeChangesUpdateResponse",
    "CodeChangesDeleteRequest",
    "CodeChangesDeleteResponse",
    # Conversations
    "Conversation",
    "ConversationExportItem",
    "ConversationSummary",
    "ConversationsCreateRequest",
    "ConversationsCreateResponse",
    "ConversationsGetRequest",
    "ConversationsGetResponse",
    "ConversationsListRequest",
    "ConversationsListResponse",
    "ConversationsUpdateRequest",
    "ConversationsUpdateResponse",
    "ConversationsDeleteRequest",
    "ConversationsDeleteResponse",
    "ConversationsExportRequest",
    "ConversationsExportResponse",
    # Dev Users
    "DevUser",
    "DevUserSummary",
    "DevUserState",
    "DevUserExternalIdentity",
    "DevUsersCreateRequest",
    "DevUsersCreateResponse",
    "DevUsersGetRequest",
    "DevUsersGetResponse",
    "DevUsersListRequest",
    "DevUsersListResponse",
    "DevUsersUpdateRequest",
    "DevUsersUpdateResponse",
    "DevUsersActivateRequest",
    "DevUsersActivateResponse",
    "DevUsersDeactivateRequest",
    "DevUsersDeactivateResponse",
    "DevUsersIdentitiesLinkRequest",
    "DevUsersIdentitiesLinkResponse",
    "DevUsersIdentitiesUnlinkRequest",
    "DevUsersIdentitiesUnlinkResponse",
    "DevUsersMergeRequest",
    "DevUsersMergeResponse",
    "DevUsersSelfRequest",
    "DevUsersSelfResponse",
    "DevUsersSelfUpdateRequest",
    "DevUsersSelfUpdateResponse",
    # Engagements
    "Engagement",
    "EngagementType",
    "EngagementsCreateRequest",
    "EngagementsCreateResponse",
    "EngagementsGetRequest",
    "EngagementsGetResponse",
    "EngagementsListRequest",
    "EngagementsListResponse",
    "EngagementsUpdateRequest",
    "EngagementsUpdateResponse",
    "EngagementsDeleteRequest",
    "EngagementsDeleteResponse",
    "EngagementsCountRequest",
    "EngagementsCountResponse",
    # Incidents
    "Incident",
    "IncidentStage",
    "IncidentSeverity",
    "IncidentGroupItem",
    "IncidentsCreateRequest",
    "IncidentsCreateResponse",
    "IncidentsGetRequest",
    "IncidentsGetResponse",
    "IncidentsListRequest",
    "IncidentsListResponse",
    "IncidentsUpdateRequest",
    "IncidentsUpdateResponse",
    "IncidentsDeleteRequest",
    "IncidentsDeleteResponse",
    "IncidentsGroupRequest",
    "IncidentsGroupResponse",
    # Groups
    "Group",
    "GroupSummary",
    "GroupType",
    "GroupMember",
    "GroupsCreateRequest",
    "GroupsCreateResponse",
    "GroupsGetRequest",
    "GroupsGetResponse",
    "GroupsListRequest",
    "GroupsListResponse",
    "GroupsMembersCountRequest",
    "GroupsMembersCountResponse",
    "GroupsUpdateRequest",
    "GroupsUpdateResponse",
    "GroupMembersAddRequest",
    "GroupMembersAddResponse",
    "GroupMembersRemoveRequest",
    "GroupMembersRemoveResponse",
    "GroupMembersListRequest",
    "GroupMembersListResponse",
    # Links
    "Link",
    "LinkSummary",
    "LinkType",
    "LinksCreateRequest",
    "LinksCreateResponse",
    "LinksGetRequest",
    "LinksGetResponse",
    "LinksListRequest",
    "LinksListResponse",
    "LinksDeleteRequest",
    "LinksDeleteResponse",
    # Notifications
    "NotificationsSendRequest",
    "NotificationsSendResponse",
    # Parts
    "Part",
    "PartSummary",
    "PartType",
    "PartsCreateRequest",
    "PartsCreateResponse",
    "PartsGetRequest",
    "PartsGetResponse",
    "PartsListRequest",
    "PartsListResponse",
    "PartsUpdateRequest",
    "PartsUpdateResponse",
    "PartsDeleteRequest",
    "PartsDeleteResponse",
    # Preferences
    "Preferences",
    "PreferencesGetRequest",
    "PreferencesGetResponse",
    "PreferencesUpdateRequest",
    "PreferencesUpdateResponse",
    # Question Answers
    "QuestionAnswer",
    "QuestionAnswersCreateRequest",
    "QuestionAnswersCreateResponse",
    "QuestionAnswersGetRequest",
    "QuestionAnswersGetResponse",
    "QuestionAnswersListRequest",
    "QuestionAnswersListResponse",
    "QuestionAnswersUpdateRequest",
    "QuestionAnswersUpdateResponse",
    "QuestionAnswersDeleteRequest",
    # Recommendations
    "MessageRole",
    "ChatMessage",
    "TokenUsage",
    "ChatChoice",
    "ChatCompletionRequest",
    "ChatCompletionResponse",
    "GetReplyRequest",
    "GetReplyResponse",
    # Rev Users
    "RevUser",
    "RevUserSummary",
    "RevUserState",
    "RevUsersAssociationsAddRequest",
    "RevUsersAssociationsAddResponse",
    "RevUsersAssociationsListRequest",
    "RevUsersAssociationsListResponse",
    "RevUsersAssociationsRemoveRequest",
    "RevUsersAssociationsRemoveResponse",
    "RevUsersCreateRequest",
    "RevUsersCreateResponse",
    "RevUsersDeletePersonalDataRequest",
    "RevUsersDeletePersonalDataResponse",
    "RevUsersDeleteRequest",
    "RevUsersDeleteResponse",
    "RevUsersGetPersonalDataRequest",
    "RevUsersGetPersonalDataResponse",
    "RevUsersGetRequest",
    "RevUsersGetResponse",
    "RevUsersLinkRequest",
    "RevUsersLinkResponse",
    "RevUsersListRequest",
    "RevUsersListResponse",
    "RevUsersMergeRequest",
    "RevUsersMergeResponse",
    "RevUsersUnlinkRequest",
    "RevUsersUnlinkResponse",
    "RevUsersUpdateRequest",
    "RevUsersUpdateResponse",
    # Search
    "SearchNamespace",
    "SearchResult",
    "CoreSearchRequest",
    "HybridSearchRequest",
    "SearchResponse",
    "AccountSearchSummary",
    "ArticleSearchSummary",
    "WorkSearchSummary",
    "UserSearchSummary",
    "ConversationSearchSummary",
    "PartSearchSummary",
    "TagSearchSummary",
    # Sync
    "SyncStatus",
    "SyncDirection",
    "SyncMetadata",
    "StagedInfo",
    "ExternalRef",
    "SyncUnit",
    "SyncUnitsGetRequest",
    "SyncUnitsGetResponse",
    "SyncUnitsListRequest",
    "SyncUnitsListResponse",
    # SLAs
    "Sla",
    "SlaSummary",
    "SlaStatus",
    "SlaTrackerStatus",
    "SlasCreateRequest",
    "SlasCreateResponse",
    "SlasGetRequest",
    "SlasGetResponse",
    "SlasListRequest",
    "SlasListResponse",
    "SlasUpdateRequest",
    "SlasUpdateResponse",
    "SlasTransitionRequest",
    "SlasTransitionResponse",
    # Tags
    "Tag",
    "TagSummary",
    "TagsCreateRequest",
    "TagsCreateResponse",
    "TagsGetRequest",
    "TagsGetResponse",
    "TagsListRequest",
    "TagsListResponse",
    "TagsUpdateRequest",
    "TagsUpdateResponse",
    "TagsDeleteRequest",
    "TagsDeleteResponse",
    # Tasks
    "Task",
    "TaskPriority",
    "TaskStatus",
    "TasksCreateRequest",
    "TasksCreateResponse",
    "TasksGetRequest",
    "TasksGetResponse",
    "TasksListRequest",
    "TasksListResponse",
    "TasksUpdateRequest",
    "TasksUpdateResponse",
    "TasksDeleteRequest",
    "TasksDeleteResponse",
    # Track Events
    "TrackEvent",
    "TrackEventsPublishRequest",
    "TrackEventsPublishResponse",
    # Timeline Entries
    "TimelineEntry",
    "TimelineEntryType",
    "TimelineEntriesCreateRequest",
    "TimelineEntriesCreateResponse",
    "TimelineEntriesGetRequest",
    "TimelineEntriesGetResponse",
    "TimelineEntriesListRequest",
    "TimelineEntriesListResponse",
    "TimelineEntriesUpdateRequest",
    "TimelineEntriesUpdateResponse",
    "TimelineEntriesDeleteRequest",
    "TimelineEntriesDeleteResponse",
    # Timeline Events
    "TimelineEventType",
    "FieldChange",
    "TimelineChangeEvent",
    "TimelineEventsGetRequest",
    "TimelineEventsGetResponse",
    "TimelineEventsListRequest",
    "TimelineEventsListResponse",
    # Webhooks
    "Webhook",
    "WebhookSummary",
    "WebhookStatus",
    "WebhooksCreateRequest",
    "WebhooksCreateResponse",
    "WebhooksFetchRequest",
    "WebhooksFetchResponse",
    "WebhooksGetRequest",
    "WebhooksGetResponse",
    "WebhooksListRequest",
    "WebhooksListResponse",
    "WebhooksUpdateRequest",
    "WebhooksUpdateResponse",
    "WebhooksDeleteRequest",
    "WebhooksDeleteResponse",
    # Works
    "Work",
    "WorkSummary",
    "WorkType",
    "IssuePriority",
    "TicketSeverity",
    "TicketChannels",
    "WorksCreateRequest",
    "WorksCreateResponse",
    "WorksGetRequest",
    "WorksGetResponse",
    "WorksListRequest",
    "WorksListResponse",
    "WorksUpdateRequest",
    "WorksUpdateResponse",
    "WorksDeleteRequest",
    "WorksDeleteResponse",
    "WorksExportRequest",
    "WorksExportResponse",
    "WorksCountRequest",
    "WorksCountResponse",
    # UOMs
    "Uom",
    "UomAggregationType",
    "UomMetricScope",
    "UomsCreateRequest",
    "UomsCreateResponse",
    "UomsGetRequest",
    "UomsGetResponse",
    "UomsListRequest",
    "UomsListResponse",
    "UomsUpdateRequest",
    "UomsUpdateResponse",
    "UomsDeleteRequest",
    "UomsDeleteResponse",
    "UomsCountRequest",
    "UomsCountResponse",
    # Widgets
    "WidgetVisualizationType",
    "WidgetDataSourceType",
    "WidgetAggregationType",
    "WidgetDataSource",
    "WidgetGroupByConfig",
    "WidgetQuery",
    "Widget",
    "WidgetsGetRequest",
    "WidgetsGetResponse",
    "WidgetsListRequest",
    "WidgetsListResponse",
]

# Rebuild models with forward references after all imports are complete
# This is necessary for TagWithValue which references Tag
# The explicit re-imports are needed because at module load time, only names
# are imported - we need access to the actual model classes to call model_rebuild()
from devrev.models.accounts import (  # noqa: F811
    Account as _Account,
)
from devrev.models.accounts import (
    AccountsExportResponse as _AccountsExportResponse,
)
from devrev.models.accounts import (
    AccountsListResponse as _AccountsListResponse,
)
from devrev.models.base import TagWithValue as _TagWithValue  # noqa: F811
from devrev.models.works import (  # noqa: F811
    Work as _Work,
)
from devrev.models.works import (
    WorksExportResponse as _WorksExportResponse,
)
from devrev.models.works import (
    WorksListResponse as _WorksListResponse,
)

# Rebuild models that use TagWithValue (which has forward ref to Tag)
_TagWithValue.model_rebuild()
_Account.model_rebuild()
_AccountsListResponse.model_rebuild()
_AccountsExportResponse.model_rebuild()
_Work.model_rebuild()
_WorksListResponse.model_rebuild()
_WorksExportResponse.model_rebuild()
