# Getting Started

Welcome to the DevRev Python SDK! This section will help you get up and running quickly.

## Overview

The DevRev Python SDK provides a modern, type-safe interface to the DevRev API. Whether you're building a support dashboard, automating workflows, or integrating DevRev with your existing tools, this SDK makes it easy.

## Prerequisites

Before you begin, ensure you have:

- **Python 3.11 or higher** installed
- A **DevRev account** with API access
- An **API token** from your DevRev dashboard

## Quick Navigation

<div class="grid cards" markdown>

-   :material-download:{ .lg .middle } **Installation**

    ---

    Install the SDK using pip, from source, or in a virtual environment.

    [:octicons-arrow-right-24: Install the SDK](installation.md)

-   :material-rocket-launch:{ .lg .middle } **Quick Start**

    ---

    Make your first API call in under 5 minutes.

    [:octicons-arrow-right-24: Quick Start Guide](quickstart.md)

-   :material-key:{ .lg .middle } **Authentication**

    ---

    Learn about API tokens, PATs, and service accounts.

    [:octicons-arrow-right-24: Authentication Guide](authentication.md)

</div>

## In This Section

1. [**Installation**](installation.md) - Multiple installation methods
2. [**Quick Start**](quickstart.md) - Your first API calls
3. [**Authentication**](authentication.md) - Secure authentication methods

## Need Help?

- Check out the [Guides](../guides/index.md) for in-depth tutorials
- Browse the [API Reference](../api/index.md) for detailed documentation
- View [Examples](../examples/index.md) for real-world use cases
- Open an [issue on GitHub](https://github.com/mgmonteleone/py-dev-rev/issues) for support

