from marshmallow import Schema, fields, validate


class FindingSerializer(Schema):
    active = fields.Bool(required=False)
    component_name = fields.Str(required=False)
    component_version = fields.Str(required=False)
    created = fields.Str(required=False)
    epss_score = fields.Int(required=False)
    epss_percentile = fields.Int(required=False)
    cvssv3 = fields.Str(required=False)
    cvssv3_score = fields.Int(required=False)
    cwe = fields.List(fields.Int, required=False)
    date = fields.Str(required=False)
    defect_review_requested_by = fields.List(fields.Int, required=False)
    description = fields.Str(required=False)
    duplicate = fields.Bool(required=False)
    duplicate_finding = fields.Int(required=False)
    dynamic_finding = fields.Bool(required=False)
    effort_for_fixing = fields.Str(required=False)
    endpoints = fields.List(fields.Int, required=False)
    false_p = fields.Bool(required=False)
    file_path = fields.Str(required=False)
    finding_group = fields.List(fields.Number, required=False)
    found_by = fields.List(fields.Int, required=False)
    has_jira = fields.Bool(required=False)
    has_tags = fields.Bool(required=False)
    hash_code = fields.Str(required=False)
    id = fields.List(fields.List(fields.Field()), required=False)
    impact = fields.Str(required=False)
    inherited_tags = fields.List(fields.List(fields.Field()), required=False)
    is_mitigated = fields.Bool(required=False)
    jira_change = fields.Str(required=False)
    jira_creation = fields.Str(required=False)
    last_reviewed = fields.Str(required=False)
    last_reviewed_by = fields.List(fields.Int, required=False)
    limit = fields.Int(required=False)
    mitigated = fields.Str(required=False)
    mitigated_by = fields.List(fields.Int, required=False)
    mitigation = fields.Str(required=False)
    nb_occurences = fields.List(fields.Int, required=False)
    not_tag = fields.Str(required=False)
    not_tags = fields.List(fields.Str, required=False)
    not_test__engagement__product__tags = fields.List(fields.Str, required=False)
    not_test__engagement__tags = fields.List(fields.Str, required=False)
    not_test__tags = fields.List(fields.Str, required=False)
    numerical_severity = fields.Str(required=False)
    offset = fields.Int(required=False)
    out_of_scope = fields.Bool(required=False)
    outside_of_sla = fields.Int(required=False)
    param = fields.Str(required=False)
    payload = fields.Str(required=False)
    planned_remediation_date = fields.Str(required=False)
    planned_remediation_version = fields.Str(required=False)
    prefetch = fields.List(fields.Str, required=False)
    product_name = fields.Str(required=False)
    product_name_contains = fields.Str(required=False)
    publish_date = fields.Str(required=False)
    references = fields.Str(required=False)
    related_fields = fields.Str(required=False)
    reporter = fields.List(fields.Int, required=False)
    review_request_by = fields.List(fields.Int, required=False)
    reviewers = fields.List(fields.Int, required=False)
    risk_accetance = fields.Int(required=False)
    risk_status = fields.Str(
        required=False, validate=validate.OneOf(["Risk Pending", "Risk Rejected", "Risk Expired", "Risk Accepted", "Risk Active", "Transfer Pending", "Transfer Rejected", "Transfer Expired", "Transfer Accepted", "On Whitelist", "On Blacklist"])
    )
    risk_accepted = fields.Bool(required=False)
    sast_sink_object = fields.Str(required=False)
    sast_source_object = fields.Str(required=False)
    scanner_confidence = fields.List(fields.Int, required=False)
    service = fields.Str(required=False)
    severity = fields.Str(required=False)
    severity_justification = fields.Str(required=False)
    sla_start_date = fields.Str(required=False)
    sonarqube_issue = fields.List(fields.Int, required=False)
    static_finding = fields.Bool(required=False)
    steps_to_reproduce = fields.Str(required=False)
    tag = fields.Str(required=False)
    tags = fields.Str(required=False)
    test = fields.Int(required=False)
    test__engagement = fields.List(fields.Int, required=False)
    test__engagement__product = fields.List(fields.Int, required=False)
    test__engagement__product__prod_type = fields.List(fields.Int, required=False)
    test__engagement__product__tags = fields.List(fields.Int, required=False)
    test__engagement__tags = fields.List(fields.Str, required=False)
    test__tags = fields.List(fields.Str, required=False)
    test__test_type = fields.List(fields.Int, required=False)
    title = fields.Str(required=False)
    under_defect_review = fields.Bool(required=False)
    under_review = fields.Bool(required=False)
    unique_id_from_tool = fields.Str(required=False)
    verified = fields.Bool(required=False)
    vuln_id_from_tool = fields.Str(required=False)
    vulnerability_id = fields.Str(required=False)
    priority_classification = fields.Str(required=False)
    priority = fields.Str(required=False)
    fields = fields.Str(required=False)

class FindingCloseSerializer(Schema):
    is_mitigated = fields.Bool(required=False)
    mitigated = fields.Bool(required=False)
    detail = fields.Str(required=False)
    message = fields.Str(required=False)
