from abc import ABCMeta, abstractmethod

from devsecops_engine_tools.engine_core.src.domain.model.vulnerability_management import VulnerabilityManagement
from devsecops_engine_tools.engine_core.src.domain.model.gateway.devops_platform_gateway import DevopsPlatformGateway

class VulnerabilityManagementGateway(metaclass=ABCMeta):
    @abstractmethod
    def send_vulnerability_management(
        self, vulnerability_management: VulnerabilityManagement
    ):
        "send_vulnerability_management"

    @abstractmethod
    def get_product_type_service(self, service, dict_args, secret_tool, config_tool):
        "get_product_type_service"

    @abstractmethod
    def get_findings_excepted(
        self, service, dict_args, secret_tool, config_tool
    ):
        "get_findings_excepted"

    @abstractmethod
    def get_all(
        self, service, dict_args, secret_tool, config_tool
    ):
        "get all findings and exclusions from vulnerability management platform"

    @abstractmethod
    def get_active_engagements(
        self, engagement_name, dict_args, secret_tool, config_tool
    ):
        "get_active_engagements"

    @abstractmethod
    def send_sbom_components(
        self, sbom_components, service, dict_args, secret_tool, config_tool
    ):
        "send_sbom_components"

    @abstractmethod
    def get_black_list(
        self, dict_args, secret_tool, config_tool
    ):
        "get_black_list"
