from abc import ABCMeta, abstractmethod

from devsecops_engine_tools.engine_core.src.domain.model.vulnerability_management import VulnerabilityManagement


class VulnerabilityManagementGateway(metaclass=ABCMeta):
    @abstractmethod
    def send_vulnerability_management(
        self, vulnerability_management: VulnerabilityManagement
    ):
        "send_vulnerability_management"

    @abstractmethod
    def get_findings_excepted(
        self, service, dict_args, secret_tool, config_tool
    ):
        "get_findings_excepted"

    @abstractmethod
    def get_all_findings(
        self, service, dict_args, secret_tool, config_tool
    ):
        "get_report"
