# Contributing

Scikit-Optimize is an open-source project and contributions of all kinds
are welcome. We believe in this [code of conduct](CONDUCT.md).

You can contribute with documentation, examples, reviewing pull requests, code,
helping answer questions in issues, creating visualizations, maintaining project
infrastructure, and writing user stories. All of these are equally important
and the current contributors don't (yet) cover all of these topics. Code
contributions are our strong point, so help us help you to make other types of
contributions.

Contributions should follow these guidelines:

* all changes by pull request (PR);
* please prefix the title of your pull request with `[MRG]` if the contribution
  is complete and should be subjected to a detailed review;
* create a PR as early as possible, marking it with `[WIP]` while you work on
  it (good to avoid duplicated work, get broad review of functionality or API,
  or seek collaborators);
* a PR solves one problem (do not mix problems together in one PR) with the
  minimal set of changes;
* describe why you are proposing the changes you are proposing;
* try to not rush changes (the definition of rush depends on how big your
  changes are);
* someone else has to merge your PR;
* new code needs to come with a test;
* apply [PEP8](https://www.python.org/dev/peps/pep-0008/) as much
  as possible, but not too much;
* no merging if travis is red.

These are not hard rules to be enforced by :police_car: but instead guidelines.
