<br/>
<p align="center">
  <a href="https://github.com/crackedngineer/digipin-python">
    <img src="./header-image.png" alt="digipin-python" />
  </a>

  <p align="center">
    A Python library for encoding geographic coordinates into a 10-digit alphanumeric DIGIPIN and decoding a DIGIPIN back into its approximate central latitude and longitude.
    <br/>
    <br/>
    <!-- <a href="https://github.com/subhomoy-roy-choudhury/digipin-python"><strong>Explore the docs »</strong></a>
    <br/>
    <br/>
    <a href="https://github.com/subhomoy-roy-choudhury/digipin-python">View Demo</a>
    . -->
    <a href="https://github.com/crackedngineer/digipin-python/issues">Report Bug</a>
    .
    <a href="https://github.com/crackedngineer/digipin-python/issues">Request Feature</a>
  </p>
</p>

<p align="center">
    <img alt="Downloads" src="https://img.shields.io/github/downloads/crackedngineer/digipin-python/total" />
    <img alt="GitHub Contributors" src="https://img.shields.io/github/contributors/crackedngineer/digipin-python?color=dark-green" />
    <img alt="Github Issues" src="https://img.shields.io/github/issues/crackedngineer/digipin-python" />
    <img alt="GitHub Last Commit" src="https://img.shields.io/github/last-commit/crackedngineer/digipin-python" />
    <img alt="Repo Size" src="https://img.shields.io/github/repo-size/crackedngineer/digipin-python" />
    <img alt="GitHub Pull Requests" src="https://img.shields.io/github/issues-pr/crackedngineer/digipin-python" />
    <img alt="Github License" src="https://img.shields.io/github/license/crackedngineer/digipin-python" />
    <img alt="Test Cases" src="https://github.com/crackedngineer/digipin-python/actions/workflows/publish.yml/badge.svg" />

</p>

## Table Of Contents

-   [Features](#features)
-   [Getting Started](#getting-started)
-   [Usage](#usage)
-   [License](#license)
-   [Acknowledgements](#acknowledgements)

## ✨ Features

-   🔢 **Encode**: Convert latitude and longitude into a unique 10-digit DIGIPIN.

-   🔍 **Decode**: Convert a DIGIPIN back to its central latitude and longitude.

-   ✅ **Validation**:

    -   Latitude/longitude bounds checking.

    -   Format checks for DIGIPIN strings.

## 📦 Getting Started

Install digipin-python with pip

```bash
  pip install digipin-python
```

Or clone the repository:

```bash
git clone https://github.com/crackedngineer/digipin-python.git
cd digipin-python
pip install -e .
```

## 🚀 Usage

Read the Documentation [here](https://github.com/crackedngineer/digipin-python/blob/master/example/main.py)

## 📄 License

Distributed under the MIT License. See [LICENSE](https://github.com/crackedngineer/digipin-python/blob/master/LICENSE) for more information.

## 💛 Support This Project

If this project helps you discover amazing tools or saves your time, consider supporting it:

☕ [**Buy Me a Coffee**](https://buymeacoffee.com/crackedngineer) — Every bit helps keep the lights on!

📬 **Contact:** subhomoyrchoudhury@gmail.com

---

## 🙏 Acknowledgements

-   [Digipin by India Post](https://www.indiapost.gov.in/VAS/Pages/digipin.aspx)

---

Made in India with ❤️ by [crackedngineer](https://github.com/crackedngineer)
