# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.config_templates import ConfigTemplates
from openapi_server import util

from openapi_server.models.config_templates import ConfigTemplates  # noqa: E501

class Config(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, labels=None, annotations=None, files=None, templates=None):  # noqa: E501
        """Config - a model defined in OpenAPI

        :param name: The name of this Config.  # noqa: E501
        :type name: str
        :param labels: The labels of this Config.  # noqa: E501
        :type labels: List[str]
        :param annotations: The annotations of this Config.  # noqa: E501
        :type annotations: List[str]
        :param files: The files of this Config.  # noqa: E501
        :type files: List[str]
        :param templates: The templates of this Config.  # noqa: E501
        :type templates: ConfigTemplates
        """
        self.openapi_types = {
            'name': str,
            'labels': List[str],
            'annotations': List[str],
            'files': List[str],
            'templates': ConfigTemplates
        }

        self.attribute_map = {
            'name': 'name',
            'labels': 'labels',
            'annotations': 'annotations',
            'files': 'files',
            'templates': 'templates'
        }

        self._name = name
        self._labels = labels
        self._annotations = annotations
        self._files = files
        self._templates = templates

    @classmethod
    def from_dict(cls, dikt) -> 'Config':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Config of this Config.  # noqa: E501
        :rtype: Config
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Config.

        The config map name  # noqa: E501

        :return: The name of this Config.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Config.

        The config map name  # noqa: E501

        :param name: The name of this Config.
        :type name: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this Config.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Config.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Config.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Config.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def annotations(self):
        """Gets the annotations of this Config.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this Config.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Config.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this Config.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def files(self):
        """Gets the files of this Config.

        the list of config file paths  # noqa: E501

        :return: The files of this Config.
        :rtype: List[str]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this Config.

        the list of config file paths  # noqa: E501

        :param files: The files of this Config.
        :type files: List[str]
        """

        self._files = files

    @property
    def templates(self):
        """Gets the templates of this Config.


        :return: The templates of this Config.
        :rtype: ConfigTemplates
        """
        return self._templates

    @templates.setter
    def templates(self, templates):
        """Sets the templates of this Config.


        :param templates: The templates of this Config.
        :type templates: ConfigTemplates
        """

        self._templates = templates
