# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.container_sec_context_capabilities import ContainerSecContextCapabilities
from openapi_server import util

from openapi_server.models.container_sec_context_capabilities import ContainerSecContextCapabilities  # noqa: E501

class ContainerSecContext(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, run_as_user=None, run_as_group=None, allow_privilege_escalation=None, capabilities=None):  # noqa: E501
        """ContainerSecContext - a model defined in OpenAPI

        :param run_as_user: The run_as_user of this ContainerSecContext.  # noqa: E501
        :type run_as_user: int
        :param run_as_group: The run_as_group of this ContainerSecContext.  # noqa: E501
        :type run_as_group: int
        :param allow_privilege_escalation: The allow_privilege_escalation of this ContainerSecContext.  # noqa: E501
        :type allow_privilege_escalation: bool
        :param capabilities: The capabilities of this ContainerSecContext.  # noqa: E501
        :type capabilities: ContainerSecContextCapabilities
        """
        self.openapi_types = {
            'run_as_user': int,
            'run_as_group': int,
            'allow_privilege_escalation': bool,
            'capabilities': ContainerSecContextCapabilities
        }

        self.attribute_map = {
            'run_as_user': 'run_as_user',
            'run_as_group': 'run_as_group',
            'allow_privilege_escalation': 'allow_privilege_escalation',
            'capabilities': 'capabilities'
        }

        self._run_as_user = run_as_user
        self._run_as_group = run_as_group
        self._allow_privilege_escalation = allow_privilege_escalation
        self._capabilities = capabilities

    @classmethod
    def from_dict(cls, dikt) -> 'ContainerSecContext':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ContainerSecContext of this ContainerSecContext.  # noqa: E501
        :rtype: ContainerSecContext
        """
        return util.deserialize_model(dikt, cls)

    @property
    def run_as_user(self):
        """Gets the run_as_user of this ContainerSecContext.

        The UID to run the entrypoint of the container process.  # noqa: E501

        :return: The run_as_user of this ContainerSecContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """Sets the run_as_user of this ContainerSecContext.

        The UID to run the entrypoint of the container process.  # noqa: E501

        :param run_as_user: The run_as_user of this ContainerSecContext.
        :type run_as_user: int
        """

        self._run_as_user = run_as_user

    @property
    def run_as_group(self):
        """Gets the run_as_group of this ContainerSecContext.

        The GID to run the entrypoint of the container process.  # noqa: E501

        :return: The run_as_group of this ContainerSecContext.
        :rtype: int
        """
        return self._run_as_group

    @run_as_group.setter
    def run_as_group(self, run_as_group):
        """Sets the run_as_group of this ContainerSecContext.

        The GID to run the entrypoint of the container process.  # noqa: E501

        :param run_as_group: The run_as_group of this ContainerSecContext.
        :type run_as_group: int
        """

        self._run_as_group = run_as_group

    @property
    def allow_privilege_escalation(self):
        """Gets the allow_privilege_escalation of this ContainerSecContext.

        It is used to control whether a container running within a Kubernetes cluster is allowed to escalate its privileges beyond the initial permissions granted to it when it starts.  # noqa: E501

        :return: The allow_privilege_escalation of this ContainerSecContext.
        :rtype: bool
        """
        return self._allow_privilege_escalation

    @allow_privilege_escalation.setter
    def allow_privilege_escalation(self, allow_privilege_escalation):
        """Sets the allow_privilege_escalation of this ContainerSecContext.

        It is used to control whether a container running within a Kubernetes cluster is allowed to escalate its privileges beyond the initial permissions granted to it when it starts.  # noqa: E501

        :param allow_privilege_escalation: The allow_privilege_escalation of this ContainerSecContext.
        :type allow_privilege_escalation: bool
        """

        self._allow_privilege_escalation = allow_privilege_escalation

    @property
    def capabilities(self):
        """Gets the capabilities of this ContainerSecContext.


        :return: The capabilities of this ContainerSecContext.
        :rtype: ContainerSecContextCapabilities
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """Sets the capabilities of this ContainerSecContext.


        :param capabilities: The capabilities of this ContainerSecContext.
        :type capabilities: ContainerSecContextCapabilities
        """

        self._capabilities = capabilities
