# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class Toleration(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, key=None, operator=None, value=None, effect=None, toleration_seconds=None):  # noqa: E501
        """Toleration - a model defined in OpenAPI

        :param key: The key of this Toleration.  # noqa: E501
        :type key: str
        :param operator: The operator of this Toleration.  # noqa: E501
        :type operator: str
        :param value: The value of this Toleration.  # noqa: E501
        :type value: str
        :param effect: The effect of this Toleration.  # noqa: E501
        :type effect: str
        :param toleration_seconds: The toleration_seconds of this Toleration.  # noqa: E501
        :type toleration_seconds: int
        """
        self.openapi_types = {
            'key': str,
            'operator': str,
            'value': str,
            'effect': str,
            'toleration_seconds': int
        }

        self.attribute_map = {
            'key': 'key',
            'operator': 'operator',
            'value': 'value',
            'effect': 'effect',
            'toleration_seconds': 'toleration_seconds'
        }

        self._key = key
        self._operator = operator
        self._value = value
        self._effect = effect
        self._toleration_seconds = toleration_seconds

    @classmethod
    def from_dict(cls, dikt) -> 'Toleration':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Toleration of this Toleration.  # noqa: E501
        :rtype: Toleration
        """
        return util.deserialize_model(dikt, cls)

    @property
    def key(self):
        """Gets the key of this Toleration.

        The taint key that the toleration applies to.  # noqa: E501

        :return: The key of this Toleration.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Toleration.

        The taint key that the toleration applies to.  # noqa: E501

        :param key: The key of this Toleration.
        :type key: str
        """

        self._key = key

    @property
    def operator(self):
        """Gets the operator of this Toleration.

        The operator of the toleration.  # noqa: E501

        :return: The operator of this Toleration.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """Sets the operator of this Toleration.

        The operator of the toleration.  # noqa: E501

        :param operator: The operator of this Toleration.
        :type operator: str
        """
        allowed_values = ["Equal", "Exists"]  # noqa: E501
        if operator not in allowed_values:
            raise ValueError(
                "Invalid value for `operator` ({0}), must be one of {1}"
                .format(operator, allowed_values)
            )

        self._operator = operator

    @property
    def value(self):
        """Gets the value of this Toleration.

        The taint value the toleration matches to.  # noqa: E501

        :return: The value of this Toleration.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this Toleration.

        The taint value the toleration matches to.  # noqa: E501

        :param value: The value of this Toleration.
        :type value: str
        """

        self._value = value

    @property
    def effect(self):
        """Gets the effect of this Toleration.

        The effect of the toleration.  # noqa: E501

        :return: The effect of this Toleration.
        :rtype: str
        """
        return self._effect

    @effect.setter
    def effect(self, effect):
        """Sets the effect of this Toleration.

        The effect of the toleration.  # noqa: E501

        :param effect: The effect of this Toleration.
        :type effect: str
        """
        allowed_values = ["NoSchedule", "PreferNoSchedule", "NoExecute"]  # noqa: E501
        if effect not in allowed_values:
            raise ValueError(
                "Invalid value for `effect` ({0}), must be one of {1}"
                .format(effect, allowed_values)
            )

        self._effect = effect

    @property
    def toleration_seconds(self):
        """Gets the toleration_seconds of this Toleration.

        The tolerationSeconds of the toleration.  # noqa: E501

        :return: The toleration_seconds of this Toleration.
        :rtype: int
        """
        return self._toleration_seconds

    @toleration_seconds.setter
    def toleration_seconds(self, toleration_seconds):
        """Sets the toleration_seconds of this Toleration.

        The tolerationSeconds of the toleration.  # noqa: E501

        :param toleration_seconds: The toleration_seconds of this Toleration.
        :type toleration_seconds: int
        """

        self._toleration_seconds = toleration_seconds
