# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class VolumeEmptyDir(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, medium=None, size_limit=None):  # noqa: E501
        """VolumeEmptyDir - a model defined in OpenAPI

        :param medium: The medium of this VolumeEmptyDir.  # noqa: E501
        :type medium: str
        :param size_limit: The size_limit of this VolumeEmptyDir.  # noqa: E501
        :type size_limit: str
        """
        self.openapi_types = {
            'medium': str,
            'size_limit': str
        }

        self.attribute_map = {
            'medium': 'medium',
            'size_limit': 'size_limit'
        }

        self._medium = medium
        self._size_limit = size_limit

    @classmethod
    def from_dict(cls, dikt) -> 'VolumeEmptyDir':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Volume_empty_dir of this VolumeEmptyDir.  # noqa: E501
        :rtype: VolumeEmptyDir
        """
        return util.deserialize_model(dikt, cls)

    @property
    def medium(self):
        """Gets the medium of this VolumeEmptyDir.

        Represents what type of storage medium should back this directory. The default is \"\" which means to use the node's default medium.  # noqa: E501

        :return: The medium of this VolumeEmptyDir.
        :rtype: str
        """
        return self._medium

    @medium.setter
    def medium(self, medium):
        """Sets the medium of this VolumeEmptyDir.

        Represents what type of storage medium should back this directory. The default is \"\" which means to use the node's default medium.  # noqa: E501

        :param medium: The medium of this VolumeEmptyDir.
        :type medium: str
        """

        self._medium = medium

    @property
    def size_limit(self):
        """Gets the size_limit of this VolumeEmptyDir.

        The total amount of local storage required for this EmptyDir volume.  # noqa: E501

        :return: The size_limit of this VolumeEmptyDir.
        :rtype: str
        """
        return self._size_limit

    @size_limit.setter
    def size_limit(self, size_limit):
        """Sets the size_limit of this VolumeEmptyDir.

        The total amount of local storage required for this EmptyDir volume.  # noqa: E501

        :param size_limit: The size_limit of this VolumeEmptyDir.
        :type size_limit: str
        """

        self._size_limit = size_limit
