# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class VolumeHostPath(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, path=None, path_type=None):  # noqa: E501
        """VolumeHostPath - a model defined in OpenAPI

        :param path: The path of this VolumeHostPath.  # noqa: E501
        :type path: str
        :param path_type: The path_type of this VolumeHostPath.  # noqa: E501
        :type path_type: str
        """
        self.openapi_types = {
            'path': str,
            'path_type': str
        }

        self.attribute_map = {
            'path': 'path',
            'path_type': 'path_type'
        }

        self._path = path
        self._path_type = path_type

    @classmethod
    def from_dict(cls, dikt) -> 'VolumeHostPath':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Volume_host_path of this VolumeHostPath.  # noqa: E501
        :rtype: VolumeHostPath
        """
        return util.deserialize_model(dikt, cls)

    @property
    def path(self):
        """Gets the path of this VolumeHostPath.

        Path of the directory on the host. If the path is a symlink, it will follow the link to the real path  # noqa: E501

        :return: The path of this VolumeHostPath.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this VolumeHostPath.

        Path of the directory on the host. If the path is a symlink, it will follow the link to the real path  # noqa: E501

        :param path: The path of this VolumeHostPath.
        :type path: str
        """

        self._path = path

    @property
    def path_type(self):
        """Gets the path_type of this VolumeHostPath.

        Type for HostPath Volume Defaults to \"\"  # noqa: E501

        :return: The path_type of this VolumeHostPath.
        :rtype: str
        """
        return self._path_type

    @path_type.setter
    def path_type(self, path_type):
        """Sets the path_type of this VolumeHostPath.

        Type for HostPath Volume Defaults to \"\"  # noqa: E501

        :param path_type: The path_type of this VolumeHostPath.
        :type path_type: str
        """

        self._path_type = path_type
