[![Build Status](https://drone.quving.com/api/badges/Quving/directus-python-client/status.svg)](https://drone.quving.com/Quving/directus-python-client)

# Directus-Python-Client

This library aims to provide a simple and easy to use interface to the Directus API. It is written in Python and uses
the requests library.

## Motivation

Working with APIs can sometimes be a bit cumbersome. If you are not careful, boilerplates can quickly lead to code
duplication. Most of the time they come from similar workflows. Like authentication, request header configuration or
just the execution of the request itself.

## Documentation

### Authentication

```python
from directus_api import DirectusApi

# Authentication
api = DirectusApi(username="username", password="password", endpoint="https://directus.example.com")
```

### Items

Retrieve Items:

```python
...
# (Optional) Add filter_dict to filter items.
# (Optional) Add arg 'show_progress' to show progress bar.
# (Optional) Add 'limit' to limit the number of items to retrieve. If None all items will be returned. 
items = api.get_items(collection="collection_name",
                      limit=42,
                      filter_dict={'match_id': {'_eq': 'wzi6xmt37'}},
                      show_progress=True)

print(items)
```

Create Items:

```python
...

# Create a single item or multiple items
item = api.create_items(collection="collection_name", data=[{"title": "My new item"}])

```

Update Items:

```python
...

# Update a single item or multiple items. Primary key (here 'id') is required.
item = api.update_items(collection="collection_name", data=[{"title": "My updated item", "id": 1}])

```

Delete Items:

```python
...
# Delete a single item by id from a collection
item = api.delete_item_by_id(collection="collection_name", id=1)

# Delete all items from a collection
item = api.delete_items_by_ids(collection="collection_name", ids=[1, 2, 3])

```

```

#

...

