# Generated by Django 3.2.15 on 2022-08-10 19:19

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import django_e2ee.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sessions", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="EncryptionKey",
            fields=[
                (
                    "uuid",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="The user who created this key.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MasterKey",
            fields=[
                (
                    "user",
                    models.OneToOneField(
                        help_text="The user that this key belongs to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="master_key",
                        serialize=False,
                        to="auth.user",
                    ),
                ),
                (
                    "pubkey",
                    models.TextField(
                        help_text="The exported public key.",
                        max_length=1000,
                        unique=True,
                        validators=[django_e2ee.models.validate_public_key],
                    ),
                ),
                (
                    "signing_pubkey",
                    models.TextField(
                        help_text="The exported public key.",
                        max_length=1000,
                        unique=True,
                        validators=[django_e2ee.models.validate_public_key],
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SessionKey",
            fields=[
                (
                    "session",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="sessions.session",
                    ),
                ),
                (
                    "ignore",
                    models.BooleanField(
                        default=False,
                        help_text="Ignore E2E for this session and do not ask again.",
                    ),
                ),
                (
                    "session_secret",
                    models.TextField(
                        blank=True,
                        help_text="The encrypted AES-GCM key of the session.",
                        max_length=5000,
                        null=True,
                    ),
                ),
                (
                    "secret",
                    models.TextField(
                        blank=True,
                        help_text="The encrypted RSA-OAEP private key of the user.",
                        max_length=5000,
                        null=True,
                    ),
                ),
                (
                    "signing_secret",
                    models.TextField(
                        blank=True,
                        help_text="The encrypted RSA-PSS private key of the user.",
                        max_length=5000,
                        null=True,
                    ),
                ),
                (
                    "iv",
                    models.CharField(
                        blank=True,
                        help_text="The vector data used when wrapping the private key.",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "master_key",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="e2ee.masterkey",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MasterKeySecret",
            fields=[
                (
                    "uuid",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                (
                    "identifier",
                    models.CharField(
                        max_length=100,
                        help_text="Identifier for this secret",
                    ),
                ),
                (
                    "secret",
                    models.TextField(
                        help_text="The encrypted RSA-OAEP private key.",
                        max_length=5000,
                    ),
                ),
                (
                    "signing_secret",
                    models.TextField(
                        help_text="The encrypted RSA-PSS private key.",
                        max_length=5000,
                    ),
                ),
                (
                    "salt",
                    models.CharField(
                        blank=True,
                        help_text="The salt that has been used to generate the AES key that encrypted the :attr:`secret`. Only necessary if the AES key has been derived from a PBKDF2 key.",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "iv",
                    models.CharField(
                        help_text="The vector data used when wrapping the key.",
                        max_length=50,
                    ),
                ),
                (
                    "master_key",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="e2ee.masterkey",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EncryptionKeySecret",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "secret",
                    models.TextField(
                        help_text="The AES-Key of the encryption key, encrypted with the master key.",
                        max_length=5000,
                    ),
                ),
                (
                    "signature",
                    models.TextField(
                        help_text="The signature of the secret signed by the user who created this.",
                        max_length=5000,
                    ),
                ),
                (
                    "encrypted_with",
                    models.ForeignKey(
                        help_text="The master key that encrypted this secret.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="e2ee.masterkey",
                    ),
                ),
                (
                    "encryption_key",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="e2ee.encryptionkey",
                    ),
                ),
                (
                    "signed_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="The master key that created and signed this secret.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="signed_secrets",
                        to="e2ee.masterkey",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="encryptionkey",
            name="master_keys",
            field=models.ManyToManyField(
                blank=True,
                through="e2ee.EncryptionKeySecret",
                to="e2ee.MasterKey",
            ),
        ),
        migrations.AddConstraint(
            model_name="masterkeysecret",
            constraint=models.UniqueConstraint(
                fields=("identifier", "master_key"),
                name="unique_master_key_identifier_for_user",
            ),
        ),
        migrations.AddConstraint(
            model_name="encryptionkeysecret",
            constraint=models.UniqueConstraint(
                fields=("encryption_key", "encrypted_with"),
                name="unique_encryption_key_for_user",
            ),
        ),
    ]
