import glob, requests
from typing import Optional
from django.template import Library
from django.utils.translation import gettext
from .. import BASE_DIR
from ..constants import HTTP_ERROR_CODES
from ..utils import local_node_package

register = Library()


@register.inclusion_tag('django_node_modules/includes/local_node_packages.html')
def local_node_js_package(package_name: str, path: Optional[str] = None, recursive: bool = False, module: bool = False):
    return local_node_package(package_name, path, recursive, 'js', module=module)


@register.inclusion_tag('django_node_modules/includes/local_node_packages.html')
def local_node_css_package(package_name: str, path: Optional[str] = None, recursive: bool = False):
    return local_node_package(package_name, path, recursive, 'css')


@register.inclusion_tag('django_node_modules/includes/npm_node_packages.html')
def npm_node_package(package_name: str, version: Optional[str] = None, path: str = '', **kwargs):
    attrs = ''
    for key, value in kwargs.items():
        attrs += f' {key.replace('_', '-')}="{value}"'

    url = f'https://cdn.jsdelivr.net/npm/{package_name}'
    if version:
        url += f'@{version}/'
    url += path
    response = requests.get(url)
    status_code = response.status_code
    return dict(url=url, status=status_code,
                error_message=HTTP_ERROR_CODES.get(status_code, '') + ':',
                message=response.text, attrs=attrs)
