import filetype, os, glob
from typing import Optional
from pathlib import Path
from urllib.parse import urlparse
from contextlib import contextmanager
from django.urls import reverse
from . import NODE_MODULES_DIR


def remove_protocol_and_domain(url, no_extras: bool = False, return_parsed: bool = False):
    parsed = urlparse(url)
    result = parsed.path
    if not no_extras:
        if parsed.query:
            result += '?' + parsed.query
        if parsed.fragment:
            result += '#' + parsed.fragment
    if return_parsed:
        return parsed
    return result if result else '/'


@contextmanager
def change_dir(destination):
    original_dir = os.getcwd()
    try:
        os.chdir(destination)
        yield
    finally:
        os.chdir(original_dir)


def local_node_file_path(path):
    return NODE_MODULES_DIR / path


def local_node_file(path, **kwargs):
    return open(local_node_file_path(path), **kwargs)


def node_inclusion_context(files: list, type: str, **kwargs):
    return dict(files=files, type=type, **kwargs)


def local_node_package(package_name: str, path: Optional[str] = None, recursive: bool = False,
                       type: Optional[str] = None, **kwargs):
    package_path = NODE_MODULES_DIR / package_name
    with change_dir(package_path):
        files = list()
        path_lst = glob.glob(f'*.{type}', recursive=recursive) if path is None else [path]
        for f in path_lst:
            files.append(reverse('local_node_file',
                                 kwargs=dict(path=os.path.join(package_name, f))))
    return node_inclusion_context(files, type, **kwargs)
