from django.http import FileResponse, Http404
from static_engine.views import view_constructor
from . import NODE_MODULES_DIR, ALLOWED_NODE_MODULES, LOCAL_NODE_MODULES_BASE_URL
from .utils import remove_protocol_and_domain

local_node_view = view_constructor(NODE_MODULES_DIR)


def local_node_file(request, path):
    url = remove_protocol_and_domain(request.build_absolute_uri(), True)[1:]
    if ALLOWED_NODE_MODULES != '__all__':
        for module in ALLOWED_NODE_MODULES:
            if url.startswith('/'.join((LOCAL_NODE_MODULES_BASE_URL, module))):
                break
        else:
            raise Http404
    return local_node_view(request, path)


# def local_node_package_constructor(package_name: str):
#     def view(request, path: str):
#         with open(NODE_MODULES_DIR / package_name / path, 'rb') as file:
#             return FileResponse(file, content_type=get_mime_type(path))
#
#     return view

